const app = getApp()

Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    uid: app.globalData.uid,
    h_t: wx.getSystemInfoSync().windowHeight,
    to: [false, false, false],
    ok: false
  },
  onLoad: function (o) {
    if (o.scene) {
      let s = decodeURIComponent(o.scene).split('&')
      for (let e in s) {
        s[e] = s[e].split('=')
        o[s[e][0]] = s[e][1] || 0
      }
    }
    wx.setNavigationBarTitle({
      title: this.data.web
    })
    this.setData({
      ok: app.globalData.ok,
      to: [o.s || false, o.t || false, o.u || false]
    })
    this.login()
  },
  login: function () {
    let that = this
    if (app.globalData.ok) {
      this.setData({
        ok: true
      })
      this.index()
    } else {
      setTimeout(function () {
        that.login()
      }, 100)
    }
  },
  index: function () {
    let c = this.data.to
    if (this.data.ok) wx.navigateTo({
      url: '../shop/shop' + (c[2] ? '?u=1' : (c[0] ? ('?s=' + c[0]) : '') + (c[1] ? ('&t=' + c[1]) : ''))
    })
  }
})