const app = getApp()

Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    nid: 0,
    cfg: {},
    h_t: wx.getSystemInfoSync().windowHeight,
    h_b: 0,
    eit: {},
    rid: null, //fixed
    tpl: ['', '', ''],
    uee: 0,
    uxx: 0,
    odr: {},
    cpn: [],
    cpm: 0,
    cpi: -1,
    oid: 0,
    pee: '取消'
  },
  onLoad: function (o) {
    if (!o.s && !o.o) wx.navigateBack({})
    this.setData({
      cfg: app.globalData.shp[o.s],
      nid: o.s,
      oid: o.o
    })
    wx.setNavigationBarTitle({
      title: this.data.cfg.n + ' - 结算'
    })
  },
  onShow: function () {
    let that = this
    app.xhr({
      act: 'opay',
      oid: that.data.oid
    }, function (r) {
      for (let i = 0; i < r.cpn.length; i++) {
        r.cpn[i][4] = r.cpn[i][2] >= app.fdt(1)
        r.cpn[i][5] = i
      }
      that.setData({
        uee: r.uee,
        uxx: r.uxx,
        odr: r.odr,
        cpn: r.cpn,
        tpl: app.globalData.tpl
      })
    })
  },
  upay: function (e) {
    if (this.data.odr.Po * 1 - this.data.odr.Pc - this.data.odr.Ps <= 0) {
      app.alt('请勿重复提交')
      return
    }
    let that = this
    if (e && e.type && that.data.odr.Dc * 1 == 1) {
      wx.requestSubscribeMessage({
        tmplIds: [that.data.tpl[1]],
        success: function (res) {
          if (res[that.data.tpl[1]] == 'reject') app.alt('您已拒绝接收取餐通知消息，请注意收听餐厅取餐通知，以免错过就餐！')
        }
      })
    }
    app.xhr({
      act: 'upay',
      oid: that.data.oid,
      cpi: that.data.cpi
    }, function (r) {
      wx.showModal({
        showCancel: false,
        title: '支付',
        content: '本单使用余额支付' + (r.uee / 100) + '元，' + (r.pay ? '支付已成功！' : ('还需微信支付' + (r.uxx / 100) + '元')),
        success: function (res) {
          if (res.confirm) {
            if (r.pay) {
              app.globalData.mdc = []
              wx.navigateTo({
                url: '../user/user'
              })
            } else {
              if (r.mod) {
                if (r.err == '0') {
                  wx.requestPayment({
                    nonceStr: r.rnd,
                    package: 'prepay_id=' + r.qrc,
                    paySign: r.sgn,
                    timeStamp: r.tsp,
                    signType: 'MD5',
                    success: function (res) {
                      app.alt('支付成功！')
                      app.globalData.mdc = []
                      wx.navigateTo({
                        url: '../user/user'
                      })
                    },
                    fail: function (res) {
                      app.alt('支付失败！')
                    }
                  })
                } else app.alt(r.err)
              } else {
                that.setData({
                  pee: '取消'
                })
                that.fade('wxpay', 1, 1)
              }
            }
          }
        }
      })
    })
  },
  setc: function (e) {
    console.log(e)
    this.setData({
      cpi: e.detail.value * 1,
      cpm: this.data.cpn[e.detail.value][0]
    })
  },
  epay: function () {
    this.setData({
      pee: '完成'
    })
  },
  dpay: function () {
    if (this.data.pee == '取消') {
      this.fade('wxpay', 0, 0)
    } else this.tomy()
  },
  tomy: function () {
    app.globalData.mdc = []
    wx.navigateTo({
      url: '../user/user'
    })
  },
  hide: function (e) {
    let c = e.currentTarget.dataset;
    c.m * 1 == 1 ? this.fade(c.n, 0, 0) : this.fade(c.n, 0)
  },
  fade: function (obj, io, bk) {
    this.setData(JSON.parse('{"d_' + obj + '":"block"}'))
    this.setData({
      d_msk: 'block',
      h_b: wx.getSystemInfoSync().windowHeight
    })
    let ao = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    ao.opacity(io ? 1 : 0).translateY(io ? 0 : 100).step()
    let am = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    am.opacity(bk ? 0.3 : (io ? 0.3 : 0)).step()
    let jo = JSON.parse('{"' + obj + '":""}')
    jo[obj] = ao.export()
    jo.msk = am.export()
    this.setData(jo)
    if (!io) {
      let that = this
      setTimeout(function () {
        that.setData(JSON.parse('{"d_' + obj + '":"none"' + (bk ? '' : ',"h_b":0') + '}'))
      }, 550)
    }
  }
})