const app = getApp()
const iac = wx.createInnerAudioContext()
Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    nid: 0,
    cfg: {},
    h_t: wx.getSystemInfoSync().windowHeight,
    h_b: 0,
    eit: {},
    rid: null, //fixed
    tpl: ['', '', ''],
    fd0: [],
    fd1: [],
    sdo: [],
    mpl: [],
    mkr: [],
    mzx: 0,
    mzy: 0,
    mzz: 14,
    vid: 0
  },
  onLoad: function (o) {
    if (!o.s) wx.navigateBack({})
    this.setData({
      nid: o.s,
      cfg: app.globalData.shp[o.s],
      tpl: app.globalData.tpl
    })
    iac.autoplay = false
    iac.loop = false
    iac.src = this.data.url + 'pics/warn.mp3'
    wx.setNavigationBarTitle({
      title: this.data.cfg.n + ' - 骑手'
    })
    this.snds()
  },
  onUnload: function () {
    clearTimeout(this.data.rid)
  },
  sndc: function (e) {
    this.setData({
      mod: e.currentTarget.dataset['im'] * 1
    })
    this.snds()
  },
  snds: function () {
    let that = this
    clearTimeout(that.data.rid)
    let v = ''
    app.xhr({
      act: 'snds'
    }, function (r) {
      let t = []
      let d = []
      for (let i = 0; i < r.fds.length; i++) {
        r.fds[i].t.n = r.fds[i].t.n.substr(0, 1)
        if (r.fds[i].u.i == app.globalData.uid) {
          d.push(r.fds[i])
        } else if (r.fds[i].u.i == 0) {
          t.push(r.fds[i])
          v = r.fds[i].o
        }
      }
      if (v != that.data.vid && v != 0) iac.play()
      that.setData({
        fd0: t,
        fd1: d,
        vid: v
      })
      that.data.rid = setTimeout(function () {
        that.snds()
      }, 10000)
    })
  },
  sndf: function (e) {
    wx.makePhoneCall({
      phoneNumber: e.currentTarget.dataset['mf']
    })
  },
  sndo: function (e) {
    let i = e.currentTarget.dataset['id']
    let c = e.currentTarget.dataset['ic']
    let d = this.data['fd' + c][i]
    let n = app.dnc(d.t.y, d.t.x, d.f.y, d.f.x)
    this.setData({
      sdo: d,
      mzx: (d.t.x + d.f.x) / 2,
      mzy: (d.t.y + d.f.y) / 2,
      mzz: n > 100 ? 7 : (n > 33 ? 9 : (n > 10 ? 10 : (n > 5 ? 12 : (n > 2 ? 13 : (n > 1 ? 14 : 15))))),
    })
    this.fade('foods', 1, 1)
    this.bike(d.t.x, d.t.y, d.f.x, d.f.y)
  },
  sndv: function (e) {
    let that = this
    let i = e.currentTarget.dataset['st'] * 1
    if (i == 4) return
    wx.showModal({
      title: '确认',
      content: '确认' + ['', '接单', '送餐', '送达'][i],
      success: function (res) {
        if (res.confirm) {
          app.xhr({
            act: 'sndv',
            oid: that.data.sdo.o,
            ost: i,
            osf: that.data.sdo.e,
            unm: app.globalData.usr[app.globalData.nid][5][app.globalData.uid],
            umb: app.globalData.mob
          }, function (r) {
            that.fade('foods', 0, 0)
            that.snds()
          })
        }
      }
    })
  },
  bike: function (mx, my, sx, sy) {
    let that = this
    app.xhr({
      act: 'bike',
      mx: mx,
      my: my,
      sx: sx,
      sy: sy,
      ad: 1
    }, function (r) {
      let p = r.result.routes[0].polyline
      for (let i = 2; i < p.length; i++) p[i] = p[i - 2] + p[i] / 1000000
      let b = [];
      for (let i = 0; i < p.length; i += 2) b.push({
        latitude: Math.round(p[i] * 1000000) / 1000000,
        longitude: Math.round(p[i + 1] * 1000000) / 1000000
      })
      that.setData({
        mkr: [{
          latitude: sy,
          longitude: sx,
          iconPath: that.data.url + 'pics/mkrs.png',
          width: '30px',
          height: '34px'
        }, {
          latitude: my,
          longitude: mx,
          iconPath: that.data.url + 'pics/mkrm.png',
          width: '30px',
          height: '34px'
        }],
        mpl: [{
          points: b,
          color: '#0099CCFF',
          width: 5
        }]
      })
    })
  },
  scri: function (e) {
    let that = this
    if (e && e.type) {
      wx.requestSubscribeMessage({
        tmplIds: [that.data.tpl[2]],
        success: function (res) {
          if (res[that.data.tpl[2]] == 'accept') app.alt('您已同意接收外卖配送通知，请您在收到消息后再次订阅此通知消息！')
          if (res[that.data.tpl[2]] == 'reject') app.alt('您已拒绝接收外卖配送通知，无法接收店主下发的外卖订单配送消息！')
        }
      })
    }
  },
  hide: function (e) {
    let c = e.currentTarget.dataset;
    c.m * 1 == 1 ? this.fade(c.n, 0, 0) : this.fade(c.n, 0)
  },
  fade: function (obj, io, bk) {
    this.setData(JSON.parse('{"d_' + obj + '":"block"}'))
    this.setData({
      d_msk: 'block',
      h_b: wx.getSystemInfoSync().windowHeight
    })
    let ao = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    ao.opacity(io ? 1 : 0).translateY(io ? 0 : 100).step()
    let am = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    am.opacity(bk ? 0.3 : (io ? 0.3 : 0)).step()
    let jo = JSON.parse('{"' + obj + '":""}')
    jo[obj] = ao.export()
    jo.msk = am.export()
    this.setData(jo)
    if (!io) {
      let that = this
      setTimeout(function () {
        that.setData(JSON.parse('{"d_' + obj + '":"none"' + (bk ? '' : ',"h_b":0') + '}'))
      }, 550)
    }
  }
})