const app = getApp()

Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    uid: app.globalData.uid,
    h_t: wx.getSystemInfoSync().windowHeight,
    usr: [],
    shp: [],
    tpl: [],
    qui: 0,
    quo: 0,
    qus: [],
    cnt: 0,
    cni: -1
  },
  onLoad: function (o) {
    wx.setNavigationBarTitle({
      title: this.data.web
    })
    if (o.t == '0') wx.setStorage({
      key: 'queueSid',
      data: o.s
    })
    let that = this
    app.xhr({
      act: 'shop'
    }, function (r) {
      let u = []
      let s = []
      for (let e in r.usr) {
        let c = 0
        for (let i = 0; i < 6; i++) {
          for (let j in r.usr[e][i]) {
            if (j * 1 == app.globalData.uid * 1) c = i
          }
        }
        u.push([e, r.shp[e].n, c])
      }
      for (let e in r.shp) {
        if (r.shp[e].h == 0) s.push([e, r.shp[e].n, r.shp[e].a, r.shp[e].b, r.shp[e].x, r.shp[e].y, '正在定位...'])
      }
      that.setData({
        shp: s,
        usr: u,
        tpl: r.tpl,
        qus: r.shp,
        quo: o.t == '0' ? 1 : 0
      })
      app.globalData.shp = r.shp
      app.globalData.usr = r.usr
      app.globalData.tpl = r.tpl
      wx.getLocation({
        type: 'gcj02',
        success(res) {
          let x = res.longitude
          let y = res.latitude
          app.globalData.unx = x
          app.globalData.uny = y
          for (let i = 0; i < s.length; i++) {
            s[i][6] = app.dnc(y, x, s[i][5], s[i][4])
          }
          that.setData({
            shp: s.sort(function (x, y) {
              return x[6] - y[6]
            })
          })
        }
      })
      if (o.s && o.t != '0') {
        app.globalData.nid = o.s
        wx.navigateTo({
          url: '../food/food?s=' + o.s + (o.t ? ('&t=' + o.t) : '')
        })
      }
      if (o.u) {
        wx.navigateTo({
          url: '../user/user'
        })
      }
      wx.getStorage({
        key: 'queueSid',
        success(res) {
          that.setData({
            qui: res.data
          })
          that.quen()
        },
        fail(res) {
          if (o.t == '0') {
            wx.setStorage({
              key: 'queueSid',
              data: o.s
            })
            that.setData({
              qui: o.s
            })
            that.quen()
          }
        }
      })
    })
  },
  quen: function (e) {
    let that = this
    if (e && e.type) {
      wx.requestSubscribeMessage({
        tmplIds: [that.data.tpl[0]],
        success: function (res) {
          if (res[that.data.tpl[0]] == 'reject') app.alt('您已拒绝接收就餐通知消息，请注意收听餐厅前台通知，以免错过就餐！')
        }
      })
    }
    app.xhr({
      act: 'quen',
      add: e ? 1 : 0,
      qui: that.data.qui
    }, function (r) {
      that.setData({
        cnt: r.cnt,
        cni: r.cni
      })
      if (r.cni == -1) {
        wx.removeStorage({
          key: 'queueSid'
        })
        if (!that.data.quo) that.setData({
          qui: 0
        })
      }
      setTimeout(function () {
        that.quen()
      }, 30000)
    })
  },
  goto: function (e) {
    let c = e.currentTarget.dataset
    if (c['pg'] == -1) {
      app.alt('无权限')
      return;
    }
    app.globalData.nid = c['id']
    wx.navigateTo({
      url: '../' + ['food/food', 'sender/sender', 'cooker/cooker', 'waiter/waiter', 'front/front', 'admin/admin', 'user/user'][c['pg']] + '?s=' + c['id']
    })
  }
})