/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50527
Source Host           : localhost:3306
Source Database       : myfk

Target Server Type    : MYSQL
Target Server Version : 50527
File Encoding         : 65001

Date: 2014-05-06 09:17:58
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `yc_access`
-- ----------------------------
DROP TABLE IF EXISTS `yc_access`;
CREATE TABLE `yc_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `access` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `category` enum('CARD','BANK','PAY') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yc_access
-- ----------------------------
INSERT INTO `yc_access` VALUES ('1', '工商银行', 'yc', 'ICBC-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('2', '建设银行', 'yc', 'CCB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('3', '农业银行', 'yc', 'ABC-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('4', '招商银行', 'yc', 'CMBCHINA-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('5', '交通银行', 'yc', 'BOCO-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('6', '民生银行', 'yc', 'CMBC-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('7', '光大银行', 'yc', 'CEB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('8', '中国银行', 'yc', 'BOC-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('9', '浦发银行', 'yc', 'SPDB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('10', '兴业银行', 'yc', 'CIB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('11', '中信银行', 'yc', 'ECITIC-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('12', '广发银行', 'yc', 'GDB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('13', '渤海银行', 'yc', 'CBHB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('14', '北京银行', 'yc', 'BCCB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('15', '平安银行', 'yc', 'PINGANBANK-NET', 'BANK');
INSERT INTO `yc_access` VALUES ('16', '南京银行', 'yc', 'NJCB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('17', '宁波银行', 'yc', 'NBCB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('18', '上海银行', 'yc', 'SHB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('19', '东亚银行', 'yc', 'HKBEA-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('20', '浙商银行', 'yc', 'CZ-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('21', '深圳发展银行', 'yc', 'SDB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('22', '北京农商银行', 'yc', 'BJRCB-NET-B2C', 'BANK');
INSERT INTO `yc_access` VALUES ('23', '盛大一卡通', 'yc', 'SNDACARD', 'CARD');
INSERT INTO `yc_access` VALUES ('24', '移动充值卡', 'yc', 'SZX', 'CARD');
INSERT INTO `yc_access` VALUES ('25', '征途充值', 'yc', 'ZHENGTU', 'CARD');
INSERT INTO `yc_access` VALUES ('26', '搜狐充值卡', 'yc', 'SOHU', 'CARD');
INSERT INTO `yc_access` VALUES ('27', '久游一卡通', 'yc', 'JIUYOU', 'CARD');
INSERT INTO `yc_access` VALUES ('28', '骏网一卡通', 'yc', 'JUNNET', 'CARD');
INSERT INTO `yc_access` VALUES ('29', '联通充值卡', 'yc', 'UNICOM', 'CARD');
INSERT INTO `yc_access` VALUES ('30', '完美一卡通', 'yc', 'WANMEI', 'CARD');
INSERT INTO `yc_access` VALUES ('31', '网易一卡通', 'yc', 'NETEASE', 'CARD');
INSERT INTO `yc_access` VALUES ('32', '电信充值卡', 'yc', 'TELECOM', 'CARD');
INSERT INTO `yc_access` VALUES ('33', '纵游一卡通', 'yc', 'ZONGYOU', 'CARD');
INSERT INTO `yc_access` VALUES ('34', '天下一卡通', 'yc', 'TIANXIA', 'CARD');
INSERT INTO `yc_access` VALUES ('35', '腾讯Q币卡', 'yc', 'QQCARD', 'CARD');
INSERT INTO `yc_access` VALUES ('36', '天宏一卡通', 'yc', 'TIANHONG', 'CARD');
INSERT INTO `yc_access` VALUES ('37', '光宇一卡通', 'yc', null, 'CARD');
INSERT INTO `yc_access` VALUES ('38', '支付宝', 'yc', 'alipay', 'PAY');
INSERT INTO `yc_access` VALUES ('39', '财付通', 'yc', 'tenpay', 'PAY');

-- ----------------------------
-- Table structure for `yc_cards_rate`
-- ----------------------------
DROP TABLE IF EXISTS `yc_cards_rate`;
CREATE TABLE `yc_cards_rate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `rate` decimal(11,3) DEFAULT NULL,
  `cardLan` int(11) DEFAULT NULL,
  `pwdLan` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yc_cards_rate
-- ----------------------------
INSERT INTO `yc_cards_rate` VALUES ('1', '盛大一卡通', '99.000', '15', '8');
INSERT INTO `yc_cards_rate` VALUES ('2', '移动充值卡', '99.000', '17', '18');
INSERT INTO `yc_cards_rate` VALUES ('3', '征途充值卡', '99.000', '16', '8');
INSERT INTO `yc_cards_rate` VALUES ('4', '搜狐充值卡', '99.000', '13', '10');
INSERT INTO `yc_cards_rate` VALUES ('5', '久游一卡通', '99.000', '13', '10');
INSERT INTO `yc_cards_rate` VALUES ('6', '骏网一卡通', '99.000', '16', '16');
INSERT INTO `yc_cards_rate` VALUES ('7', '联通充值卡', '99.000', '15', '19');
INSERT INTO `yc_cards_rate` VALUES ('8', '完美一卡通', '99.000', '10', '15');
INSERT INTO `yc_cards_rate` VALUES ('9', '网易一卡通', '99.000', '13', '9');
INSERT INTO `yc_cards_rate` VALUES ('10', '电信充值卡', '99.000', '19', '18');
INSERT INTO `yc_cards_rate` VALUES ('11', '纵游一卡通', '99.000', '15', '15');
INSERT INTO `yc_cards_rate` VALUES ('12', '天下一卡通', '99.000', '15', '8');
INSERT INTO `yc_cards_rate` VALUES ('13', '腾讯Q币卡', '99.000', '0', '0');
INSERT INTO `yc_cards_rate` VALUES ('14', '天宏一卡通', '99.000', '0', '0');
INSERT INTO `yc_cards_rate` VALUES ('15', '光宇一卡通', '99.100', '0', '0');

-- ----------------------------
-- Table structure for `yc_goods`
-- ----------------------------
DROP TABLE IF EXISTS `yc_goods`;
CREATE TABLE `yc_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `money` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yc_goods
-- ----------------------------
INSERT INTO `yc_goods` VALUES ('1', '商品1', '0.10', null);
INSERT INTO `yc_goods` VALUES ('2', '商品2', '0.20', null);

-- ----------------------------
-- Table structure for `yc_orders`
-- ----------------------------
DROP TABLE IF EXISTS `yc_orders`;
CREATE TABLE `yc_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` varchar(255) DEFAULT NULL,
  `order_body` text,
  `goods` int(11) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `money` decimal(11,3) DEFAULT NULL,
  `real_money` decimal(11,3) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `payment` varchar(255) DEFAULT NULL,
  `access` int(11) DEFAULT NULL,
  `status` enum('NONE','PAYERROR','PAYSUCCESS','FINISH','DRAW') DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yc_orders
-- ----------------------------
INSERT INTO `yc_orders` VALUES ('1', '1399297239', '', '1', '4', '100.000', '0.000', '11111111111', '11@163.com', 'BANK', '1', 'NONE', '127.0.0.1', '1399297239');
INSERT INTO `yc_orders` VALUES ('2', '1399302539', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'CARD', '23', 'NONE', '127.0.0.1', '1399302539');
INSERT INTO `yc_orders` VALUES ('3', '1399302901', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'PAY', '39', 'NONE', '127.0.0.1', '1399302901');
INSERT INTO `yc_orders` VALUES ('4', '1399302941', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'PAY', '39', 'NONE', '127.0.0.1', '1399302941');
INSERT INTO `yc_orders` VALUES ('5', '1399302994', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'PAY', '39', 'NONE', '127.0.0.1', '1399302994');
INSERT INTO `yc_orders` VALUES ('6', '1399303057', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'PAY', '39', 'NONE', '127.0.0.1', '1399303057');
INSERT INTO `yc_orders` VALUES ('7', '1399303156', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'PAY', '39', 'NONE', '127.0.0.1', '1399303156');
INSERT INTO `yc_orders` VALUES ('8', '1399303275', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'CARD', '23', 'NONE', '127.0.0.1', '1399303275');
INSERT INTO `yc_orders` VALUES ('9', '1399303345', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'CARD', '23', 'NONE', '127.0.0.1', '1399303345');
INSERT INTO `yc_orders` VALUES ('10', '1399303475', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'CARD', '23', 'NONE', '127.0.0.1', '1399303475');
INSERT INTO `yc_orders` VALUES ('11', '1399303526', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'BANK', '1', 'NONE', '127.0.0.1', '1399303526');
INSERT INTO `yc_orders` VALUES ('12', '1399303541', '', '1', '1', '100.000', '0.000', '11111111111', '11@11.com', 'CARD', '23', 'NONE', '127.0.0.1', '1399303541');
INSERT INTO `yc_orders` VALUES ('13', '1399303605', '', '1', '1', '0.100', '0.000', '11111111111', '11@11.com', 'CARD', '23', 'NONE', '127.0.0.1', '1399303605');

-- ----------------------------
-- Table structure for `yc_orders_trade`
-- ----------------------------
DROP TABLE IF EXISTS `yc_orders_trade`;
CREATE TABLE `yc_orders_trade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `status` enum('NONE','SUCCESS','ERROR','PART') DEFAULT NULL,
  `money` decimal(10,0) DEFAULT NULL COMMENT '交易总额',
  `real_money` decimal(10,0) DEFAULT NULL COMMENT '付款成功金额',
  `price` decimal(10,0) DEFAULT NULL,
  `card` varchar(255) DEFAULT NULL,
  `pwd` varchar(255) DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yc_orders_trade
-- ----------------------------
INSERT INTO `yc_orders_trade` VALUES ('1', '1', 'NONE', '100', null, '100', '', '', '1399297252', null);
INSERT INTO `yc_orders_trade` VALUES ('2', '2', 'NONE', '100', null, '100', '1', '1', '1399302559', null);
INSERT INTO `yc_orders_trade` VALUES ('3', '2', 'NONE', '100', null, '100', '1', '8', '1399302580', null);
INSERT INTO `yc_orders_trade` VALUES ('4', '3', 'NONE', '100', null, '100', '', '', '1399302904', null);
INSERT INTO `yc_orders_trade` VALUES ('5', '3', 'NONE', '100', null, '100', '', '', '1399302928', null);
INSERT INTO `yc_orders_trade` VALUES ('6', '4', 'NONE', '100', null, '100', '', '', '1399302944', null);
INSERT INTO `yc_orders_trade` VALUES ('7', '5', 'NONE', '100', null, '100', '', '', '1399302996', null);
INSERT INTO `yc_orders_trade` VALUES ('8', '6', 'NONE', '100', null, '100', '', '', '1399303061', null);
INSERT INTO `yc_orders_trade` VALUES ('9', '7', 'NONE', '100', null, '100', '', '', '1399303158', null);
INSERT INTO `yc_orders_trade` VALUES ('10', '8', 'NONE', '200', null, '200', '111111111111111', '11111111', '1399303294', null);
INSERT INTO `yc_orders_trade` VALUES ('11', '9', 'NONE', '200', null, '200', '111111111111111', '11111111', '1399303360', null);
INSERT INTO `yc_orders_trade` VALUES ('12', '10', 'NONE', '150', null, '150', '111111111111111', '11111111', '1399303491', null);
INSERT INTO `yc_orders_trade` VALUES ('13', '11', 'NONE', '100', null, '100', '', '', '1399303528', null);
INSERT INTO `yc_orders_trade` VALUES ('14', '12', 'NONE', '100', null, '100', '1', '2', '1399303567', null);
INSERT INTO `yc_orders_trade` VALUES ('15', '13', 'NONE', '5', null, '5', '111111111111111', '111111', '1399303619', null);
INSERT INTO `yc_orders_trade` VALUES ('16', '13', 'NONE', '5', null, '5', '111111111111111', '11111111', '1399303623', null);

-- ----------------------------
-- Table structure for `yc_payments`
-- ----------------------------
DROP TABLE IF EXISTS `yc_payments`;
CREATE TABLE `yc_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `payment` enum('BANK','CARD','ALIPAY','TENPAY') DEFAULT NULL,
  `access` varchar(255) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `pid` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yc_payments
-- ----------------------------
INSERT INTO `yc_payments` VALUES ('1', '网银支付', 'BANK', 'ebao', 'w79txMr0ql14p709ADuQ7a9Hk3Dc6G2225021w79ws3G9oPSy20U92QimbLy', '10012226645');
INSERT INTO `yc_payments` VALUES ('2', '卡类支付', 'CARD', 'ebao', 'w79txMr0ql14p709ADuQ7a9Hk3Dc6G2225021w79ws3G9oPSy20U92QimbLy', '10012226645');
INSERT INTO `yc_payments` VALUES ('3', '支付宝支付', 'ALIPAY', 'alipay', '', '');
INSERT INTO `yc_payments` VALUES ('4', '财付通支付', 'TENPAY', 'tenpay', '8934e7d15453e97507ef794cf7b0519d', '1900000109');

-- ----------------------------
-- Table structure for `yc_stocks`
-- ----------------------------
DROP TABLE IF EXISTS `yc_stocks`;
CREATE TABLE `yc_stocks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) DEFAULT NULL,
  `card` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `status` enum('NONE','USED') DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yc_stocks
-- ----------------------------
INSERT INTO `yc_stocks` VALUES ('2', '1', '1111111', '1111111', 'USED', '1');
INSERT INTO `yc_stocks` VALUES ('3', '1', '1111111', '1111111', 'NONE', '1');
INSERT INTO `yc_stocks` VALUES ('4', '1', '1111111', '1111111', 'NONE', '1');
INSERT INTO `yc_stocks` VALUES ('5', '1', '1111111', '1111111', 'NONE', '1');

-- ----------------------------
-- Table structure for `yc_users`
-- ----------------------------
DROP TABLE IF EXISTS `yc_users`;
CREATE TABLE `yc_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of yc_users
-- ----------------------------
INSERT INTO `yc_users` VALUES ('1', 'admin', 'e10adc3949ba59abbe56e057f20f883e', null);
