import { FormServiceBase } from '@/ibiz-core';
import { Util, HttpResponse } from '@/ibiz-core/utils';
import { MobNewFROMModel } from '@/app-core/ctrl-model/product/mob-new-from-form-model';


/**
 * MobNewFROM 部件服务对象
 *
 * @export
 * @class MobNewFROMService
 * @extends {FormServiceBase}
 */
export class MobNewFROMService extends FormServiceBase {

    /**
     * 部件模型
     *
     * @protected
     * @type {MobNewFROMModel}
     * @memberof ControlServiceBase
     */
    protected model: MobNewFROMModel = new MobNewFROMModel();

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MobNewFROMService
     */
    protected appDEName: string = 'product';

    /**
     * 当前应用实体主键标识
     *
     * @protected
     * @type {string}
     * @memberof MobNewFROMService
     */
    protected appDeKey: string = 'id';

    /**
     * 获取跨实体数据集合
     *
     * @param {string} serviceName 服务名称
     * @param {string} interfaceName 接口名称
     * @param {*} [context]
     * @param {*} [data]
     * @param {boolean} [isLoading]
     * @returns {Promise<any[]>}
     * @memberof  MobNewFROMService
     */
    public async getItems(serviceName: string, interfaceName: string, context?: any, data?: any, isLoading?: boolean): Promise<any[]> {
        if (Object.is(serviceName, 'ModuleService') && Object.is(interfaceName, 'FetchLine')) {
            const service: any = await this.getService('module');
            await this.onBeforeAction(interfaceName, context, data, isLoading);
            const response: any = await service.FetchLine(data);
            return this.doItems(response);
        }
        return [];
    }

    /**
     * 合并配置的默认值
     *
     * @protected
     * @param {*} [response={}]
     * @memberof MobNewFROMService
     */
    public mergeDefaults(response:any = {}): void {
        if (response.data) {
        }
    }

}
// 默认导出
export default MobNewFROMService;