/**
 * 用例步骤
 *
 * @export
 * @interface CaseStep
 */
export interface CaseStep {

    /**
     * 用例步骤类型
     *
     * @returns {*}
     * @memberof CaseStep
     */
    type?: any;

    /**
     * 编号
     *
     * @returns {*}
     * @memberof CaseStep
     */
    id?: any;

    /**
     * 步骤
     *
     * @returns {*}
     * @memberof CaseStep
     */
    desc?: any;

    /**
     * 预期
     *
     * @returns {*}
     * @memberof CaseStep
     */
    expect?: any;

    /**
     * 用例版本
     *
     * @returns {*}
     * @memberof CaseStep
     */
    version?: any;

    /**
     * 用例
     *
     * @returns {*}
     * @memberof CaseStep
     */
    ibizcase?: any;

    /**
     * 分组用例步骤的组编号
     *
     * @returns {*}
     * @memberof CaseStep
     */
    parent?: any;

    /**
     * 实际情况
     *
     * @returns {*}
     * @memberof CaseStep
     */
    reals?: any;

    /**
     * 测试结果
     *
     * @returns {*}
     * @memberof CaseStep
     */
    steps?: any;

    /**
     * 附件
     *
     * @returns {*}
     * @memberof CaseStep
     */
    files?: any;

    /**
     * 执行编号
     *
     * @returns {*}
     * @memberof CaseStep
     */
    runid?: any;

    /**
     * 用例步骤编号
     *
     * @returns {*}
     * @memberof CaseStep
     */
    casestepid?: any;
}