/**
 * 用例步骤
 *
 * @export
 * @interface IBZCaseStep
 */
export interface IBZCaseStep {

    /**
     * 用例步骤类型
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    type?: any;

    /**
     * 编号
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    id?: any;

    /**
     * 步骤
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    desc?: any;

    /**
     * 预期
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    expect?: any;

    /**
     * 用例版本
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    version?: any;

    /**
     * 用例
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    ibizcase?: any;

    /**
     * 分组用例步骤的组编号
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    parent?: any;

    /**
     * 实际情况
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    reals?: any;

    /**
     * 测试结果
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    steps?: any;

    /**
     * 附件
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    files?: any;

    /**
     * 执行编号
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    runid?: any;

    /**
     * 用例步骤编号
     *
     * @returns {*}
     * @memberof IBZCaseStep
     */
    casestepid?: any;
}