/**
 * 需求
 *
 * @export
 * @interface Story
 */
export interface Story {

    /**
     * 指派给
     *
     * @returns {*}
     * @memberof Story
     */
    assignedto?: any;

    /**
     * 细分需求
     *
     * @returns {*}
     * @memberof Story
     */
    childstories?: any;

    /**
     * 所属计划
     *
     * @returns {*}
     * @memberof Story
     */
    plan?: any;

    /**
     * 版本号
     *
     * @returns {*}
     * @memberof Story
     */
    version?: any;

    /**
     * 指派日期
     *
     * @returns {*}
     * @memberof Story
     */
    assigneddate?: any;

    /**
     * 优先级
     *
     * @returns {*}
     * @memberof Story
     */
    pri?: any;

    /**
     * 相关需求
     *
     * @returns {*}
     * @memberof Story
     */
    linkstories?: any;

    /**
     * 当前状态
     *
     * @returns {*}
     * @memberof Story
     */
    status?: any;

    /**
     * 预计工时
     *
     * @returns {*}
     * @memberof Story
     */
    estimate?: any;

    /**
     * 评审时间
     *
     * @returns {*}
     * @memberof Story
     */
    revieweddate?: any;

    /**
     * 需求名称
     *
     * @returns {*}
     * @memberof Story
     */
    title?: any;

    /**
     * 来源备注
     *
     * @returns {*}
     * @memberof Story
     */
    sourcenote?: any;

    /**
     * 由谁评审
     *
     * @returns {*}
     * @memberof Story
     */
    reviewedby?: any;

    /**
     * 子状态
     *
     * @returns {*}
     * @memberof Story
     */
    substatus?: any;

    /**
     * 设置阶段者
     *
     * @returns {*}
     * @memberof Story
     */
    stagedby?: any;

    /**
     * 由谁创建
     *
     * @returns {*}
     * @memberof Story
     */
    openedby?: any;

    /**
     * 创建日期
     *
     * @returns {*}
     * @memberof Story
     */
    openeddate?: any;

    /**
     * 编号
     *
     * @returns {*}
     * @memberof Story
     */
    id?: any;

    /**
     * 需求来源
     *
     * @returns {*}
     * @memberof Story
     */
    source?: any;

    /**
     * 关闭原因
     *
     * @returns {*}
     * @memberof Story
     */
    closedreason?: any;

    /**
     * 标题颜色
     *
     * @returns {*}
     * @memberof Story
     */
    color?: any;

    /**
     * 抄送给
     *
     * @returns {*}
     * @memberof Story
     */
    mailto?: any;

    /**
     * 已删除
     *
     * @returns {*}
     * @memberof Story
     */
    deleted?: any;

    /**
     * 关键词
     *
     * @returns {*}
     * @memberof Story
     */
    keywords?: any;

    /**
     * 最后修改
     *
     * @returns {*}
     * @memberof Story
     */
    lasteditedby?: any;

    /**
     * 所处阶段
     *
     * @returns {*}
     * @memberof Story
     */
    stage?: any;

    /**
     * 关闭日期	
     *
     * @returns {*}
     * @memberof Story
     */
    closeddate?: any;

    /**
     * 由谁关闭
     *
     * @returns {*}
     * @memberof Story
     */
    closedby?: any;

    /**
     * 需求类型
     *
     * @returns {*}
     * @memberof Story
     */
    type?: any;

    /**
     * 最后修改日期
     *
     * @returns {*}
     * @memberof Story
     */
    lastediteddate?: any;

    /**
     * 模块路径
     *
     * @returns {*}
     * @memberof Story
     */
    path?: any;

    /**
     * 父需求名称
     *
     * @returns {*}
     * @memberof Story
     */
    parentname?: any;

    /**
     * 所属模块名称
     *
     * @returns {*}
     * @memberof Story
     */
    modulename?: any;

    /**
     * 产品名称
     *
     * @returns {*}
     * @memberof Story
     */
    productname?: any;

    /**
     * 来源Bug
     *
     * @returns {*}
     * @memberof Story
     */
    frombug?: any;

    /**
     * 父需求
     *
     * @returns {*}
     * @memberof Story
     */
    parent?: any;

    /**
     * 所属模块
     *
     * @returns {*}
     * @memberof Story
     */
    module?: any;

    /**
     * 所属产品
     *
     * @returns {*}
     * @memberof Story
     */
    product?: any;

    /**
     * 重复需求ID
     *
     * @returns {*}
     * @memberof Story
     */
    duplicatestory?: any;

    /**
     * 平台/分支
     *
     * @returns {*}
     * @memberof Story
     */
    branch?: any;

    /**
     * 转Bug
     *
     * @returns {*}
     * @memberof Story
     */
    tobug?: any;

    /**
     * 需求描述
     *
     * @returns {*}
     * @memberof Story
     */
    spec?: any;

    /**
     * 验收标准
     *
     * @returns {*}
     * @memberof Story
     */
    verify?: any;

    /**
     * 评审结果
     *
     * @returns {*}
     * @memberof Story
     */
    result?: any;

    /**
     * 备注
     *
     * @returns {*}
     * @memberof Story
     */
    comment?: any;

    /**
     * 是否子需求
     *
     * @returns {*}
     * @memberof Story
     */
    isleaf?: any;

    /**
     * 附件
     *
     * @returns {*}
     * @memberof Story
     */
    files?: any;

    /**
     * 平台/分支
     *
     * @returns {*}
     * @memberof Story
     */
    branchname?: any;

    /**
     * 版本号
     *
     * @returns {*}
     * @memberof Story
     */
    versionc?: any;

    /**
     * 所属模块名称
     *
     * @returns {*}
     * @memberof Story
     */
    modulename1?: any;

    /**
     * 项目
     *
     * @returns {*}
     * @memberof Story
     */
    project?: any;

    /**
     * 之前的版本
     *
     * @returns {*}
     * @memberof Story
     */
    preversion?: any;

    /**
     * 不需要评审
     *
     * @returns {*}
     * @memberof Story
     */
    neednotreview?: any;

    /**
     * 是否收藏
     *
     * @returns {*}
     * @memberof Story
     */
    isfavorites?: any;

    /**
     * 是否可以细分
     *
     * @returns {*}
     * @memberof Story
     */
    ischild?: any;
}