/**
 * 测试报告
 *
 * @export
 * @interface TestReport
 */
export interface TestReport {

    /**
     * 所属对象
     *
     * @returns {*}
     * @memberof TestReport
     */
    objectid?: any;

    /**
     * 用例
     *
     * @returns {*}
     * @memberof TestReport
     */
    cases?: any;

    /**
     * 参与人员
     *
     * @returns {*}
     * @memberof TestReport
     */
    members?: any;

    /**
     * 测试的Bug
     *
     * @returns {*}
     * @memberof TestReport
     */
    bugs?: any;

    /**
     * 由谁创建
     *
     * @returns {*}
     * @memberof TestReport
     */
    createdby?: any;

    /**
     * 测试的需求
     *
     * @returns {*}
     * @memberof TestReport
     */
    stories?: any;

    /**
     * 测试单
     *
     * @returns {*}
     * @memberof TestReport
     */
    tasks?: any;

    /**
     * 标题
     *
     * @returns {*}
     * @memberof TestReport
     */
    title?: any;

    /**
     * 开始时间
     *
     * @returns {*}
     * @memberof TestReport
     */
    begin?: any;

    /**
     * 对象类型
     *
     * @returns {*}
     * @memberof TestReport
     */
    objecttype?: any;

    /**
     * 结束时间
     *
     * @returns {*}
     * @memberof TestReport
     */
    end?: any;

    /**
     * 版本信息
     *
     * @returns {*}
     * @memberof TestReport
     */
    builds?: any;

    /**
     * 创建时间
     *
     * @returns {*}
     * @memberof TestReport
     */
    createddate?: any;

    /**
     * 总结
     *
     * @returns {*}
     * @memberof TestReport
     */
    report?: any;

    /**
     * 编号
     *
     * @returns {*}
     * @memberof TestReport
     */
    id?: any;

    /**
     * 负责人
     *
     * @returns {*}
     * @memberof TestReport
     */
    owner?: any;

    /**
     * 已删除
     *
     * @returns {*}
     * @memberof TestReport
     */
    deleted?: any;

    /**
     * 所属产品
     *
     * @returns {*}
     * @memberof TestReport
     */
    product?: any;

    /**
     * 所属项目
     *
     * @returns {*}
     * @memberof TestReport
     */
    project?: any;

    /**
     * 所属产品
     *
     * @returns {*}
     * @memberof TestReport
     */
    productname?: any;

    /**
     * 所属项目
     *
     * @returns {*}
     * @memberof TestReport
     */
    projectname?: any;

    /**
     * 备注
     *
     * @returns {*}
     * @memberof TestReport
     */
    comment?: any;

    /**
     * 概况
     *
     * @returns {*}
     * @memberof TestReport
     */
    overviews?: any;

    /**
     * 附件
     *
     * @returns {*}
     * @memberof TestReport
     */
    files?: any;

    /**
     * 项目报告产品数
     *
     * @returns {*}
     * @memberof TestReport
     */
    productcnt?: any;
}