/**
 * 用户年度工作内容统计
 *
 * @export
 * @interface UserYearWorkStats
 */
export interface UserYearWorkStats {

    /**
     * 用户编号
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    id?: any;

    /**
     * 真实用户名
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    realname?: any;

    /**
     * 账号
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    account?: any;

    /**
     * 角色
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    role?: any;

    /**
     * 部门编号
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    dept?: any;

    /**
     * 累计登录次数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    visits?: any;

    /**
     * 累计创建计划数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearplancnt?: any;

    /**
     * 累计参与产品数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearproductcnt?: any;

    /**
     * 累计创建需求数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearstorycnt?: any;

    /**
     * 累计动态数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearactioncnt?: any;

    /**
     * 累计创建Bug数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearbugcnt?: any;

    /**
     * 累计创建用例数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearcasecnt?: any;

    /**
     * 累计日志数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearlogcnt?: any;

    /**
     * 累计工时数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearestimatecnt?: any;

    /**
     * 判断角色
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    judgerole?: any;

    /**
     * 累计登录次数
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    yearvisits?: any;

    /**
     * 年度
     *
     * @returns {*}
     * @memberof UserYearWorkStats
     */
    curyear?: any;
}