package cn.ibizlab.pms.core.zentao.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.pms.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.pms.core.zentao.domain.Im_chatuser;
/**
 * 关系型数据实体[Im_chatuser] 查询条件对象
 */
@Slf4j
@Data
public class Im_chatuserSearchContext extends QueryWrapperContext<Im_chatuser> {

	private String n_freeze_eq;//[freeze]
	public void setN_freeze_eq(String n_freeze_eq) {
        this.n_freeze_eq = n_freeze_eq;
        if(!ObjectUtils.isEmpty(this.n_freeze_eq)){
            this.getSearchCond().eq("freeze", n_freeze_eq);
        }
    }
	private String n_star_eq;//[star]
	public void setN_star_eq(String n_star_eq) {
        this.n_star_eq = n_star_eq;
        if(!ObjectUtils.isEmpty(this.n_star_eq)){
            this.getSearchCond().eq("star", n_star_eq);
        }
    }
	private String n_hide_eq;//[hide]
	public void setN_hide_eq(String n_hide_eq) {
        this.n_hide_eq = n_hide_eq;
        if(!ObjectUtils.isEmpty(this.n_hide_eq)){
            this.getSearchCond().eq("hide", n_hide_eq);
        }
    }
	private String n_mute_eq;//[mute]
	public void setN_mute_eq(String n_mute_eq) {
        this.n_mute_eq = n_mute_eq;
        if(!ObjectUtils.isEmpty(this.n_mute_eq)){
            this.getSearchCond().eq("mute", n_mute_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
		 }
	}
}



