package cn.ibizlab.pms.core.zentao.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.pms.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.pms.core.zentao.domain.Lang;
/**
 * 关系型数据实体[Lang] 查询条件对象
 */
@Slf4j
@Data
public class LangSearchContext extends QueryWrapperContext<Lang> {

	private String n_system_eq;//[system]
	public void setN_system_eq(String n_system_eq) {
        this.n_system_eq = n_system_eq;
        if(!ObjectUtils.isEmpty(this.n_system_eq)){
            this.getSearchCond().eq("system", n_system_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
		 }
	}
}



