package cn.ibizlab.pms.core.zentao.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.pms.core.zentao.domain.Action;
import cn.ibizlab.pms.core.zentao.filter.ActionSearchContext;
import cn.ibizlab.pms.core.zentao.service.IActionService;

import cn.ibizlab.pms.util.helper.CachedBeanCopier;
import cn.ibizlab.pms.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.pms.core.zentao.mapper.ActionMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[系统日志] 服务对象接口实现
 */
@Slf4j
@Service("ActionServiceImpl")
public class ActionServiceImpl extends ServiceImpl<ActionMapper, Action> implements IActionService {

    @Autowired
    @Lazy
    protected cn.ibizlab.pms.core.zentao.service.IHistoryService historyService;
    @Autowired
    @Lazy
    protected cn.ibizlab.pms.core.zentao.service.IProjectService projectService;

    @Autowired
    @Lazy
    protected cn.ibizlab.pms.core.zentao.service.logic.IActionCommentLogic commentLogic;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(Action et) {
        commentLogic.execute(et);
        if(!this.retBool(this.baseMapper.insert(et)))
            return false;
        CachedBeanCopier.copy(get(et.getId()),et);
        return true;
    }

    @Override
    public void createBatch(List<Action> list) {
        this.saveBatch(list,batchSize);
    }

    @Override
    @Transactional
    public boolean update(Action et) {
        if(!update(et,(Wrapper) et.getUpdateWrapper(true).eq("id",et.getId())))
            return false;
        CachedBeanCopier.copy(get(et.getId()),et);
        return true;
    }

    @Override
    public void updateBatch(List<Action> list) {
        updateBatchById(list,batchSize);
    }

    @Override
    @Transactional
    public boolean remove(Long key) {
        boolean result=removeById(key);
        return result ;
    }

    @Override
    public void removeBatch(Collection<Long> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public Action get(Long key) {
        Action et = getById(key);
        if(et==null){
            et=new Action();
            et.setId(key);
        }
        else{
        }
        return et;
    }

    @Override
    public Action getDraft(Action et) {
        return et;
    }

    @Override
    public boolean checkKey(Action et) {
        return (!ObjectUtils.isEmpty(et.getId()))&&(!Objects.isNull(this.getById(et.getId())));
    }
    @Override
    @Transactional
    public Action comment(Action et) {
        commentLogic.execute(et);
         return et ;
    }

        @Override
    @Transactional
    public Action editComment(Action et) {
        String zentaoSid = org.springframework.util.DigestUtils.md5DigestAsHex(cn.ibizlab.pms.core.util.zentao.helper.TokenHelper.getRequestToken().getBytes());
        cn.ibizlab.pms.core.util.zentao.bean.ZTResult rst = new cn.ibizlab.pms.core.util.zentao.bean.ZTResult();
        boolean bRst = cn.ibizlab.pms.core.util.zentao.helper.ZTActionHelper.editComment(zentaoSid, cn.ibizlab.pms.core.util.zentao.helper.TransHelper.ET2JO(et, "editComment"), rst);
        if (bRst && rst.getEtId() != null) {
            et = this.get(rst.getEtId());
        }
        et.set("ztrst", rst);
        return et;
    }

    @Override
    @Transactional
    public boolean save(Action et) {
        if(!saveOrUpdate(et))
            return false;
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(Action et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    public boolean saveBatch(Collection<Action> list) {
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    public void saveBatch(List<Action> list) {
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<Action> selectByProject(Long id) {
        return baseMapper.selectByProject(id);
    }

    @Override
    public void removeByProject(Long id) {
        this.remove(new QueryWrapper<Action>().eq("project",id));
    }


    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<Action> searchDefault(ActionSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Action> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<Action>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }

    /**
     * 查询集合 MobType
     */
    @Override
    public Page<Action> searchMobType(ActionSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Action> pages=baseMapper.searchMobType(context.getPages(),context,context.getSelectCond());
        return new PageImpl<Action>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }

    /**
     * 查询集合 ProductTrends
     */
    @Override
    public Page<Action> searchProductTrends(ActionSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Action> pages=baseMapper.searchProductTrends(context.getPages(),context,context.getSelectCond());
        return new PageImpl<Action>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }

    /**
     * 查询集合 项目动态(项目相关所有)
     */
    @Override
    public Page<Action> searchProjectTrends(ActionSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Action> pages=baseMapper.searchProjectTrends(context.getPages(),context,context.getSelectCond());
        return new PageImpl<Action>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }

    /**
     * 查询集合 Type
     */
    @Override
    public Page<Action> searchType(ActionSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<Action> pages=baseMapper.searchType(context.getPages(),context,context.getSelectCond());
        return new PageImpl<Action>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }







    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }


}



