import { MockAdapter } from '../mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'

// 获取全部数组
mock.onGet('./assets/json/data-dictionary.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status, [
        {
        srfkey: "EMTRIGGERDP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "=",
                label: "等于",
                text: "等于",
                "data":"",
                "codename":"EQ",
                value: "=",
                
                disabled: false,
            },
            {
                id: ">=",
                label: "大于等于",
                text: "大于等于",
                "data":"",
                "codename":"GTEQ",
                value: ">=",
                
                disabled: false,
            },
            {
                id: "<=",
                label: "小于等于",
                text: "小于等于",
                "data":"",
                "codename":"LTEQ",
                value: "<=",
                
                disabled: false,
            },
            {
                id: ">",
                label: "大于",
                text: "大于",
                "data":"",
                "codename":"GT",
                value: ">",
                
                disabled: false,
            },
            {
                id: "<",
                label: "小于",
                text: "小于",
                "data":"",
                "codename":"LT",
                value: "<",
                
                disabled: false,
            },
            {
                id: ">>",
                label: "递增",
                text: "递增",
                "data":"",
                "codename":"GTGT",
                value: ">>",
                
                disabled: false,
            },
            {
                id: "<<",
                label: "递减",
                text: "递减",
                "data":"",
                "codename":"LTLT",
                value: "<<",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMEQLOCATIONTYPE",
        emptytext: "",
        "codelisttype":"static",
        items: [
            {
                id: "SSE",
                label: "系统",
                text: "系统",
                "data":"",
                "codename":"Sse",
                "color": "rgba(68, 255, 0, 1)",
                value: "SSE",
                
                disabled: false,
            },
            {
                id: "PCS",
                label: "部件",
                text: "部件",
                "data":"",
                "codename":"Pcs",
                "color": "rgba(0, 255, 238, 1)",
                value: "PCS",
                
                disabled: false,
            },
            {
                id: "SPA",
                label: "零配件",
                text: "零配件",
                "data":"",
                "codename":"Spa",
                "color": "rgba(187, 0, 255, 1)",
                value: "SPA",
                
                disabled: false,
            },
            {
                id: "PST",
                label: "物理位置",
                text: "物理位置",
                "data":"",
                "codename":"Pst",
                "color": "rgba(0, 13, 255, 1)",
                value: "PST",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "PFCL_ORG",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "TOP",
                label: "上海港",
                text: "上海港",
                "data":"",
                "codename":"Top",
                "color": "rgba(49, 27, 146, 1)",
                value: "TOP",
                
                disabled: false,
            },
            {
                id: "TIP",
                label: "宁波港",
                text: "宁波港",
                "data":"",
                "codename":"Tip",
                "color": "rgba(209, 196, 233, 1)",
                value: "TIP",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPODETAILSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未到货",
                text: "未到货",
                "data":"",
                "codename":"Item_0",
                "color": "rgba(209, 196, 233, 1)",
                value: 0,
                
                disabled: false,
            },
            {
                id: "10",
                label: "验收中",
                text: "验收中",
                "data":"",
                "codename":"Item_10",
                "color": "rgba(103, 58, 183, 1)",
                value: 10,
                
                disabled: false,
            },
            {
                id: "20",
                label: "已关闭",
                text: "已关闭",
                "data":"",
                "codename":"Item_20",
                "color": "rgba(49, 27, 146, 1)",
                value: 20,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMEQUIPGROUP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "生产设备",
                text: "生产设备",
                "data":"",
                "codename":"Item_1",
                value: 1,
                
                disabled: false,
            },
            {
                id: "2",
                label: "特种设备",
                text: "特种设备",
                "data":"",
                "codename":"Item_2",
                value: 2,
                
                disabled: false,
            },
            {
                id: "4",
                label: "计量设备",
                text: "计量设备",
                "data":"",
                "codename":"Item_4",
                value: 4,
                
                disabled: false,
            },
            {
                id: "8",
                label: "供电设备",
                text: "供电设备",
                "data":"",
                "codename":"Item_8",
                value: 8,
                
                disabled: false,
            },
            {
                id: "16",
                label: "车辆",
                text: "车辆",
                "data":"",
                "codename":"Item_16",
                value: 16,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "B9E40120688D402CA77C4065DE891DDC",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "J0",
                label: "0",
                text: "0",
                "data":"",
                "codename":"J0",
                value: "J0",
                
                disabled: false,
            },
            {
                id: "J8",
                label: "0.13",
                text: "0.13",
                "data":"",
                "codename":"J8",
                value: "J8",
                
                disabled: false,
            },
            {
                id: "J2",
                label: "0.03",
                text: "0.03",
                "data":"",
                "codename":"J2",
                value: "J2",
                
                disabled: false,
            },
            {
                id: "J4",
                label: "0.06",
                text: "0.06",
                "data":"",
                "codename":"J4",
                value: "J4",
                
                disabled: false,
            },
            {
                id: "JA",
                label: "0.17",
                text: "0.17",
                "data":"",
                "codename":"Ja",
                value: "JA",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMABCTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "A",
                label: "A",
                text: "A",
                "data":"",
                "codename":"A",
                value: "A",
                
                disabled: false,
            },
            {
                id: "B",
                label: "B",
                text: "B",
                "data":"",
                "codename":"B",
                value: "B",
                
                disabled: false,
            },
            {
                id: "C",
                label: "C",
                text: "C",
                "data":"",
                "codename":"C",
                value: "C",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMAPPLYSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                value: 0,
                
                disabled: false,
            },
            {
                id: "10",
                label: "流程中",
                text: "流程中",
                "data":"",
                "codename":"Item_10",
                value: 10,
                
                disabled: false,
            },
            {
                id: "20",
                label: "已完成",
                text: "已完成",
                "data":"",
                "codename":"Item_20",
                value: 20,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMSERVICEGROUP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "服务供应商",
                text: "服务供应商",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(68, 255, 0, 1)",
                value: 1,
                
                disabled: false,
            },
            {
                id: "2",
                label: "产品供应商",
                text: "产品供应商",
                "data":"",
                "codename":"Item_2",
                "color": "rgba(0, 255, 229, 1)",
                value: 2,
                
                disabled: false,
            },
            {
                id: "4",
                label: "制造商",
                text: "制造商",
                "data":"",
                "codename":"Item_4",
                "color": "rgba(0, 47, 255, 1)",
                value: 4,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMTEAMTYPEID",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "",
                label: "代码项",
                text: "代码项",
                "data":"",
                "codename":"Item_1",
                value: "",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMSERVICELEVEL",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "1级",
                text: "1级",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(49, 27, 146, 1)",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "2级",
                text: "2级",
                "data":"",
                "codename":"Item_2",
                "color": "rgba(81, 45, 168, 1)",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "3级",
                text: "3级",
                "data":"",
                "codename":"Item_3",
                "color": "rgba(103, 58, 183, 1)",
                value: "3",
                
                disabled: false,
            },
            {
                id: "4",
                label: "4级",
                text: "4级",
                "data":"",
                "codename":"Item_4",
                "color": "rgba(149, 117, 205, 1)",
                value: "4",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMINOUTFLAG",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "出",
                text: "出",
                "data":"",
                "codename":"Item_0",
                "color": "rgba(146, 231, 18, 1)",
                value: 0,
                
                disabled: false,
            },
            {
                id: "1",
                label: "入",
                text: "入",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(0, 238, 255, 1)",
                value: 1,
                
                disabled: false,
            },
            {
                id: "-1",
                label: "出",
                text: "出",
                "data":"",
                "codename":"_SUB_1",
                "color": "rgba(146, 231, 18, 1)",
                value: -1,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPAYWAY",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "现金",
                text: "现金",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(102, 255, 0, 1)",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "转帐",
                text: "转帐",
                "data":"",
                "codename":"Item_2",
                "color": "rgba(0, 255, 149, 1)",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "银联",
                text: "银联",
                "data":"",
                "codename":"Item_3",
                "color": "rgba(0, 123, 255, 1)",
                value: "3",
                
                disabled: false,
            },
            {
                id: "4",
                label: "汇票",
                text: "汇票",
                "data":"",
                "codename":"Item_4",
                "color": "rgba(21, 0, 255, 1)",
                value: "4",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMITEMGROUP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "物资",
                text: "物资",
                "data":"",
                "codename":"Item_1",
                value: 1,
                
                disabled: false,
            },
            {
                id: "2",
                label: "工量具",
                text: "工量具",
                "data":"",
                "codename":"Item_2",
                value: 2,
                
                disabled: false,
            },
            {
                id: "4",
                label: "轮胎",
                text: "轮胎",
                "data":"",
                "codename":"Item_4",
                value: 4,
                
                disabled: false,
            },
            {
                id: "8",
                label: "电瓶",
                text: "电瓶",
                "data":"",
                "codename":"Item_8",
                value: 8,
                
                disabled: false,
            },
            {
                id: "16",
                label: "工索具",
                text: "工索具",
                "data":"",
                "codename":"Item_16",
                value: 16,
                
                disabled: false,
            },
            {
                id: "32",
                label: "钢丝绳",
                text: "钢丝绳",
                "data":"",
                "codename":"Item_32",
                value: 32,
                
                disabled: false,
            },
            {
                id: "64",
                label: "探头",
                text: "探头",
                "data":"",
                "codename":"Item_64",
                value: 64,
                
                disabled: false,
            },
            {
                id: "128",
                label: "对讲机",
                text: "对讲机",
                "data":"",
                "codename":"Item_128",
                value: 128,
                
                disabled: false,
            },
            {
                id: "256",
                label: "润滑油",
                text: "润滑油",
                "data":"",
                "codename":"Item_256",
                value: 256,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMSERVICETYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "定点供货商",
                text: "定点供货商",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMGSSXM",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "QS",
                label: "起升钢丝绳",
                text: "起升钢丝绳",
                "data":"",
                "codename":"Qs",
                value: "QS",
                
                disabled: false,
            },
            {
                id: "FY",
                label: "俯仰钢丝绳",
                text: "俯仰钢丝绳",
                "data":"",
                "codename":"Fy",
                value: "FY",
                
                disabled: false,
            },
            {
                id: "XC",
                label: "小车钢丝绳",
                text: "小车钢丝绳",
                "data":"",
                "codename":"Xc",
                value: "XC",
                
                disabled: false,
            },
            {
                id: "TJ",
                label: "小车托架钢丝绳",
                text: "小车托架钢丝绳",
                "data":"",
                "codename":"Tj",
                value: "TJ",
                
                disabled: false,
            },
            {
                id: "FANGYAO",
                label: "防摇钢丝绳",
                text: "防摇钢丝绳",
                "data":"",
                "codename":"Fangyao",
                value: "FANGYAO",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "CADAB38AEA0249DDA40C36287E0E187D",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0.17",
                label: "17%",
                text: "17%",
                "data":"",
                "codename":"Item_1",
                value: 0.17,
                
                disabled: false,
            },
            {
                id: "0.03",
                label: "3%",
                text: "3%",
                "data":"",
                "codename":"Item_2",
                value: 0.03,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "CODELIST_PLANTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "计划内",
                text: "计划内",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "计划外",
                text: "计划外",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMEMPSEX",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "B",
                label: "男",
                text: "男",
                "data":"",
                "codename":"B",
                value: "B",
                
                disabled: false,
            },
            {
                id: "G",
                label: "女",
                text: "女",
                "data":"",
                "codename":"G",
                value: "G",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMASSETTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "GLYJ",
                label: "管理用具",
                text: "管理用具",
                "data":"",
                "codename":"Glyj",
                "color": "rgba(49, 27, 146, 1)",
                value: "GLYJ",
                
                disabled: false,
            },
            {
                id: "TXSB",
                label: "通讯设备",
                text: "通讯设备",
                "data":"",
                "codename":"Txsb",
                "color": "rgba(81, 45, 168, 1)",
                value: "TXSB",
                
                disabled: false,
            },
            {
                id: "DLSB",
                label: "动力设备",
                text: "动力设备",
                "data":"",
                "codename":"Dlsb",
                "color": "rgba(149, 117, 205, 1)",
                value: "DLSB",
                
                disabled: false,
            },
            {
                id: "JQSB",
                label: "机器设备",
                text: "机器设备",
                "data":"",
                "codename":"Jqsb",
                "color": "rgba(149, 117, 205, 1)",
                value: "JQSB",
                
                disabled: false,
            },
            {
                id: "ZXJX",
                label: "装卸机械",
                text: "装卸机械",
                "data":"",
                "codename":"Zxjx",
                "color": "rgba(204, 255, 0, 1)",
                value: "ZXJX",
                
                disabled: false,
            },
            {
                id: "GDSB",
                label: "供电设备",
                text: "供电设备",
                "data":"",
                "codename":"Gdsb",
                "color": "rgba(0, 255, 64, 1)",
                value: "GDSB",
                
                disabled: false,
            },
            {
                id: "CL",
                label: "车辆",
                text: "车辆",
                "data":"",
                "codename":"Cl",
                "color": "rgba(0, 149, 255, 1)",
                value: "CL",
                
                disabled: false,
            },
            {
                id: "DT",
                label: "灯塔",
                text: "灯塔",
                "data":"",
                "codename":"Dt",
                "color": "rgba(0, 47, 255, 1)",
                value: "DT",
                
                disabled: false,
            },
            {
                id: "",
                label: "代码项",
                text: "代码项",
                "data":"",
                "codename":"Item_9",
                value: "",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMKPTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "1",
                text: "1",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "CODELIST_RANGE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "100",
                label: "本市",
                text: "本市",
                "data":"",
                "codename":"Item_100",
                value: "100",
                
                disabled: false,
            },
            {
                id: "80",
                label: "省内",
                text: "省内",
                "data":"",
                "codename":"Item_80",
                value: "80",
                
                disabled: false,
            },
            {
                id: "60",
                label: "省外",
                text: "省外",
                "data":"",
                "codename":"Item_60",
                value: "60",
                
                disabled: false,
            },
            {
                id: "50",
                label: "国外",
                text: "国外",
                "data":"",
                "codename":"Item_50",
                value: "50",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "PFCL_TAXTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "1",
                text: "1",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
        ]
    },
    {
        "srfkey": "SysOperator",
        "emptytext": "未定义",
        "codelisttype":"dynamic",
        "appdataentity":"",
        "appdedataset":"",
        "items": []
    },
    {
        srfkey: "EMWPLISTSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                value: 0,
                
                disabled: false,
            },
            {
                id: "10",
                label: "采购过程中",
                text: "采购过程中",
                "data":"",
                "codename":"Item_10",
                value: 10,
                
                disabled: false,
            },
            {
                id: "20",
                label: "已生成订单",
                text: "已生成订单",
                "data":"",
                "codename":"Item_20",
                value: 20,
                
                disabled: false,
            },
            {
                id: "30",
                label: "已入库",
                text: "已入库",
                "data":"",
                "codename":"Item_30",
                value: 30,
                
                disabled: false,
            },
            {
                id: "40",
                label: "已取消",
                text: "已取消",
                "data":"",
                "codename":"Item_40",
                value: 40,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPUSESTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                value: 0,
                
                disabled: false,
            },
            {
                id: "10",
                label: "流程中",
                text: "流程中",
                "data":"",
                "codename":"Item_10",
                "color": "rgba(213, 0, 255, 1)",
                value: 10,
                
                disabled: false,
            },
            {
                id: "20",
                label: "已发料",
                text: "已发料",
                "data":"",
                "codename":"Item_20",
                "color": "rgba(0, 204, 255, 1)",
                value: 20,
                
                disabled: false,
            },
            {
                id: "30",
                label: "已还料",
                text: "已还料",
                "data":"",
                "codename":"Item_30",
                "color": "rgba(0, 13, 255, 1)",
                value: 30,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMASSETSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "购入",
                text: "购入",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(49, 27, 146, 1)",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "调入",
                text: "调入",
                "data":"",
                "codename":"Item_2",
                "color": "rgba(81, 45, 168, 1)",
                value: "2",
                
                disabled: false,
            },
            {
                id: "-1",
                label: "报废",
                text: "报废",
                "data":"",
                "codename":"_SUB_1",
                "color": "rgba(103, 58, 183, 1)",
                value: "-1",
                
                disabled: false,
            },
            {
                id: "10",
                label: "转让",
                text: "转让",
                "data":"",
                "codename":"Item_10",
                "color": "rgba(149, 117, 205, 1)",
                value: "10",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMWOORITYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "PLAN",
                label: "计划",
                text: "计划",
                "data":"",
                "codename":"Plan",
                value: "PLAN",
                
                disabled: false,
            },
            {
                id: "PLANDETAIL",
                label: "计划步骤",
                text: "计划步骤",
                "data":"",
                "codename":"Plandetail",
                value: "PLANDETAIL",
                
                disabled: false,
            },
            {
                id: "APPLY",
                label: "申请汇报",
                text: "申请汇报",
                "data":"",
                "codename":"Apply",
                value: "APPLY",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "YesNo",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "是",
                text: "是",
                "data":"",
                "codename":"Item_1",
                value: 1,
                
                disabled: false,
            },
            {
                id: "0",
                label: "否",
                text: "否",
                "data":"",
                "codename":"Item_0",
                value: 0,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMUSETO",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "EQUIP",
                label: "单机消耗",
                text: "单机消耗",
                "data":"",
                "codename":"Equip",
                value: "EQUIP",
                
                disabled: false,
            },
            {
                id: "EQTYPE",
                label: "机型均摊",
                text: "机型均摊",
                "data":"",
                "codename":"Eqtype",
                value: "EQTYPE",
                
                disabled: false,
            },
            {
                id: "EQLOCATION",
                label: "位置均摊",
                text: "位置均摊",
                "data":"",
                "codename":"Eqlocation",
                value: "EQLOCATION",
                
                disabled: false,
            },
            {
                id: "WO",
                label: "手工摊销(供电中心专用)",
                text: "手工摊销(供电中心专用)",
                "data":"",
                "codename":"Wo",
                value: "WO",
                
                disabled: false,
            },
            {
                id: "MS",
                label: "多机/设备消耗",
                text: "多机/设备消耗",
                "data":"",
                "codename":"Ms",
                value: "MS",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMATTPRICE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "正常",
                text: "正常",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(0, 38, 255, 1)",
                value: 1,
                
                disabled: false,
            },
            {
                id: "2",
                label: "异常",
                text: "异常",
                "data":"",
                "codename":"Item_2",
                "color": "rgba(237, 19, 19, 1)",
                value: 2,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMRINSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                "color": "rgba(209, 196, 233, 1)",
                value: 0,
                
                disabled: false,
            },
            {
                id: "10",
                label: "流程中",
                text: "流程中",
                "data":"",
                "codename":"Item_10",
                "color": "rgba(0, 255, 13, 1)",
                value: 10,
                
                disabled: false,
            },
            {
                id: "20",
                label: "已入库",
                text: "已入库",
                "data":"",
                "codename":"Item_20",
                "color": "rgba(0, 98, 255, 1)",
                value: 20,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMSERVICEEVLREGION",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "2009-Q4",
                label: "2009.Q4",
                text: "2009.Q4",
                "data":"",
                "codename":"Item_1",
                value: "2009-Q4",
                
                disabled: false,
            },
            {
                id: "2010-Q1",
                label: "2010.Q1",
                text: "2010.Q1",
                "data":"",
                "codename":"Item_2",
                value: "2010-Q1",
                
                disabled: false,
            },
            {
                id: "2010-Q2",
                label: "2010.Q2",
                text: "2010.Q2",
                "data":"",
                "codename":"Item_3",
                value: "2010-Q2",
                
                disabled: false,
            },
            {
                id: "2010-Q3",
                label: "2010.Q3",
                text: "2010.Q3",
                "data":"",
                "codename":"Item_4",
                value: "2010-Q3",
                
                disabled: false,
            },
            {
                id: "2010-Q4",
                label: "2010.Q4",
                text: "2010.Q4",
                "data":"",
                "codename":"Item_5",
                value: "2010-Q4",
                
                disabled: false,
            },
            {
                id: "2011-Q1",
                label: "2011.Q1",
                text: "2011.Q1",
                "data":"",
                "codename":"Item_6",
                value: "2011-Q1",
                
                disabled: false,
            },
            {
                id: "2011-Q2",
                label: "2011.Q2",
                text: "2011.Q2",
                "data":"",
                "codename":"Item_7",
                value: "2011-Q2",
                
                disabled: false,
            },
            {
                id: "2011-Q3",
                label: "2011-Q3",
                text: "2011-Q3",
                "data":"",
                "codename":"Item_8",
                value: "2011-Q3",
                
                disabled: false,
            },
            {
                id: "2011-Q4",
                label: "2011.Q4",
                text: "2011.Q4",
                "data":"",
                "codename":"Item_9",
                value: "2011-Q4",
                
                disabled: false,
            },
            {
                id: "2012-Q1",
                label: "2012.Q1",
                text: "2012.Q1",
                "data":"",
                "codename":"Item_10",
                value: "2012-Q1",
                
                disabled: false,
            },
            {
                id: "2012-Q2",
                label: "2012.Q2",
                text: "2012.Q2",
                "data":"",
                "codename":"Item_11",
                value: "2012-Q2",
                
                disabled: false,
            },
            {
                id: "2012-Q3",
                label: "2012.Q3",
                text: "2012.Q3",
                "data":"",
                "codename":"Item_12",
                value: "2012-Q3",
                
                disabled: false,
            },
            {
                id: "2012-Q4",
                label: "2012.Q4",
                text: "2012.Q4",
                "data":"",
                "codename":"Item_13",
                value: "2012-Q4",
                
                disabled: false,
            },
            {
                id: "2013-Q1",
                label: "2013.Q1",
                text: "2013.Q1",
                "data":"",
                "codename":"Item_14",
                value: "2013-Q1",
                
                disabled: false,
            },
            {
                id: "2013-Q2",
                label: "2013.Q2",
                text: "2013.Q2",
                "data":"",
                "codename":"Item_15",
                value: "2013-Q2",
                
                disabled: false,
            },
            {
                id: "2013-Q3",
                label: "2013.Q3",
                text: "2013.Q3",
                "data":"",
                "codename":"Item_16",
                value: "2013-Q3",
                
                disabled: false,
            },
            {
                id: "2013-Q4",
                label: "2013.Q4",
                text: "2013.Q4",
                "data":"",
                "codename":"Item_17",
                value: "2013-Q4",
                
                disabled: false,
            },
            {
                id: "2014-Q1",
                label: "2014.Q1",
                text: "2014.Q1",
                "data":"",
                "codename":"Item_18",
                value: "2014-Q1",
                
                disabled: false,
            },
            {
                id: "2014-Q2",
                label: "2014.Q2",
                text: "2014.Q2",
                "data":"",
                "codename":"Item_19",
                value: "2014-Q2",
                
                disabled: false,
            },
            {
                id: "2014-Q3",
                label: "2014.Q3",
                text: "2014.Q3",
                "data":"",
                "codename":"Item_20",
                value: "2014-Q3",
                
                disabled: false,
            },
            {
                id: "2014-Q4",
                label: "2014.Q4",
                text: "2014.Q4",
                "data":"",
                "codename":"Item_21",
                value: "2014-Q4",
                
                disabled: false,
            },
            {
                id: "2015-Q1",
                label: "2015.Q1",
                text: "2015.Q1",
                "data":"",
                "codename":"Item_22",
                value: "2015-Q1",
                
                disabled: false,
            },
            {
                id: "2015-Q2",
                label: "2015.Q2",
                text: "2015.Q2",
                "data":"",
                "codename":"Item_23",
                value: "2015-Q2",
                
                disabled: false,
            },
            {
                id: "2015-Q3",
                label: "2015.Q3",
                text: "2015.Q3",
                "data":"",
                "codename":"Item_24",
                value: "2015-Q3",
                
                disabled: false,
            },
            {
                id: "2015-Q4",
                label: "2015.Q4",
                text: "2015.Q4",
                "data":"",
                "codename":"Item_25",
                value: "2015-Q4",
                
                disabled: false,
            },
            {
                id: "2016-Q1",
                label: "2016.Q1",
                text: "2016.Q1",
                "data":"",
                "codename":"Item_26",
                value: "2016-Q1",
                
                disabled: false,
            },
            {
                id: "2016-Q2",
                label: "2016.Q2",
                text: "2016.Q2",
                "data":"",
                "codename":"Item_27",
                value: "2016-Q2",
                
                disabled: false,
            },
            {
                id: "2016-Q3",
                label: "2016.Q3",
                text: "2016.Q3",
                "data":"",
                "codename":"Item_28",
                value: "2016-Q3",
                
                disabled: false,
            },
            {
                id: "2016-Q4",
                label: "2016.Q4",
                text: "2016.Q4",
                "data":"",
                "codename":"Item_29",
                value: "2016-Q4",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMWOTYPE1",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "KEEP",
                label: "保养工单",
                text: "保养工单",
                "data":"",
                "codename":"Keep",
                value: "KEEP",
                
                disabled: false,
            },
            {
                id: "KEEP1",
                label: ".  一级保养",
                text: ".  一级保养",
                "data":"",
                "codename":"Keep1",
                value: "KEEP1",
                
                disabled: false,
            },
            {
                id: "KEEP2",
                label: ".  润滑检查",
                text: ".  润滑检查",
                "data":"",
                "codename":"Keep2",
                value: "KEEP2",
                
                disabled: false,
            },
            {
                id: "KEEP3",
                label: ".  卫生维护",
                text: ".  卫生维护",
                "data":"",
                "codename":"Keep3",
                value: "KEEP3",
                
                disabled: false,
            },
            {
                id: "ERROR",
                label: "故障工单",
                text: "故障工单",
                "data":"",
                "codename":"Error",
                value: "ERROR",
                
                disabled: false,
            },
            {
                id: "ERROR1",
                label: "事故工单",
                text: "事故工单",
                "data":"",
                "codename":"Error1",
                value: "ERROR1",
                
                disabled: false,
            },
            {
                id: "CHECK",
                label: "检修工单",
                text: "检修工单",
                "data":"",
                "codename":"Check",
                value: "CHECK",
                
                disabled: false,
            },
            {
                id: "CHECKM",
                label: "月度检修",
                text: "月度检修",
                "data":"",
                "codename":"Checkm",
                value: "CHECKM",
                
                disabled: false,
            },
            {
                id: "CHECKY",
                label: "年度检修",
                text: "年度检修",
                "data":"",
                "codename":"Checky",
                value: "CHECKY",
                
                disabled: false,
            },
            {
                id: "INSTALL",
                label: "轮胎安装工单",
                text: "轮胎安装工单",
                "data":"",
                "codename":"Install",
                value: "INSTALL",
                
                disabled: false,
            },
            {
                id: "REPLACE",
                label: "钢丝绳更换工单",
                text: "钢丝绳更换工单",
                "data":"",
                "codename":"Replace",
                value: "REPLACE",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMARCHIVE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "MAINTANCE",
                label: "抢修记录",
                text: "抢修记录",
                "data":"",
                "codename":"Maintance",
                value: "MAINTANCE",
                
                disabled: false,
            },
            {
                id: "KEEP",
                label: "保养记录",
                text: "保养记录",
                "data":"",
                "codename":"Keep",
                value: "KEEP",
                
                disabled: false,
            },
            {
                id: "CHECK",
                label: "维修记录",
                text: "维修记录",
                "data":"",
                "codename":"Check",
                value: "CHECK",
                
                disabled: false,
            },
            {
                id: "DEBUG",
                label: "事故记录",
                text: "事故记录",
                "data":"",
                "codename":"Debug",
                value: "DEBUG",
                
                disabled: false,
            },
            {
                id: "SETUP",
                label: "安装更换",
                text: "安装更换",
                "data":"",
                "codename":"Setup",
                value: "SETUP",
                
                disabled: false,
            },
            {
                id: "EQWL",
                label: "运行日志",
                text: "运行日志",
                "data":"",
                "codename":"Eqwl",
                value: "EQWL",
                
                disabled: false,
            },
            {
                id: "EQKPRCT",
                label: "关键点记录",
                text: "关键点记录",
                "data":"",
                "codename":"Eqkprct",
                value: "EQKPRCT",
                
                disabled: false,
            },
            {
                id: "EQMPMTR",
                label: "仪表读数",
                text: "仪表读数",
                "data":"",
                "codename":"Eqmpmtr",
                value: "EQMPMTR",
                
                disabled: false,
            },
            {
                id: "ENCONSUM",
                label: "能耗记录",
                text: "能耗记录",
                "data":"",
                "codename":"Enconsum",
                value: "ENCONSUM",
                
                disabled: false,
            },
            {
                id: "OUTPUTRCT",
                label: "产能",
                text: "产能",
                "data":"",
                "codename":"Outputrct",
                value: "OUTPUTRCT",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMDPVALTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "NEW",
                label: "最新值",
                text: "最新值",
                "data":"",
                "codename":"New",
                value: "NEW",
                
                disabled: false,
            },
            {
                id: "SUM",
                label: "汇总值",
                text: "汇总值",
                "data":"",
                "codename":"Sum",
                value: "SUM",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMEMPRODUCTSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                value: "0",
                
                disabled: false,
            },
            {
                id: "10",
                label: "流程中",
                text: "流程中",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "已关闭",
                text: "已关闭",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMWOWFSTEP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "10",
                label: "待审核",
                text: "待审核",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "正在执行",
                text: "正在执行",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "30",
                label: "已完成",
                text: "已完成",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPOWFSTEP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "10",
                label: "待采购部经理审核",
                text: "待采购部经理审核",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "25",
                label: "待采购部分管副总审核",
                text: "待采购部分管副总审核",
                "data":"",
                "codename":"Item_25",
                value: "25",
                
                disabled: false,
            },
            {
                id: "28",
                label: "待总经理审核",
                text: "待总经理审核",
                "data":"",
                "codename":"Item_28",
                value: "28",
                
                disabled: false,
            },
            {
                id: "30",
                label: "审核不通过",
                text: "审核不通过",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
            {
                id: "40",
                label: "等待下单",
                text: "等待下单",
                "data":"",
                "codename":"Item_40",
                value: "40",
                
                disabled: false,
            },
            {
                id: "50",
                label: "在途",
                text: "在途",
                "data":"",
                "codename":"Item_50",
                value: "50",
                
                disabled: false,
            },
            {
                id: "60",
                label: "到货验收中",
                text: "到货验收中",
                "data":"",
                "codename":"Item_60",
                value: "60",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMCONTRACTOBJGROUP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "GYS",
                label: "供应商",
                text: "供应商",
                "data":"",
                "codename":"Gys",
                value: "GYS",
                
                disabled: false,
            },
            {
                id: "ZZS",
                label: "制造商",
                text: "制造商",
                "data":"",
                "codename":"Zzs",
                value: "ZZS",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMAPPRSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "YSH",
                label: "已审核",
                text: "已审核",
                "data":"",
                "codename":"Ysh",
                value: "YSH",
                
                disabled: false,
            },
            {
                id: "WSH",
                label: "未审核",
                text: "未审核",
                "data":"",
                "codename":"Wsh",
                value: "WSH",
                
                disabled: false,
            },
            {
                id: "SHWTG",
                label: "审核未通过",
                text: "审核未通过",
                "data":"",
                "codename":"Shwtg",
                value: "SHWTG",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMEQTYPEGROUP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "桥龙",
                text: "桥龙",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(49, 27, 146, 1)",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "流机",
                text: "流机",
                "data":"",
                "codename":"Item_2",
                "color": "rgba(81, 45, 168, 1)",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "吊具",
                text: "吊具",
                "data":"",
                "codename":"Item_3",
                "color": "rgba(103, 58, 183, 1)",
                value: "3",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMASSETCLASSGROUP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "1",
                text: "1",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMWOGROUP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "PLAN",
                label: "周期/条件(PM/PPM)",
                text: "周期/条件(PM/PPM)",
                "data":"",
                "codename":"Plan",
                value: "PLAN",
                
                disabled: false,
            },
            {
                id: "APPLY",
                label: "申请工单",
                text: "申请工单",
                "data":"",
                "codename":"Apply",
                value: "APPLY",
                
                disabled: false,
            },
            {
                id: "TASK",
                label: "任务计划工单",
                text: "任务计划工单",
                "data":"",
                "codename":"Task",
                value: "TASK",
                
                disabled: false,
            },
            {
                id: "URG",
                label: "紧急工单",
                text: "紧急工单",
                "data":"",
                "codename":"Urg",
                value: "URG",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPLANSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "正常",
                text: "正常",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(0, 64, 255, 1)",
                value: 1,
                
                disabled: false,
            },
            {
                id: "2",
                label: "暂停",
                text: "暂停",
                "data":"",
                "codename":"Item_2",
                "color": "rgba(255, 0, 0, 0.94)",
                value: 2,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMSERVICEEVLSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                "color": "rgba(255, 234, 0, 1)",
                value: "0",
                
                disabled: false,
            },
            {
                id: "10",
                label: "流程中",
                text: "流程中",
                "data":"",
                "codename":"Item_10",
                "color": "rgba(102, 255, 0, 1)",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "已完成",
                text: "已完成",
                "data":"",
                "codename":"Item_20",
                "color": "rgba(0, 47, 255, 1)",
                value: "20",
                
                disabled: false,
            },
            {
                id: "30",
                label: "过期",
                text: "过期",
                "data":"",
                "codename":"Item_30",
                "color": "rgba(232, 13, 13, 1)",
                value: "30",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMTRADESTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                value: "0",
                
                disabled: false,
            },
            {
                id: "10",
                label: "流程中",
                text: "流程中",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "20",
                label: "已确认",
                text: "已确认",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMOBJTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "EQTYPE",
                label: "设备类型",
                text: "设备类型",
                "data":"",
                "codename":"Eqtype",
                value: "EQTYPE",
                
                disabled: false,
            },
            {
                id: "EQLOCATION",
                label: "位置",
                text: "位置",
                "data":"",
                "codename":"Eqlocation",
                value: "EQLOCATION",
                
                disabled: false,
            },
            {
                id: "EQUIP",
                label: "设备",
                text: "设备",
                "data":"",
                "codename":"Equip",
                value: "EQUIP",
                
                disabled: false,
            },
            {
                id: "ITEMTYPE",
                label: "物品类型",
                text: "物品类型",
                "data":"",
                "codename":"Itemtype",
                value: "ITEMTYPE",
                
                disabled: false,
            },
            {
                id: "ITEM",
                label: "物品",
                text: "物品",
                "data":"",
                "codename":"Item",
                value: "ITEM",
                
                disabled: false,
            },
            {
                id: "RFODETYPE",
                label: "现象类型",
                text: "现象类型",
                "data":"",
                "codename":"Rfodetype",
                value: "RFODETYPE",
                
                disabled: false,
            },
            {
                id: "SPARE",
                label: "备件包",
                text: "备件包",
                "data":"",
                "codename":"Spare",
                value: "SPARE",
                
                disabled: false,
            },
            {
                id: "RFODE",
                label: "现象",
                text: "现象",
                "data":"",
                "codename":"Rfode",
                value: "RFODE",
                
                disabled: false,
            },
            {
                id: "DRWG",
                label: "文档",
                text: "文档",
                "data":"",
                "codename":"Drwg",
                value: "DRWG",
                
                disabled: false,
            },
            {
                id: "EQMP",
                label: "仪表",
                text: "仪表",
                "data":"",
                "codename":"Eqmp",
                value: "EQMP",
                
                disabled: false,
            },
            {
                id: "EQKP",
                label: "关键点",
                text: "关键点",
                "data":"",
                "codename":"Eqkp",
                value: "EQKP",
                
                disabled: false,
            },
            {
                id: "EN",
                label: "能源",
                text: "能源",
                "data":"",
                "codename":"En",
                value: "EN",
                
                disabled: false,
            },
            {
                id: "OUTPUT",
                label: "能力",
                text: "能力",
                "data":"",
                "codename":"Output",
                value: "OUTPUT",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMDRWGTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "D-1",
                label: "桥吊",
                text: "桥吊",
                "data":"",
                "codename":"D_SUB_1",
                value: "D-1",
                
                disabled: false,
            },
            {
                id: "D-11",
                label: "操作手册",
                text: "操作手册",
                "data":"",
                "codename":"D_SUB_11",
                value: "D-11",
                "pvalue": "D-1",
                disabled: false,
            },
            {
                id: "D-12",
                label: "主要电气线路图",
                text: "主要电气线路图",
                "data":"",
                "codename":"D_SUB_12",
                value: "D-12",
                "pvalue": "D-1",
                disabled: false,
            },
            {
                id: "D-15",
                label: "技术手册（电气）",
                text: "技术手册（电气）",
                "data":"",
                "codename":"D_SUB_15",
                value: "D-15",
                "pvalue": "D-1",
                disabled: false,
            },
            {
                id: "D-16",
                label: "技术手册（机械）",
                text: "技术手册（机械）",
                "data":"",
                "codename":"D_SUB_16",
                value: "D-16",
                "pvalue": "D-1",
                disabled: false,
            },
            {
                id: "D-17",
                label: "配件手册（电气）",
                text: "配件手册（电气）",
                "data":"",
                "codename":"D_SUB_17",
                value: "D-17",
                "pvalue": "D-1",
                disabled: false,
            },
            {
                id: "D-18",
                label: "配件手册（机械）",
                text: "配件手册（机械）",
                "data":"",
                "codename":"D_SUB_18",
                value: "D-18",
                "pvalue": "D-1",
                disabled: false,
            },
            {
                id: "D-19",
                label: "其他",
                text: "其他",
                "data":"",
                "codename":"D_SUB_19",
                value: "D-19",
                "pvalue": "D-1",
                disabled: false,
            },
            {
                id: "D-2",
                label: "龙门吊",
                text: "龙门吊",
                "data":"",
                "codename":"D_SUB_2",
                value: "D-2",
                
                disabled: false,
            },
            {
                id: "D-21",
                label: "操作手册",
                text: "操作手册",
                "data":"",
                "codename":"D_SUB_21",
                value: "D-21",
                "pvalue": "D-2",
                disabled: false,
            },
            {
                id: "D-22",
                label: "主要电气线路图",
                text: "主要电气线路图",
                "data":"",
                "codename":"D_SUB_22",
                value: "D-22",
                "pvalue": "D-2",
                disabled: false,
            },
            {
                id: "D-25",
                label: "技术手册（电气）",
                text: "技术手册（电气）",
                "data":"",
                "codename":"D_SUB_25",
                value: "D-25",
                "pvalue": "D-2",
                disabled: false,
            },
            {
                id: "D-26",
                label: "技术手册（机械）",
                text: "技术手册（机械）",
                "data":"",
                "codename":"D_SUB_26",
                value: "D-26",
                "pvalue": "D-2",
                disabled: false,
            },
            {
                id: "D-27",
                label: "配件手册（电气）",
                text: "配件手册（电气）",
                "data":"",
                "codename":"D_SUB_27",
                value: "D-27",
                "pvalue": "D-2",
                disabled: false,
            },
            {
                id: "D-28",
                label: "配件手册（机械）",
                text: "配件手册（机械）",
                "data":"",
                "codename":"D_SUB_28",
                value: "D-28",
                "pvalue": "D-2",
                disabled: false,
            },
            {
                id: "D-29",
                label: "其他",
                text: "其他",
                "data":"",
                "codename":"D_SUB_29",
                value: "D-29",
                "pvalue": "D-2",
                disabled: false,
            },
            {
                id: "D-3",
                label: "流机",
                text: "流机",
                "data":"",
                "codename":"D_SUB_3",
                value: "D-3",
                
                disabled: false,
            },
            {
                id: "D-31",
                label: "操作手册",
                text: "操作手册",
                "data":"",
                "codename":"D_SUB_31",
                value: "D-31",
                "pvalue": "D-3",
                disabled: false,
            },
            {
                id: "D-32",
                label: "主要电气线路图",
                text: "主要电气线路图",
                "data":"",
                "codename":"D_SUB_32",
                value: "D-32",
                "pvalue": "D-3",
                disabled: false,
            },
            {
                id: "D-35",
                label: "技术手册（电气）",
                text: "技术手册（电气）",
                "data":"",
                "codename":"D_SUB_35",
                value: "D-35",
                "pvalue": "D-3",
                disabled: false,
            },
            {
                id: "D-36",
                label: "技术手册（机械）",
                text: "技术手册（机械）",
                "data":"",
                "codename":"D_SUB_36",
                value: "D-36",
                "pvalue": "D-3",
                disabled: false,
            },
            {
                id: "D-37",
                label: "配件手册（电气）",
                text: "配件手册（电气）",
                "data":"",
                "codename":"D_SUB_37",
                value: "D-37",
                "pvalue": "D-3",
                disabled: false,
            },
            {
                id: "D-38",
                label: "配件手册（机械）",
                text: "配件手册（机械）",
                "data":"",
                "codename":"D_SUB_38",
                value: "D-38",
                "pvalue": "D-3",
                disabled: false,
            },
            {
                id: "D-39",
                label: "其他",
                text: "其他",
                "data":"",
                "codename":"D_SUB_39",
                value: "D-39",
                "pvalue": "D-3",
                disabled: false,
            },
            {
                id: "D-4",
                label: "设备标准化管理",
                text: "设备标准化管理",
                "data":"",
                "codename":"D_SUB_4",
                value: "D-4",
                
                disabled: false,
            },
            {
                id: "D-41",
                label: "组织机构",
                text: "组织机构",
                "data":"",
                "codename":"D_SUB_41",
                value: "D-41",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-411",
                label: "机构设置",
                text: "机构设置",
                "data":"",
                "codename":"D_SUB_411",
                value: "D-411",
                "pvalue": "D-41",
                disabled: false,
            },
            {
                id: "D-412",
                label: "管理人员配备",
                text: "管理人员配备",
                "data":"",
                "codename":"D_SUB_412",
                value: "D-412",
                "pvalue": "D-41",
                disabled: false,
            },
            {
                id: "D-42",
                label: "规章制度",
                text: "规章制度",
                "data":"",
                "codename":"D_SUB_42",
                value: "D-42",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-421",
                label: "设备管理制度建设",
                text: "设备管理制度建设",
                "data":"",
                "codename":"D_SUB_421",
                value: "D-421",
                "pvalue": "D-42",
                disabled: false,
            },
            {
                id: "D-422",
                label: "操作规程",
                text: "操作规程",
                "data":"",
                "codename":"D_SUB_422",
                value: "D-422",
                "pvalue": "D-42",
                disabled: false,
            },
            {
                id: "D-43",
                label: "安全生产责任制落实",
                text: "安全生产责任制落实",
                "data":"",
                "codename":"D_SUB_43",
                value: "D-43",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-431",
                label: "部门安全生产责任制",
                text: "部门安全生产责任制",
                "data":"",
                "codename":"D_SUB_431",
                value: "D-431",
                "pvalue": "D-43",
                disabled: false,
            },
            {
                id: "D-432",
                label: "岗位安全责任制",
                text: "岗位安全责任制",
                "data":"",
                "codename":"D_SUB_432",
                value: "D-432",
                "pvalue": "D-43",
                disabled: false,
            },
            {
                id: "D-44",
                label: "设备管理",
                text: "设备管理",
                "data":"",
                "codename":"D_SUB_44",
                value: "D-44",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-441",
                label: "使用登记",
                text: "使用登记",
                "data":"",
                "codename":"D_SUB_441",
                value: "D-441",
                "pvalue": "D-44",
                disabled: false,
            },
            {
                id: "D-442",
                label: "检验检测",
                text: "检验检测",
                "data":"",
                "codename":"D_SUB_442",
                value: "D-442",
                "pvalue": "D-44",
                disabled: false,
            },
            {
                id: "D-443",
                label: "安全附件",
                text: "安全附件",
                "data":"",
                "codename":"D_SUB_443",
                value: "D-443",
                "pvalue": "D-44",
                disabled: false,
            },
            {
                id: "D-444",
                label: "维护保养",
                text: "维护保养",
                "data":"",
                "codename":"D_SUB_444",
                value: "D-444",
                "pvalue": "D-44",
                disabled: false,
            },
            {
                id: "D-445",
                label: "停用报废",
                text: "停用报废",
                "data":"",
                "codename":"D_SUB_445",
                value: "D-445",
                "pvalue": "D-44",
                disabled: false,
            },
            {
                id: "D-446",
                label: "档案管理",
                text: "档案管理",
                "data":"",
                "codename":"D_SUB_446",
                value: "D-446",
                "pvalue": "D-44",
                disabled: false,
            },
            {
                id: "D-447",
                label: "运行记录",
                text: "运行记录",
                "data":"",
                "codename":"D_SUB_447",
                value: "D-447",
                "pvalue": "D-44",
                disabled: false,
            },
            {
                id: "D-448",
                label: "分包管理",
                text: "分包管理",
                "data":"",
                "codename":"D_SUB_448",
                value: "D-448",
                "pvalue": "D-44",
                disabled: false,
            },
            {
                id: "D-45",
                label: "人员管理",
                text: "人员管理",
                "data":"",
                "codename":"D_SUB_45",
                value: "D-45",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-451",
                label: "资格管理",
                text: "资格管理",
                "data":"",
                "codename":"D_SUB_451",
                value: "D-451",
                "pvalue": "D-45",
                disabled: false,
            },
            {
                id: "D-452",
                label: "教育培训",
                text: "教育培训",
                "data":"",
                "codename":"D_SUB_452",
                value: "D-452",
                "pvalue": "D-45",
                disabled: false,
            },
            {
                id: "D-453",
                label: "上岗作业",
                text: "上岗作业",
                "data":"",
                "codename":"D_SUB_453",
                value: "D-453",
                "pvalue": "D-45",
                disabled: false,
            },
            {
                id: "D-46",
                label: "日常检查",
                text: "日常检查",
                "data":"",
                "codename":"D_SUB_46",
                value: "D-46",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-461",
                label: "安全巡查",
                text: "安全巡查",
                "data":"",
                "codename":"D_SUB_461",
                value: "D-461",
                "pvalue": "D-46",
                disabled: false,
            },
            {
                id: "D-47",
                label: "事故隐患",
                text: "事故隐患",
                "data":"",
                "codename":"D_SUB_47",
                value: "D-47",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-471",
                label: "隐患整改",
                text: "隐患整改",
                "data":"",
                "codename":"D_SUB_471",
                value: "D-471",
                "pvalue": "D-47",
                disabled: false,
            },
            {
                id: "D-48",
                label: "事故应急处理",
                text: "事故应急处理",
                "data":"",
                "codename":"D_SUB_48",
                value: "D-48",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-481",
                label: "应急救援预案建立",
                text: "应急救援预案建立",
                "data":"",
                "codename":"D_SUB_481",
                value: "D-481",
                "pvalue": "D-48",
                disabled: false,
            },
            {
                id: "D-482",
                label: "应急救援预案演练",
                text: "应急救援预案演练",
                "data":"",
                "codename":"D_SUB_482",
                value: "D-482",
                "pvalue": "D-48",
                disabled: false,
            },
            {
                id: "D-483",
                label: "突发事故应对",
                text: "突发事故应对",
                "data":"",
                "codename":"D_SUB_483",
                value: "D-483",
                "pvalue": "D-48",
                disabled: false,
            },
            {
                id: "D-49",
                label: "表格",
                text: "表格",
                "data":"",
                "codename":"D_SUB_49",
                value: "D-49",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-491",
                label: "特种设备表格",
                text: "特种设备表格",
                "data":"",
                "codename":"D_SUB_491",
                value: "D-491",
                "pvalue": "D-49",
                disabled: false,
            },
            {
                id: "D-4A",
                label: "科技进步",
                text: "科技进步",
                "data":"",
                "codename":"D_SUB_4a",
                value: "D-4A",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-4A1",
                label: "科技进步",
                text: "科技进步",
                "data":"",
                "codename":"D_SUB_4a1",
                value: "D-4A1",
                "pvalue": "D-4A",
                disabled: false,
            },
            {
                id: "D-4A2",
                label: "科技进步奖",
                text: "科技进步奖",
                "data":"",
                "codename":"D_SUB_4a2",
                value: "D-4A2",
                "pvalue": "D-4A",
                disabled: false,
            },
            {
                id: "D-4A21",
                label: "技术部",
                text: "技术部",
                "data":"",
                "codename":"D_SUB_4a21",
                value: "D-4A21",
                "pvalue": "D-4A2",
                disabled: false,
            },
            {
                id: "D-4A22",
                label: "事务部",
                text: "事务部",
                "data":"",
                "codename":"D_SUB_4a22",
                value: "D-4A22",
                "pvalue": "D-4A2",
                disabled: false,
            },
            {
                id: "D-4A23",
                label: "维修中心",
                text: "维修中心",
                "data":"",
                "codename":"D_SUB_4a23",
                value: "D-4A23",
                "pvalue": "D-4A2",
                disabled: false,
            },
            {
                id: "D-4B",
                label: "文明设备评比",
                text: "文明设备评比",
                "data":"",
                "codename":"D_SUB_4b",
                value: "D-4B",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-4B1",
                label: "文明设备评比",
                text: "文明设备评比",
                "data":"",
                "codename":"D_SUB_4b1",
                value: "D-4B1",
                "pvalue": "D-4B",
                disabled: false,
            },
            {
                id: "D-4C",
                label: "标准操作法",
                text: "标准操作法",
                "data":"",
                "codename":"D_SUB_4c",
                value: "D-4C",
                "pvalue": "D-4",
                disabled: false,
            },
            {
                id: "D-4C1",
                label: "标准操作法手册",
                text: "标准操作法手册",
                "data":"",
                "codename":"D_SUB_4c1",
                value: "D-4C1",
                "pvalue": "D-4C",
                disabled: false,
            },
            {
                id: "D-5",
                label: "技术部工作报告",
                text: "技术部工作报告",
                "data":"",
                "codename":"D_SUB_5",
                value: "D-5",
                
                disabled: false,
            },
            {
                id: "D-51",
                label: "技术部月度工作总结",
                text: "技术部月度工作总结",
                "data":"",
                "codename":"D_SUB_51",
                value: "D-51",
                "pvalue": "D-5",
                disabled: false,
            },
            {
                id: "D-52",
                label: "季度经济分析",
                text: "季度经济分析",
                "data":"",
                "codename":"D_SUB_52",
                value: "D-52",
                "pvalue": "D-5",
                disabled: false,
            },
            {
                id: "D-53",
                label: "维修中心月度工作报告",
                text: "维修中心月度工作报告",
                "data":"",
                "codename":"D_SUB_53",
                value: "D-53",
                "pvalue": "D-5",
                disabled: false,
            },
            {
                id: "D-55",
                label: "维修中心月度采购计划",
                text: "维修中心月度采购计划",
                "data":"",
                "codename":"D_SUB_55",
                value: "D-55",
                "pvalue": "D-5",
                disabled: false,
            },
            {
                id: "D-54",
                label: "能源分析",
                text: "能源分析",
                "data":"",
                "codename":"D_SUB_54",
                value: "D-54",
                "pvalue": "D-5",
                disabled: false,
            },
            {
                id: "D-6",
                label: "发票归档",
                text: "发票归档",
                "data":"",
                "codename":"D_SUB_6",
                value: "D-6",
                
                disabled: false,
            },
            {
                id: "D-9",
                label: "其他文档",
                text: "其他文档",
                "data":"",
                "codename":"D_SUB_9",
                value: "D-9",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPERFORMSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "WLX",
                label: "未履行",
                text: "未履行",
                "data":"",
                "codename":"Wlx",
                value: "WLX",
                
                disabled: false,
            },
            {
                id: "LXZ",
                label: "履行中",
                text: "履行中",
                "data":"",
                "codename":"Lxz",
                value: "LXZ",
                
                disabled: false,
            },
            {
                id: "LXJS",
                label: "履行结束",
                text: "履行结束",
                "data":"",
                "codename":"Lxjs",
                value: "LXJS",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "CODELIST",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "小车外委",
                text: "小车外委",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "零配件加工",
                text: "零配件加工",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "设备保养检测",
                text: "设备保养检测",
                "data":"",
                "codename":"Item_3",
                value: "3",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMSERVICESTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                "color": "rgba(255, 217, 0, 1)",
                value: "0",
                
                disabled: false,
            },
            {
                id: "5",
                label: "审核中",
                text: "审核中",
                "data":"",
                "codename":"Item_5",
                "color": "rgba(255, 140, 0, 1)",
                value: "5",
                
                disabled: false,
            },
            {
                id: "20",
                label: "审核通过",
                text: "审核通过",
                "data":"",
                "codename":"Item_20",
                "color": "rgba(0, 221, 255, 1)",
                value: "20",
                
                disabled: false,
            },
            {
                id: "25",
                label: "审核未通过",
                text: "审核未通过",
                "data":"",
                "codename":"Item_25",
                "color": "rgba(239, 12, 12, 1)",
                value: "25",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMENERGYTYPEID",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "E",
                label: "电",
                text: "电",
                "data":"",
                "codename":"E",
                "color": "rgba(161, 3, 252, 1)",
                value: "E",
                
                disabled: false,
            },
            {
                id: "W",
                label: "水",
                text: "水",
                "data":"",
                "codename":"W",
                "color": "rgba(0, 81, 255, 1)",
                value: "W",
                
                disabled: false,
            },
            {
                id: "H",
                label: "燃料",
                text: "燃料",
                "data":"",
                "codename":"H",
                "color": "rgba(255, 132, 0, 1)",
                value: "H",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMMPTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "1",
                text: "1",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPUSETYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "故障修理",
                text: "故障修理",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "计划修理",
                text: "计划修理",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "日常检修",
                text: "日常检修",
                "data":"",
                "codename":"Item_3",
                value: "3",
                
                disabled: false,
            },
            {
                id: "4",
                label: "保养",
                text: "保养",
                "data":"",
                "codename":"Item_4",
                value: "4",
                
                disabled: false,
            },
            {
                id: "5",
                label: "其它",
                text: "其它",
                "data":"",
                "codename":"Item_5",
                value: "5",
                
                disabled: false,
            },
            {
                id: "6",
                label: "非设备修理费",
                text: "非设备修理费",
                "data":"",
                "codename":"Item_6",
                value: "6",
                
                disabled: false,
            },
            {
                id: "7",
                label: "销售",
                text: "销售",
                "data":"",
                "codename":"Item_7",
                value: "7",
                
                disabled: false,
            },
            {
                id: "8",
                label: "外委",
                text: "外委",
                "data":"",
                "codename":"Item_8",
                value: "8",
                
                disabled: false,
            },
            {
                id: "99",
                label: "专项修理费",
                text: "专项修理费",
                "data":"",
                "codename":"Item_99",
                value: "99",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMISNEW_001",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "新",
                text: "新",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "0",
                label: "旧",
                text: "旧",
                "data":"",
                "codename":"Item_0",
                value: "0",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMSTORETYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "1",
                text: "1",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMTIRESSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "正常",
                text: "正常",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "QQ",
                label: "缺气",
                text: "缺气",
                "data":"",
                "codename":"Qq",
                value: "QQ",
                
                disabled: false,
            },
            {
                id: "QZSH",
                label: "气嘴损坏",
                text: "气嘴损坏",
                "data":"",
                "codename":"Qzsh",
                value: "QZSH",
                
                disabled: false,
            },
            {
                id: "MFQH",
                label: "密封圈坏",
                text: "密封圈坏",
                "data":"",
                "codename":"Mfqh",
                value: "MFQH",
                
                disabled: false,
            },
            {
                id: "HP",
                label: "划破",
                text: "划破",
                "data":"",
                "codename":"Hp",
                value: "HP",
                
                disabled: false,
            },
            {
                id: "CP",
                label: "戳破",
                text: "戳破",
                "data":"",
                "codename":"Cp",
                value: "CP",
                
                disabled: false,
            },
            {
                id: "GJTL",
                label: "挂胶脱落",
                text: "挂胶脱落",
                "data":"",
                "codename":"Gjtl",
                value: "GJTL",
                
                disabled: false,
            },
            {
                id: "MSDJX",
                label: "磨损到极限",
                text: "磨损到极限",
                "data":"",
                "codename":"Msdjx",
                value: "MSDJX",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMDRWGSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "正常可用",
                text: "正常可用",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(0, 187, 255, 1)",
                value: "1",
                
                disabled: false,
            },
            {
                id: "-1",
                label: "过期",
                text: "过期",
                "data":"",
                "codename":"_SUB_1",
                "color": "rgba(241, 9, 9, 1)",
                value: "-1",
                
                disabled: false,
            },
            {
                id: "0",
                label: "借出",
                text: "借出",
                "data":"",
                "codename":"Item_0",
                "color": "rgba(255, 157, 0, 1)",
                value: "0",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPLANTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "CHECK",
                label: "检修计划",
                text: "检修计划",
                "data":"",
                "codename":"Check",
                "color": "rgba(49, 27, 146, 1)",
                value: "CHECK",
                
                disabled: false,
            },
            {
                id: "KEEP",
                label: "保养计划",
                text: "保养计划",
                "data":"",
                "codename":"Keep",
                "color": "rgba(81, 45, 168, 1)",
                value: "KEEP",
                
                disabled: false,
            },
            {
                id: "KEEP1",
                label: ".  一级保养",
                text: ".  一级保养",
                "data":"",
                "codename":"Keep1",
                "color": "rgba(103, 58, 183, 1)",
                value: "KEEP1",
                
                disabled: false,
            },
            {
                id: "KEEP2",
                label: ".  润滑检查",
                text: ".  润滑检查",
                "data":"",
                "codename":"Keep2",
                "color": "rgba(103, 58, 183, 1)",
                value: "KEEP2",
                
                disabled: false,
            },
            {
                id: "KEEP3",
                label: ".  卫生维护",
                text: ".  卫生维护",
                "data":"",
                "codename":"Keep3",
                "color": "rgba(103, 58, 183, 1)",
                value: "KEEP3",
                
                disabled: false,
            },
            {
                id: "EN",
                label: "能耗登记计划",
                text: "能耗登记计划",
                "data":"",
                "codename":"En",
                "color": "rgba(149, 117, 205, 1)",
                value: "EN",
                
                disabled: false,
            },
            {
                id: "DP",
                label: "点检计划",
                text: "点检计划",
                "data":"",
                "codename":"Dp",
                "color": "rgba(209, 196, 233, 1)",
                value: "DP",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMWPLISTTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "LAPPLY",
                label: "零星采购",
                text: "零星采购",
                "data":"",
                "codename":"Lapply",
                value: "LAPPLY",
                
                disabled: false,
            },
            {
                id: "MAPPLY",
                label: "月度采购",
                text: "月度采购",
                "data":"",
                "codename":"Mapply",
                value: "MAPPLY",
                
                disabled: false,
            },
            {
                id: "APPLY",
                label: "采购申请",
                text: "采购申请",
                "data":"",
                "codename":"Apply",
                value: "APPLY",
                
                disabled: false,
            },
            {
                id: "STOCKP",
                label: "库存规则自动",
                text: "库存规则自动",
                "data":"",
                "codename":"Stockp",
                value: "STOCKP",
                
                disabled: false,
            },
            {
                id: "NEW",
                label: "试用品采纳",
                text: "试用品采纳",
                "data":"",
                "codename":"New",
                value: "NEW",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMEQUIPSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "正常运行",
                text: "正常运行",
                "data":"",
                "codename":"Item_1",
                "color": "rgba(0, 98, 255, 1)",
                value: "1",
                
                disabled: false,
            },
            {
                id: "YJQX",
                label: "应急抢修",
                text: "应急抢修",
                "data":"",
                "codename":"Yjqx",
                value: "YJQX",
                
                disabled: false,
            },
            {
                id: "GZTY",
                label: "停用",
                text: "停用",
                "data":"",
                "codename":"Gzty",
                "color": "rgba(234, 22, 22, 1)",
                value: "GZTY",
                
                disabled: false,
            },
            {
                id: "JHWX",
                label: "计划维修",
                text: "计划维修",
                "data":"",
                "codename":"Jhwx",
                value: "JHWX",
                
                disabled: false,
            },
            {
                id: "BYRH",
                label: "保养润滑",
                text: "保养润滑",
                "data":"",
                "codename":"Byrh",
                value: "BYRH",
                
                disabled: false,
            },
            {
                id: "CZYH",
                label: "存在隐患",
                text: "存在隐患",
                "data":"",
                "codename":"Czyh",
                value: "CZYH",
                
                disabled: false,
            },
            {
                id: "FC",
                label: "封存",
                text: "封存",
                "data":"",
                "codename":"Fc",
                value: "FC",
                
                disabled: false,
            },
            {
                id: "CZ",
                label: "出租",
                text: "出租",
                "data":"",
                "codename":"Cz",
                value: "CZ",
                
                disabled: false,
            },
            {
                id: "WB",
                label: "外派作业",
                text: "外派作业",
                "data":"",
                "codename":"Wb",
                value: "WB",
                
                disabled: false,
            },
            {
                id: "BF",
                label: "报废",
                text: "报废",
                "data":"",
                "codename":"Bf",
                "color": "rgba(215, 19, 19, 1)",
                value: "BF",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPOSTATE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未提交",
                text: "未提交",
                "data":"",
                "codename":"Item_0",
                "color": "rgba(209, 196, 233, 1)",
                value: 0,
                
                disabled: false,
            },
            {
                id: "10",
                label: "流程中",
                text: "流程中",
                "data":"",
                "codename":"Item_10",
                "color": "rgba(149, 117, 205, 1)",
                value: 10,
                
                disabled: false,
            },
            {
                id: "20",
                label: "已关闭",
                text: "已关闭",
                "data":"",
                "codename":"Item_20",
                "color": "rgba(81, 45, 168, 1)",
                value: 20,
                
                disabled: false,
            },
            {
                id: "30",
                label: "已取消",
                text: "已取消",
                "data":"",
                "codename":"Item_30",
                "color": "rgba(49, 27, 146, 1)",
                value: 30,
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMITEMRINWPSTEP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "15",
                label: "待打印",
                text: "待打印",
                "data":"",
                "codename":"Item_15",
                value: "15",
                
                disabled: false,
            },
            {
                id: "10",
                label: "待入库",
                text: "待入库",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMSDEPT",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "综合管理部",
                text: "综合管理部",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "财务部",
                text: "财务部",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "电脑部",
                text: "电脑部",
                "data":"",
                "codename":"Item_3",
                value: "3",
                
                disabled: false,
            },
            {
                id: "4",
                label: "市场部",
                text: "市场部",
                "data":"",
                "codename":"Item_4",
                value: "4",
                
                disabled: false,
            },
            {
                id: "5",
                label: "CSF",
                text: "CSF",
                "data":"",
                "codename":"Item_5",
                value: "5",
                
                disabled: false,
            },
            {
                id: "6",
                label: "工程建设部",
                text: "工程建设部",
                "data":"",
                "codename":"Item_6",
                value: "6",
                
                disabled: false,
            },
            {
                id: "7",
                label: "党群工作部",
                text: "党群工作部",
                "data":"",
                "codename":"Item_7",
                value: "7",
                
                disabled: false,
            },
            {
                id: "8",
                label: "运行中心",
                text: "运行中心",
                "data":"",
                "codename":"Item_8",
                value: "8",
                
                disabled: false,
            },
            {
                id: "9",
                label: "维修中心",
                text: "维修中心",
                "data":"",
                "codename":"Item_9",
                value: "9",
                
                disabled: false,
            },
            {
                id: "10",
                label: "供电所",
                text: "供电所",
                "data":"",
                "codename":"Item_10",
                value: "10",
                
                disabled: false,
            },
            {
                id: "11",
                label: "操作部",
                text: "操作部",
                "data":"",
                "codename":"Item_11",
                value: "11",
                
                disabled: false,
            },
            {
                id: "12",
                label: "安监部",
                text: "安监部",
                "data":"",
                "codename":"Item_12",
                value: "12",
                
                disabled: false,
            },
            {
                id: "13",
                label: "技术部",
                text: "技术部",
                "data":"",
                "codename":"Item_13",
                value: "13",
                
                disabled: false,
            },
            {
                id: "14",
                label: "闸口",
                text: "闸口",
                "data":"",
                "codename":"Item_14",
                value: "14",
                
                disabled: false,
            },
            {
                id: "15",
                label: "工具库",
                text: "工具库",
                "data":"",
                "codename":"Item_15",
                value: "15",
                
                disabled: false,
            },
            {
                id: "16",
                label: "商务部",
                text: "商务部",
                "data":"",
                "codename":"Item_16",
                value: "16",
                
                disabled: false,
            },
            {
                id: "17",
                label: "采购部",
                text: "采购部",
                "data":"",
                "codename":"Item_17",
                value: "17",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMITEMPUSEWFSTEP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "5",
                label: "工量具管理员审核",
                text: "工量具管理员审核",
                "data":"",
                "codename":"Item_5",
                value: "5",
                
                disabled: false,
            },
            {
                id: "20",
                label: "待部门经理审核",
                text: "待部门经理审核",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "25",
                label: "待部门分管副总审核",
                text: "待部门分管副总审核",
                "data":"",
                "codename":"Item_25",
                value: "25",
                
                disabled: false,
            },
            {
                id: "30",
                label: "审核不通过",
                text: "审核不通过",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
            {
                id: "35",
                label: "待综管部经理审核",
                text: "待综管部经理审核",
                "data":"",
                "codename":"Item_35",
                value: "35",
                
                disabled: false,
            },
            {
                id: "40",
                label: "待发料",
                text: "待发料",
                "data":"",
                "codename":"Item_40",
                value: "40",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "FEBEC2B8438144B19B682C0A4CB6EA17",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "205",
                label: "设备维修领用",
                text: "设备维修领用",
                "data":"",
                "codename":"Item_205",
                value: "205",
                
                disabled: false,
            },
            {
                id: "206",
                label: "设施维修领用",
                text: "设施维修领用",
                "data":"",
                "codename":"Item_206",
                value: "206",
                
                disabled: false,
            },
            {
                id: "204",
                label: "其他维修领用",
                text: "其他维修领用",
                "data":"",
                "codename":"Item_204",
                value: "204",
                
                disabled: false,
            },
            {
                id: "202",
                label: "劳保领用",
                text: "劳保领用",
                "data":"",
                "codename":"Item_202",
                value: "202",
                
                disabled: false,
            },
            {
                id: "207",
                label: "一般物料领用",
                text: "一般物料领用",
                "data":"",
                "codename":"Item_207",
                value: "207",
                
                disabled: false,
            },
            {
                id: "201",
                label: "安全生产领用",
                text: "安全生产领用",
                "data":"",
                "codename":"Item_201",
                value: "201",
                
                disabled: false,
            },
            {
                id: "203",
                label: "联检领用",
                text: "联检领用",
                "data":"",
                "codename":"Item_203",
                value: "203",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMRHYTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "JY",
                label: "机油",
                text: "机油",
                "data":"",
                "codename":"Jy",
                "color": "rgba(49, 27, 146, 1)",
                value: "JY",
                
                disabled: false,
            },
            {
                id: "CLY",
                label: "齿轮油",
                text: "齿轮油",
                "data":"",
                "codename":"Cly",
                "color": "rgba(81, 45, 168, 1)",
                value: "CLY",
                
                disabled: false,
            },
            {
                id: "YYY",
                label: "液压油",
                text: "液压油",
                "data":"",
                "codename":"Yyy",
                "color": "rgba(103, 58, 183, 1)",
                value: "YYY",
                
                disabled: false,
            },
            {
                id: "JLCDY",
                label: "液力传动油",
                text: "液力传动油",
                "data":"",
                "codename":"Jlcdy",
                "color": "rgba(149, 117, 205, 1)",
                value: "JLCDY",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "WFStates",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "0",
                label: "未启动",
                text: "未启动",
                "data":"",
                "codename":"Item_0",
                value: "0",
                
                disabled: false,
            },
            {
                id: "1",
                label: "流程中",
                text: "流程中",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "已完成",
                text: "已完成",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "已取消",
                text: "已取消",
                "data":"",
                "codename":"Item_3",
                value: "3",
                
                disabled: false,
            },
            {
                id: "31",
                label: "已取消(人工)",
                text: "已取消(人工)",
                "data":"",
                "codename":"Item_31",
                value: "31",
                
                disabled: false,
            },
            {
                id: "32",
                label: "已取消(超时)",
                text: "已取消(超时)",
                "data":"",
                "codename":"Item_32",
                value: "32",
                
                disabled: false,
            },
            {
                id: "4",
                label: "处理故障",
                text: "处理故障",
                "data":"",
                "codename":"Item_4",
                value: "4",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMTIRESNEWOLD",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "新",
                text: "新",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "挂",
                text: "挂",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMPRIORITY",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "1",
                label: "低",
                text: "低",
                "data":"",
                "codename":"Item_1",
                value: "1",
                
                disabled: false,
            },
            {
                id: "2",
                label: "中",
                text: "中",
                "data":"",
                "codename":"Item_2",
                value: "2",
                
                disabled: false,
            },
            {
                id: "3",
                label: "高",
                text: "高",
                "data":"",
                "codename":"Item_3",
                value: "3",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "Sap_cbzx01",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "23D8010601",
                label: "宁波港-党群部",
                text: "宁波港-党群部",
                "data":"",
                "codename":"Item_1",
                value: "23D8010601",
                
                disabled: false,
            },
            {
                id: "23D8010401",
                label: "宁波港-商务部",
                text: "宁波港-商务部",
                "data":"",
                "codename":"Item_2",
                value: "23D8010401",
                
                disabled: false,
            },
            {
                id: "23D8020301",
                label: "宁波港-安监部",
                text: "宁波港-安监部",
                "data":"",
                "codename":"Item_3",
                value: "23D8020301",
                
                disabled: false,
            },
            {
                id: "23D8010501",
                label: "宁波港-市场部",
                text: "宁波港-市场部",
                "data":"",
                "codename":"Item_4",
                value: "23D8010501",
                
                disabled: false,
            },
            {
                id: "23D8010101",
                label: "宁波港-管理层",
                text: "宁波港-管理层",
                "data":"",
                "codename":"Item_5",
                value: "23D8010101",
                
                disabled: false,
            },
            {
                id: "23D8010201",
                label: "宁波港-综合管理部",
                text: "宁波港-综合管理部",
                "data":"",
                "codename":"Item_6",
                value: "23D8010201",
                
                disabled: false,
            },
            {
                id: "23D8010301",
                label: "宁波港-计划财务部",
                text: "宁波港-计划财务部",
                "data":"",
                "codename":"Item_7",
                value: "23D8010301",
                
                disabled: false,
            },
            {
                id: "23D8010701",
                label: "宁波港-采购部",
                text: "宁波港-采购部",
                "data":"",
                "codename":"Item_8",
                value: "23D8010701",
                
                disabled: false,
            },
            {
                id: "23D8020101",
                label: "宁波港-技术管理部",
                text: "宁波港-技术管理部",
                "data":"",
                "codename":"Item_9",
                value: "23D8020101",
                
                disabled: false,
            },
            {
                id: "23D8020201",
                label: "宁波港-操作部",
                text: "宁波港-操作部",
                "data":"",
                "codename":"Item_10",
                value: "23D8020201",
                
                disabled: false,
            },
            {
                id: "23D8110999",
                label: "宁波港-公共管理类-集装箱接收分",
                text: "宁波港-公共管理类-集装箱接收分",
                "data":"",
                "codename":"Item_11",
                value: "23D8110999",
                
                disabled: false,
            },
            {
                id: "23D8120101",
                label: "宁波港-集装箱-技术管理部",
                text: "宁波港-集装箱-技术管理部",
                "data":"",
                "codename":"Item_12",
                value: "23D8120101",
                
                disabled: false,
            },
            {
                id: "23D8120201",
                label: "宁波港-集装箱-操作部",
                text: "宁波港-集装箱-操作部",
                "data":"",
                "codename":"Item_13",
                value: "23D8120201",
                
                disabled: false,
            },
            {
                id: "23D8120301",
                label: "宁波港-集装箱-安监部",
                text: "宁波港-集装箱-安监部",
                "data":"",
                "codename":"Item_14",
                value: "23D8120301",
                
                disabled: false,
            },
            {
                id: "23D8130101",
                label: "宁波港-集装箱-1号桥吊",
                text: "宁波港-集装箱-1号桥吊",
                "data":"",
                "codename":"Item_15",
                value: "23D8130101",
                
                disabled: false,
            },
            {
                id: "23D8130104",
                label: "宁波港-集装箱-4号桥吊",
                text: "宁波港-集装箱-4号桥吊",
                "data":"",
                "codename":"Item_16",
                value: "23D8130104",
                
                disabled: false,
            },
            {
                id: "23D8130105",
                label: "宁波港-集装箱-5号桥吊",
                text: "宁波港-集装箱-5号桥吊",
                "data":"",
                "codename":"Item_17",
                value: "23D8130105",
                
                disabled: false,
            },
            {
                id: "23D8130106",
                label: "宁波港-集装箱-6号桥吊",
                text: "宁波港-集装箱-6号桥吊",
                "data":"",
                "codename":"Item_18",
                value: "23D8130106",
                
                disabled: false,
            },
            {
                id: "23D8130107",
                label: "宁波港-集装箱-7号桥吊",
                text: "宁波港-集装箱-7号桥吊",
                "data":"",
                "codename":"Item_19",
                value: "23D8130107",
                
                disabled: false,
            },
            {
                id: "23D8130108",
                label: "宁波港-集装箱-8号桥吊",
                text: "宁波港-集装箱-8号桥吊",
                "data":"",
                "codename":"Item_20",
                value: "23D8130108",
                
                disabled: false,
            },
            {
                id: "23D8130109",
                label: "宁波港-集装箱-9号桥吊",
                text: "宁波港-集装箱-9号桥吊",
                "data":"",
                "codename":"Item_21",
                value: "23D8130109",
                
                disabled: false,
            },
            {
                id: "23D8130110",
                label: "宁波港-集装箱-10号桥吊",
                text: "宁波港-集装箱-10号桥吊",
                "data":"",
                "codename":"Item_22",
                value: "23D8130110",
                
                disabled: false,
            },
            {
                id: "23D8130111",
                label: "宁波港-集装箱-11号桥吊",
                text: "宁波港-集装箱-11号桥吊",
                "data":"",
                "codename":"Item_23",
                value: "23D8130111",
                
                disabled: false,
            },
            {
                id: "23D8130112",
                label: "宁波港-集装箱-12号桥吊",
                text: "宁波港-集装箱-12号桥吊",
                "data":"",
                "codename":"Item_24",
                value: "23D8130112",
                
                disabled: false,
            },
            {
                id: "23D8130115",
                label: "宁波港-集装箱-15号桥吊",
                text: "宁波港-集装箱-15号桥吊",
                "data":"",
                "codename":"Item_25",
                value: "23D8130115",
                
                disabled: false,
            },
            {
                id: "23D8130116",
                label: "宁波港-集装箱-16号桥吊",
                text: "宁波港-集装箱-16号桥吊",
                "data":"",
                "codename":"Item_26",
                value: "23D8130116",
                
                disabled: false,
            },
            {
                id: "23D8130117",
                label: "宁波港-集装箱-17号桥吊",
                text: "宁波港-集装箱-17号桥吊",
                "data":"",
                "codename":"Item_27",
                value: "23D8130117",
                
                disabled: false,
            },
            {
                id: "23D8130206",
                label: "宁波港-集装箱-6号YGD-JP",
                text: "宁波港-集装箱-6号YGD-JP",
                "data":"",
                "codename":"Item_28",
                value: "23D8130206",
                
                disabled: false,
            },
            {
                id: "23D8130207",
                label: "宁波港-集装箱-7号YGD-JP",
                text: "宁波港-集装箱-7号YGD-JP",
                "data":"",
                "codename":"Item_29",
                value: "23D8130207",
                
                disabled: false,
            },
            {
                id: "23D8130208",
                label: "宁波港-集装箱-8号YGD-JP",
                text: "宁波港-集装箱-8号YGD-JP",
                "data":"",
                "codename":"Item_30",
                value: "23D8130208",
                
                disabled: false,
            },
            {
                id: "23D8130209",
                label: "宁波港-集装箱-9号YGD-JP",
                text: "宁波港-集装箱-9号YGD-JP",
                "data":"",
                "codename":"Item_31",
                value: "23D8130209",
                
                disabled: false,
            },
            {
                id: "23D8130210",
                label: "宁波港-集装箱-10号YGD-J",
                text: "宁波港-集装箱-10号YGD-J",
                "data":"",
                "codename":"Item_32",
                value: "23D8130210",
                
                disabled: false,
            },
            {
                id: "23D8130211",
                label: "宁波港-集装箱-11号CYJ",
                text: "宁波港-集装箱-11号CYJ",
                "data":"",
                "codename":"Item_33",
                value: "23D8130211",
                
                disabled: false,
            },
            {
                id: "23D8130212",
                label: "宁波港-集装箱-12号YGD-J",
                text: "宁波港-集装箱-12号YGD-J",
                "data":"",
                "codename":"Item_34",
                value: "23D8130212",
                
                disabled: false,
            },
            {
                id: "23D8130213",
                label: "宁波港-集装箱-13号YGD-H",
                text: "宁波港-集装箱-13号YGD-H",
                "data":"",
                "codename":"Item_35",
                value: "23D8130213",
                
                disabled: false,
            },
            {
                id: "23D8130214",
                label: "宁波港-集装箱-14号YGD-H",
                text: "宁波港-集装箱-14号YGD-H",
                "data":"",
                "codename":"Item_36",
                value: "23D8130214",
                
                disabled: false,
            },
            {
                id: "23D8130215",
                label: "宁波港-集装箱-15号YGD-J",
                text: "宁波港-集装箱-15号YGD-J",
                "data":"",
                "codename":"Item_37",
                value: "23D8130215",
                
                disabled: false,
            },
            {
                id: "23D8130216",
                label: "宁波港-集装箱-16号CYJ",
                text: "宁波港-集装箱-16号CYJ",
                "data":"",
                "codename":"Item_38",
                value: "23D8130216",
                
                disabled: false,
            },
            {
                id: "23D8130217",
                label: "宁波港-集装箱-17号YGD-H",
                text: "宁波港-集装箱-17号YGD-H",
                "data":"",
                "codename":"Item_39",
                value: "23D8130217",
                
                disabled: false,
            },
            {
                id: "23D8130218",
                label: "宁波港-集装箱-18号YGD-H",
                text: "宁波港-集装箱-18号YGD-H",
                "data":"",
                "codename":"Item_40",
                value: "23D8130218",
                
                disabled: false,
            },
            {
                id: "23D8130219",
                label: "宁波港-集装箱-19号YGD-J",
                text: "宁波港-集装箱-19号YGD-J",
                "data":"",
                "codename":"Item_41",
                value: "23D8130219",
                
                disabled: false,
            },
            {
                id: "23D8130220",
                label: "宁波港-集装箱-20号YGD-J",
                text: "宁波港-集装箱-20号YGD-J",
                "data":"",
                "codename":"Item_42",
                value: "23D8130220",
                
                disabled: false,
            },
            {
                id: "23D8130221",
                label: "宁波港-集装箱-21号CYJ",
                text: "宁波港-集装箱-21号CYJ",
                "data":"",
                "codename":"Item_43",
                value: "23D8130221",
                
                disabled: false,
            },
            {
                id: "23D8130222",
                label: "宁波港-集装箱-22号YGD-H",
                text: "宁波港-集装箱-22号YGD-H",
                "data":"",
                "codename":"Item_44",
                value: "23D8130222",
                
                disabled: false,
            },
            {
                id: "23D8130223",
                label: "宁波港-集装箱-23号YGD-H",
                text: "宁波港-集装箱-23号YGD-H",
                "data":"",
                "codename":"Item_45",
                value: "23D8130223",
                
                disabled: false,
            },
            {
                id: "23D8130224",
                label: "宁波港-集装箱-24号YGD-H",
                text: "宁波港-集装箱-24号YGD-H",
                "data":"",
                "codename":"Item_46",
                value: "23D8130224",
                
                disabled: false,
            },
            {
                id: "23D8130225",
                label: "宁波港-集装箱-25号YGD-H",
                text: "宁波港-集装箱-25号YGD-H",
                "data":"",
                "codename":"Item_47",
                value: "23D8130225",
                
                disabled: false,
            },
            {
                id: "23D8130226",
                label: "宁波港-集装箱-26号CYJ",
                text: "宁波港-集装箱-26号CYJ",
                "data":"",
                "codename":"Item_48",
                value: "23D8130226",
                
                disabled: false,
            },
            {
                id: "23D8130227",
                label: "宁波港-集装箱-27号YGD-J",
                text: "宁波港-集装箱-27号YGD-J",
                "data":"",
                "codename":"Item_49",
                value: "23D8130227",
                
                disabled: false,
            },
            {
                id: "23D8130228",
                label: "宁波港-集装箱-28号YGD-H",
                text: "宁波港-集装箱-28号YGD-H",
                "data":"",
                "codename":"Item_50",
                value: "23D8130228",
                
                disabled: false,
            },
            {
                id: "23D8130229",
                label: "宁波港-集装箱-29号YGD-H",
                text: "宁波港-集装箱-29号YGD-H",
                "data":"",
                "codename":"Item_51",
                value: "23D8130229",
                
                disabled: false,
            },
            {
                id: "23D8130999",
                label: "宁波港-集装箱-其他机械设备",
                text: "宁波港-集装箱-其他机械设备",
                "data":"",
                "codename":"Item_52",
                value: "23D8130999",
                
                disabled: false,
            },
            {
                id: "23D8210999",
                label: "宁波港-公共管理类-散杂货接收分",
                text: "宁波港-公共管理类-散杂货接收分",
                "data":"",
                "codename":"Item_53",
                value: "23D8210999",
                
                disabled: false,
            },
            {
                id: "23D8220101",
                label: "宁波港-散杂货-技术管理部",
                text: "宁波港-散杂货-技术管理部",
                "data":"",
                "codename":"Item_54",
                value: "23D8220101",
                
                disabled: false,
            },
            {
                id: "23D8220201",
                label: "宁波港-散杂货-操作部",
                text: "宁波港-散杂货-操作部",
                "data":"",
                "codename":"Item_55",
                value: "23D8220201",
                
                disabled: false,
            },
            {
                id: "23D8220301",
                label: "宁波港-散杂货-安监部",
                text: "宁波港-散杂货-安监部",
                "data":"",
                "codename":"Item_56",
                value: "23D8220301",
                
                disabled: false,
            },
            {
                id: "23D8230101",
                label: "宁波港-散杂货-1号桥吊",
                text: "宁波港-散杂货-1号桥吊",
                "data":"",
                "codename":"Item_57",
                value: "23D8230101",
                
                disabled: false,
            },
            {
                id: "23D8230104",
                label: "宁波港-散杂货-4号桥吊",
                text: "宁波港-散杂货-4号桥吊",
                "data":"",
                "codename":"Item_58",
                value: "23D8230104",
                
                disabled: false,
            },
            {
                id: "23D8230105",
                label: "宁波港-散杂货-5号桥吊",
                text: "宁波港-散杂货-5号桥吊",
                "data":"",
                "codename":"Item_59",
                value: "23D8230105",
                
                disabled: false,
            },
            {
                id: "23D8230106",
                label: "宁波港-散杂货-6号桥吊",
                text: "宁波港-散杂货-6号桥吊",
                "data":"",
                "codename":"Item_60",
                value: "23D8230106",
                
                disabled: false,
            },
            {
                id: "23D8230107",
                label: "宁波港-散杂货-7号桥吊",
                text: "宁波港-散杂货-7号桥吊",
                "data":"",
                "codename":"Item_61",
                value: "23D8230107",
                
                disabled: false,
            },
            {
                id: "23D8230108",
                label: "宁波港-散杂货-8号桥吊",
                text: "宁波港-散杂货-8号桥吊",
                "data":"",
                "codename":"Item_62",
                value: "23D8230108",
                
                disabled: false,
            },
            {
                id: "23D8230109",
                label: "宁波港-散杂货-9号桥吊",
                text: "宁波港-散杂货-9号桥吊",
                "data":"",
                "codename":"Item_63",
                value: "23D8230109",
                
                disabled: false,
            },
            {
                id: "23D8230110",
                label: "宁波港-散杂货-10号桥吊",
                text: "宁波港-散杂货-10号桥吊",
                "data":"",
                "codename":"Item_64",
                value: "23D8230110",
                
                disabled: false,
            },
            {
                id: "23D8230111",
                label: "宁波港-散杂货-11号桥吊",
                text: "宁波港-散杂货-11号桥吊",
                "data":"",
                "codename":"Item_65",
                value: "23D8230111",
                
                disabled: false,
            },
            {
                id: "23D8230112",
                label: "宁波港-散杂货-12号桥吊",
                text: "宁波港-散杂货-12号桥吊",
                "data":"",
                "codename":"Item_66",
                value: "23D8230112",
                
                disabled: false,
            },
            {
                id: "23D8230115",
                label: "宁波港-散杂货-15号桥吊",
                text: "宁波港-散杂货-15号桥吊",
                "data":"",
                "codename":"Item_67",
                value: "23D8230115",
                
                disabled: false,
            },
            {
                id: "23D8230116",
                label: "宁波港-散杂货-16号桥吊",
                text: "宁波港-散杂货-16号桥吊",
                "data":"",
                "codename":"Item_68",
                value: "23D8230116",
                
                disabled: false,
            },
            {
                id: "23D8230117",
                label: "宁波港-散杂货-17号桥吊",
                text: "宁波港-散杂货-17号桥吊",
                "data":"",
                "codename":"Item_69",
                value: "23D8230117",
                
                disabled: false,
            },
            {
                id: "23D8230206",
                label: "宁波港-散杂货-6号YGD-JP",
                text: "宁波港-散杂货-6号YGD-JP",
                "data":"",
                "codename":"Item_70",
                value: "23D8230206",
                
                disabled: false,
            },
            {
                id: "23D8230207",
                label: "宁波港-散杂货-7号YGD-JP",
                text: "宁波港-散杂货-7号YGD-JP",
                "data":"",
                "codename":"Item_71",
                value: "23D8230207",
                
                disabled: false,
            },
            {
                id: "23D8230208",
                label: "宁波港-散杂货-8号YGD-JP",
                text: "宁波港-散杂货-8号YGD-JP",
                "data":"",
                "codename":"Item_72",
                value: "23D8230208",
                
                disabled: false,
            },
            {
                id: "23D8230209",
                label: "宁波港-散杂货-9号YGD-JP",
                text: "宁波港-散杂货-9号YGD-JP",
                "data":"",
                "codename":"Item_73",
                value: "23D8230209",
                
                disabled: false,
            },
            {
                id: "23D8230210",
                label: "宁波港-散杂货-10号YGD-J",
                text: "宁波港-散杂货-10号YGD-J",
                "data":"",
                "codename":"Item_74",
                value: "23D8230210",
                
                disabled: false,
            },
            {
                id: "23D8230211",
                label: "宁波港-散杂货-11号CYJ",
                text: "宁波港-散杂货-11号CYJ",
                "data":"",
                "codename":"Item_75",
                value: "23D8230211",
                
                disabled: false,
            },
            {
                id: "23D8230212",
                label: "宁波港-散杂货-12号YGD-J",
                text: "宁波港-散杂货-12号YGD-J",
                "data":"",
                "codename":"Item_76",
                value: "23D8230212",
                
                disabled: false,
            },
            {
                id: "23D8230213",
                label: "宁波港-散杂货-13号YGD-H",
                text: "宁波港-散杂货-13号YGD-H",
                "data":"",
                "codename":"Item_77",
                value: "23D8230213",
                
                disabled: false,
            },
            {
                id: "23D8230214",
                label: "宁波港-散杂货-14号YGD-H",
                text: "宁波港-散杂货-14号YGD-H",
                "data":"",
                "codename":"Item_78",
                value: "23D8230214",
                
                disabled: false,
            },
            {
                id: "23D8230215",
                label: "宁波港-散杂货-15号YGD-J",
                text: "宁波港-散杂货-15号YGD-J",
                "data":"",
                "codename":"Item_79",
                value: "23D8230215",
                
                disabled: false,
            },
            {
                id: "23D8230216",
                label: "宁波港-散杂货-16号CYJ",
                text: "宁波港-散杂货-16号CYJ",
                "data":"",
                "codename":"Item_80",
                value: "23D8230216",
                
                disabled: false,
            },
            {
                id: "23D8230217",
                label: "宁波港-散杂货-17号YGD-H",
                text: "宁波港-散杂货-17号YGD-H",
                "data":"",
                "codename":"Item_81",
                value: "23D8230217",
                
                disabled: false,
            },
            {
                id: "23D8230218",
                label: "宁波港-散杂货-18号YGD-H",
                text: "宁波港-散杂货-18号YGD-H",
                "data":"",
                "codename":"Item_82",
                value: "23D8230218",
                
                disabled: false,
            },
            {
                id: "23D8230219",
                label: "宁波港-散杂货-19号YGD-J",
                text: "宁波港-散杂货-19号YGD-J",
                "data":"",
                "codename":"Item_83",
                value: "23D8230219",
                
                disabled: false,
            },
            {
                id: "23D8230220",
                label: "宁波港-散杂货-20号YGD-J",
                text: "宁波港-散杂货-20号YGD-J",
                "data":"",
                "codename":"Item_84",
                value: "23D8230220",
                
                disabled: false,
            },
            {
                id: "23D8230221",
                label: "宁波港-散杂货-21号CYJ",
                text: "宁波港-散杂货-21号CYJ",
                "data":"",
                "codename":"Item_85",
                value: "23D8230221",
                
                disabled: false,
            },
            {
                id: "23D8230222",
                label: "宁波港-散杂货-22号YGD-H",
                text: "宁波港-散杂货-22号YGD-H",
                "data":"",
                "codename":"Item_86",
                value: "23D8230222",
                
                disabled: false,
            },
            {
                id: "23D8230223",
                label: "宁波港-散杂货-23号YGD-H",
                text: "宁波港-散杂货-23号YGD-H",
                "data":"",
                "codename":"Item_87",
                value: "23D8230223",
                
                disabled: false,
            },
            {
                id: "23D8230224",
                label: "宁波港-散杂货-24号YGD-H",
                text: "宁波港-散杂货-24号YGD-H",
                "data":"",
                "codename":"Item_88",
                value: "23D8230224",
                
                disabled: false,
            },
            {
                id: "23D8230225",
                label: "宁波港-散杂货-25号YGD-H",
                text: "宁波港-散杂货-25号YGD-H",
                "data":"",
                "codename":"Item_89",
                value: "23D8230225",
                
                disabled: false,
            },
            {
                id: "23D8230226",
                label: "宁波港-散杂货-26号CYJ",
                text: "宁波港-散杂货-26号CYJ",
                "data":"",
                "codename":"Item_90",
                value: "23D8230226",
                
                disabled: false,
            },
            {
                id: "23D8230227",
                label: "宁波港-散杂货-27号YGD-J",
                text: "宁波港-散杂货-27号YGD-J",
                "data":"",
                "codename":"Item_91",
                value: "23D8230227",
                
                disabled: false,
            },
            {
                id: "23D8230228",
                label: "宁波港-散杂货-28号YGD-H",
                text: "宁波港-散杂货-28号YGD-H",
                "data":"",
                "codename":"Item_92",
                value: "23D8230228",
                
                disabled: false,
            },
            {
                id: "23D8230229",
                label: "宁波港-散杂货-29号YGD-H",
                text: "宁波港-散杂货-29号YGD-H",
                "data":"",
                "codename":"Item_93",
                value: "23D8230229",
                
                disabled: false,
            },
            {
                id: "23D8230999",
                label: "宁波港-散杂货-其他机械设备",
                text: "宁波港-散杂货-其他机械设备",
                "data":"",
                "codename":"Item_94",
                value: "23D8230999",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "HALTTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "JHTJ",
                label: "计划停机",
                text: "计划停机",
                "data":"",
                "codename":"Jhtj",
                value: "JHTJ",
                
                disabled: false,
            },
            {
                id: "QXTJ",
                label: "抢修停机",
                text: "抢修停机",
                "data":"",
                "codename":"Qxtj",
                value: "QXTJ",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMCONTRACTTYPEID",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "TDZY",
                label: "土地征用",
                text: "土地征用",
                "data":"",
                "codename":"Tdzy",
                value: "TDZY",
                
                disabled: false,
            },
            {
                id: "QT",
                label: "其它",
                text: "其它",
                "data":"",
                "codename":"Qt",
                value: "QT",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMAHGROUP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "SETUP",
                label: "更换安装",
                text: "更换安装",
                "data":"",
                "codename":"Setup",
                value: "SETUP",
                
                disabled: false,
            },
            {
                id: "DEBUG",
                label: "事故",
                text: "事故",
                "data":"",
                "codename":"Debug",
                value: "DEBUG",
                
                disabled: false,
            },
            {
                id: "KEEP",
                label: "维护保养",
                text: "维护保养",
                "data":"",
                "codename":"Keep",
                value: "KEEP",
                
                disabled: false,
            },
            {
                id: "CHECK",
                label: "维修",
                text: "维修",
                "data":"",
                "codename":"Check",
                value: "CHECK",
                
                disabled: false,
            },
            {
                id: "MAINTANCE",
                label: "抢修",
                text: "抢修",
                "data":"",
                "codename":"Maintance",
                value: "MAINTANCE",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMTRADETYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "RIN",
                label: "入库单",
                text: "入库单",
                "data":"",
                "codename":"Rin",
                value: "RIN",
                
                disabled: false,
            },
            {
                id: "ROUT",
                label: "退货单",
                text: "退货单",
                "data":"",
                "codename":"Rout",
                value: "ROUT",
                
                disabled: false,
            },
            {
                id: "PUSE",
                label: "领料单",
                text: "领料单",
                "data":"",
                "codename":"Puse",
                value: "PUSE",
                
                disabled: false,
            },
            {
                id: "PRTN",
                label: "还料单",
                text: "还料单",
                "data":"",
                "codename":"Prtn",
                value: "PRTN",
                
                disabled: false,
            },
            {
                id: "PL",
                label: "损溢单",
                text: "损溢单",
                "data":"",
                "codename":"Pl",
                value: "PL",
                
                disabled: false,
            },
            {
                id: "CS",
                label: "库间调整",
                text: "库间调整",
                "data":"",
                "codename":"Cs",
                value: "CS",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMAPPLYTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "ERROR",
                label: "故障汇报",
                text: "故障汇报",
                "data":"",
                "codename":"Error",
                value: "ERROR",
                
                disabled: false,
            },
            {
                id: "WAPPLY",
                label: "工作申请",
                text: "工作申请",
                "data":"",
                "codename":"Wapply",
                value: "WAPPLY",
                
                disabled: false,
            },
            {
                id: "OSC",
                label: "外委申请",
                text: "外委申请",
                "data":"",
                "codename":"Osc",
                value: "OSC",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMWOKIND",
        emptytext: "其它",
        "codelisttype":"static",
        items: [
            {
                id: "INNER",
                label: "常规内部工单",
                text: "常规内部工单",
                "data":"",
                "codename":"Inner",
                value: "INNER",
                
                disabled: false,
            },
            {
                id: "OSC",
                label: "外委工单",
                text: "外委工单",
                "data":"",
                "codename":"Osc",
                value: "OSC",
                
                disabled: false,
            },
            {
                id: "DP",
                label: "点检工单",
                text: "点检工单",
                "data":"",
                "codename":"Dp",
                value: "DP",
                
                disabled: false,
            },
            {
                id: "EN",
                label: "能耗登记工单",
                text: "能耗登记工单",
                "data":"",
                "codename":"En",
                value: "EN",
                
                disabled: false,
            },
            {
                id: "PT",
                label: "生产执勤工单",
                text: "生产执勤工单",
                "data":"",
                "codename":"Pt",
                value: "PT",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMWOTYPE",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "KEEP",
                label: "保养工单",
                text: "保养工单",
                "data":"",
                "codename":"Keep",
                value: "KEEP",
                
                disabled: false,
            },
            {
                id: "KEEP1",
                label: ".  一级保养",
                text: ".  一级保养",
                "data":"",
                "codename":"Keep1",
                value: "KEEP1",
                
                disabled: false,
            },
            {
                id: "KEEP2",
                label: ".  润滑检查",
                text: ".  润滑检查",
                "data":"",
                "codename":"Keep2",
                value: "KEEP2",
                
                disabled: false,
            },
            {
                id: "KEEP3",
                label: ".  卫生维护",
                text: ".  卫生维护",
                "data":"",
                "codename":"Keep3",
                value: "KEEP3",
                
                disabled: false,
            },
            {
                id: "ERROR",
                label: "故障工单",
                text: "故障工单",
                "data":"",
                "codename":"Error",
                value: "ERROR",
                
                disabled: false,
            },
            {
                id: "ERROR1",
                label: "事故工单",
                text: "事故工单",
                "data":"",
                "codename":"Error1",
                value: "ERROR1",
                
                disabled: false,
            },
            {
                id: "CHECK",
                label: "检修工单",
                text: "检修工单",
                "data":"",
                "codename":"Check",
                value: "CHECK",
                
                disabled: false,
            },
            {
                id: "CHECKM",
                label: "月度检修",
                text: "月度检修",
                "data":"",
                "codename":"Checkm",
                value: "CHECKM",
                
                disabled: false,
            },
            {
                id: "CHECKY",
                label: "年度检修",
                text: "年度检修",
                "data":"",
                "codename":"Checky",
                value: "CHECKY",
                
                disabled: false,
            },
            {
                id: "PT",
                label: "作业工单",
                text: "作业工单",
                "data":"",
                "codename":"Pt",
                value: "PT",
                
                disabled: false,
            },
            {
                id: "EN",
                label: "能耗登记",
                text: "能耗登记",
                "data":"",
                "codename":"En",
                value: "EN",
                
                disabled: false,
            },
            {
                id: "DP",
                label: "点检",
                text: "点检",
                "data":"",
                "codename":"Dp",
                value: "DP",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EMWPLISTWFSTEP",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "15",
                label: "补充件号中",
                text: "补充件号中",
                "data":"",
                "codename":"Item_15",
                value: "15",
                
                disabled: false,
            },
            {
                id: "8",
                label: "综管部初审",
                text: "综管部初审",
                "data":"",
                "codename":"Item_8",
                value: "8",
                
                disabled: false,
            },
            {
                id: "11",
                label: "电脑部审核",
                text: "电脑部审核",
                "data":"",
                "codename":"Item_11",
                value: "11",
                
                disabled: false,
            },
            {
                id: "12",
                label: "安监部审核",
                text: "安监部审核",
                "data":"",
                "codename":"Item_12",
                value: "12",
                
                disabled: false,
            },
            {
                id: "13",
                label: "综管部审核",
                text: "综管部审核",
                "data":"",
                "codename":"Item_13",
                value: "13",
                
                disabled: false,
            },
            {
                id: "20",
                label: "待部门经理审核",
                text: "待部门经理审核",
                "data":"",
                "codename":"Item_20",
                value: "20",
                
                disabled: false,
            },
            {
                id: "25",
                label: "待部门分管副总审核",
                text: "待部门分管副总审核",
                "data":"",
                "codename":"Item_25",
                value: "25",
                
                disabled: false,
            },
            {
                id: "30",
                label: "待指派采购员",
                text: "待指派采购员",
                "data":"",
                "codename":"Item_30",
                value: "30",
                
                disabled: false,
            },
            {
                id: "40",
                label: "采购处理中",
                text: "采购处理中",
                "data":"",
                "codename":"Item_40",
                value: "40",
                
                disabled: false,
            },
            {
                id: "50",
                label: "待确认询价",
                text: "待确认询价",
                "data":"",
                "codename":"Item_50",
                value: "50",
                
                disabled: false,
            },
            {
                id: "60",
                label: "待生成订单",
                text: "待生成订单",
                "data":"",
                "codename":"Item_60",
                value: "60",
                
                disabled: false,
            },
            {
                id: "70",
                label: "审核不通过",
                text: "审核不通过",
                "data":"",
                "codename":"Item_70",
                value: "70",
                
                disabled: false,
            },
        ]
    },
    {
        srfkey: "EVLItem",
        emptytext: "未定义",
        "codelisttype":"static",
        items: [
            {
                id: "资质",
                label: "资质",
                text: "资质",
                "data":"",
                "codename":"Item_1",
                value: "资质",
                
                disabled: false,
            },
            {
                id: "质量",
                label: "质量",
                text: "质量",
                "data":"",
                "codename":"Item_2",
                value: "质量",
                
                disabled: false,
            },
            {
                id: "价格",
                label: "价格",
                text: "价格",
                "data":"",
                "codename":"Item_3",
                value: "价格",
                
                disabled: false,
            },
            {
                id: "安全性能",
                label: "安全性能",
                text: "安全性能",
                "data":"",
                "codename":"Item_4",
                value: "安全性能",
                
                disabled: false,
            },
            {
                id: "供货能力",
                label: "供货能力",
                text: "供货能力",
                "data":"",
                "codename":"Item_5",
                value: "供货能力",
                
                disabled: false,
            },
            {
                id: "及时性",
                label: "及时性",
                text: "及时性",
                "data":"",
                "codename":"Item_6",
                value: "及时性",
                
                disabled: false,
            },
            {
                id: "距离",
                label: "距离",
                text: "距离",
                "data":"",
                "codename":"Item_7",
                value: "距离",
                
                disabled: false,
            },
            {
                id: "质量管理体系",
                label: "质量管理体系",
                text: "质量管理体系",
                "data":"",
                "codename":"Item_8",
                value: "质量管理体系",
                
                disabled: false,
            },
            {
                id: "售后",
                label: "售后",
                text: "售后",
                "data":"",
                "codename":"Item_9",
                value: "售后",
                
                disabled: false,
            },
        ]
    }
    ]];
});

