import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
];


//getwflink
mock.onGet(new RegExp(/^\/wfcore\/eam-app-eamweb\/empodetails\/[a-zA-Z0-9\-\;]+\/usertasks\/[a-zA-Z0-9\-\;]+\/ways$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: getwflink");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status,[
        {"sequenceFlowId":"dfdsfdsfdsfdsfds","sequenceFlowName":"同意",
         "taskId":"aaaaddddccccddddd","processDefinitionKey":"support-workorders-approve-v1",
         "processInstanceId":"ddlfldldfldsfds","refViewKey":""},
        {"sequenceFlowId":"ddssdfdfdfdfsfdf","sequenceFlowName":"不同意",
         "taskId":"aaaaddddccccddddd","processDefinitionKey":"support-workorders-approve-v1",
         "processInstanceId":"ddfdsldlfdlldsf","refViewKey":"workorder_ltform_editview"}
        ]];
});

// getwfstep
mock.onGet(new RegExp(/^\/wfcore\/eam-app-eamweb\/empodetails\/process-definitions-nodes$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: getwfstep");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, [
        {"userTaskId":"sddfddfd-dfdf-fdfd-fdf-dfdfd",
        "userTaskName":"待审",
        "cnt":0,
        "processDefinitionKey":"support-workorders-approve-v1",
        "processDefinitionName":"工单审批流程v1"
        },
        {"userTaskId":"sddfddfd-dfdf-fdfd-fdf-87927",
        "userTaskName":"待分配",
        "cnt":3,
        "processDefinitionKey":"support-workorders-approve-v1",
        "processDefinitionName":"工单审批流程v1"}
        ]];
});

// createBatch
mock.onPost(new RegExp(/^\/empodetails\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: createBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});

// updateBatch
mock.onPut(new RegExp(/^\/empodetails\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: updateBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});

// removeBatch
mock.onDelete(new RegExp(/^\/empodetails\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: removeBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});



// Select
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});


// Select
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});

// Select
mock.onGet(new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});

    
// Create
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Create
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// Create
mock.onPost(new RegExp(/^\/empodetails\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas[0]);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas[0]];
});

    
// Update
mock.onPut(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Update
mock.onPut(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// Update
mock.onPut(new RegExp(/^\/empodetails\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['empodetailid'] == tempValue['empodetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});


























// GetDraft
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});


// GetDraft
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

// GetDraft
mock.onGet(new RegExp(/^\/empodetails\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Check
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// Check
mock.onPost(new RegExp(/^\/empodetails\/?([a-zA-Z0-9\-\;]{0,35})\/check$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Check");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/check$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['empodetailid'] == tempValue['empodetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CheckKey
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// CheckKey
mock.onPost(new RegExp(/^\/empodetails\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['empodetailid'] == tempValue['empodetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// CreateRin
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// CreateRin
mock.onPost(new RegExp(/^\/empodetails\/?([a-zA-Z0-9\-\;]{0,35})\/createrin$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: CreateRin");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/createrin$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['empodetailid'] == tempValue['empodetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});

    
// GenId
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// GenId
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// GenId
mock.onPost(new RegExp(/^\/empodetails\/?([a-zA-Z0-9\-\;]{0,35})\/genid$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: GenId");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/genid$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['empodetailid'] == tempValue['empodetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});

    
// Save
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

    
// Save
mock.onPost(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// Save
mock.onPost(new RegExp(/^\/empodetails\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['empodetailid'] == tempValue['empodetailid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchClosed
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchclosed$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});
    
// FetchClosed
mock.onGet(new RegExp(/^\/empodetails\/fetchclosed$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchClosed
mock.onGet(new RegExp(/^\/empodetails\/fetchclosed(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchClosed");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchDefault
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchdefault$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});
    
// FetchDefault
mock.onGet(new RegExp(/^\/empodetails\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchDefault
mock.onGet(new RegExp(/^\/empodetails\/fetchdefault(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchLaterYear
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchlateryear$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});
    
// FetchLaterYear
mock.onGet(new RegExp(/^\/empodetails\/fetchlateryear$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchLaterYear
mock.onGet(new RegExp(/^\/empodetails\/fetchlateryear(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchLaterYear");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitBook
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitbook$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});
    
// FetchWaitBook
mock.onGet(new RegExp(/^\/empodetails\/fetchwaitbook$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchWaitBook
mock.onGet(new RegExp(/^\/empodetails\/fetchwaitbook(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitBook");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid','emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstoreid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emstorepartid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emserviceid','emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emwplistid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['empoid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});


// FetchWaitCheck
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    const paramArray:Array<any> = ['emitemid'];
    let tempValue: any = {};
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/fetchwaitcheck$/).exec(config.url);
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    if (items.length > 0 && paramArray.length > 0) {
        paramArray.forEach((paramkey: any) => {
            if (tempValue[paramkey] && tempValue[paramkey].indexOf(";") > 0) {
                let keysGrounp: Array<any> = tempValue[paramkey].split(new RegExp(/[\;]/));
                let tempArray: Array<any> = [];
                keysGrounp.forEach((singlekey: any) => {
                    let _items =  items.filter((item: any) => { return item[paramkey] == singlekey });
                   if(_items.length >0){
                    tempArray.push(..._items);
                   }
                })
                items = tempArray;
            } else {
                items = items.filter((item: any) => { return item[paramkey] == tempValue[paramkey] });
            }
        })
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(items);
    console.groupEnd();
    console.groupEnd();
    return [status, items];
});
    
// FetchWaitCheck
mock.onGet(new RegExp(/^\/empodetails\/fetchwaitcheck$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchWaitCheck
mock.onGet(new RegExp(/^\/empodetails\/fetchwaitcheck(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: FetchWaitCheck");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
// URI参数传递情况未实现


// Remove
mock.onDelete(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Remove
mock.onDelete(new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstoreid','emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstoreid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstorepartid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emserviceid','emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emitemid','emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstoreid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstores\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emstorepartid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emstoreparts\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emserviceid','emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emservices\/([a-zA-Z0-9\-\;]{1,35})\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emwplistid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emwplists\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empoid','empodetailid'];
    const matchArray:any = new RegExp(/^\/empos\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['emitemid','empodetailid'];
    const matchArray:any = new RegExp(/^\/emitems\/([a-zA-Z0-9\-\;]{1,35})\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:empodetail 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['empodetailid'];
    const matchArray:any = new RegExp(/^\/empodetails\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.empodetailid, tempValue.empodetailid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});
