import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'

Vue.use(Router);

const router = new Router({
    routes: [
        {
            path: '/appindex/:appindex?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'appindex';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
            },
            meta: {  
                caption: 'app.views.appindex.title',
                info:'',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'appindex', parameterName: 'appindex' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/eam-core/app-index/app-index.vue'),
            children: [
                {
                    path: 'emservices/:emservice?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emservice.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emserviceedit-view9-edit-mode/emserviceedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emserviceevls/:emserviceevl?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emserviceevl.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emserviceevls', parameterName: 'emserviceevl' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emserviceevledit-view9/emserviceevledit-view9.vue'),
                },
                {
                    path: 'emserviceevls/:emserviceevl?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emserviceevl.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emserviceevls', parameterName: 'emserviceevl' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emserviceevledit-view9/emserviceevledit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/waitbookgridview/:waitbookgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitbookgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitbookgridview', parameterName: 'waitbookgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-book-grid-view/empodetail-wait-book-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'emplans/:emplan?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emplan.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-dashboard-view/emplan-dashboard-view.vue'),
                },
                {
                    path: 'emobjmaps/:emobjmap?/locationtreeview/:locationtreeview?',
                    meta: {
                        caption: 'entities.emobjmap.views.locationtreeview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emobjmaps', parameterName: 'emobjmap' },
                            { pathName: 'locationtreeview', parameterName: 'locationtreeview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emobj-map-location-tree-view/emobj-map-location-tree-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emserviceevls/:emserviceevl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emserviceevl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emserviceevls', parameterName: 'emserviceevl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emservice-evl-grid-view/emservice-evl-grid-view.vue'),
                },
                {
                    path: 'emserviceevls/:emserviceevl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emserviceevl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emserviceevls', parameterName: 'emserviceevl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emservice-evl-grid-view/emservice-evl-grid-view.vue'),
                },
                {
                    path: 'emeqlcttires/:emeqlcttires?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emeqlcttires.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlcttires', parameterName: 'emeqlcttires' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlcttirespickup-view/emeqlcttirespickup-view.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqspare.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqspare-edit-view/emeqspare-edit-view.vue'),
                },
                {
                    path: 'emeqkps/:emeqkp?/kpeditview/:kpeditview?',
                    meta: {
                        caption: 'entities.emeqkp.views.kpeditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqkps', parameterName: 'emeqkp' },
                            { pathName: 'kpeditview', parameterName: 'kpeditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqkpkpedit-view/emeqkpkpedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emen.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emengrid-view/emengrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emen/:emen?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emen.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emengrid-view/emengrid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emen.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emengrid-view/emengrid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emen/:emen?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emen.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emengrid-view/emengrid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emen/:emen?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emen.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emengrid-view/emengrid-view.vue'),
                },
                {
                    path: 'emen/:emen?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emen.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emengrid-view/emengrid-view.vue'),
                },
                {
                    path: 'emeitires/:emeitires?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emeitires.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeitires', parameterName: 'emeitires' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeitirespickup-view/emeitirespickup-view.vue'),
                },
                {
                    path: 'emitempls/:emitempl?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempl.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempls', parameterName: 'emitempl' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-pldraft-grid-view/emitem-pldraft-grid-view.vue'),
                },
                {
                    path: 'emeqkps/:emeqkp?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emeqkp.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqkps', parameterName: 'emeqkp' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqkppickup-grid-view/emeqkppickup-grid-view.vue'),
                },
                {
                    path: 'emitempls/:emitempl?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempl.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempls', parameterName: 'emitempl' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitempledit-view9-edit-mode/emitempledit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emitem.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-dashboard-view/emitem-dashboard-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emitem.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-dashboard-view/emitem-dashboard-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emitem.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-dashboard-view/emitem-dashboard-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emitem.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-dashboard-view/emitem-dashboard-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emitem.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-dashboard-view/emitem-dashboard-view.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emitemtype.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-type-tree-exp-view/emitem-type-tree-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'emplans/:emplan?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emplan.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanoption-view/emplanoption-view.vue'),
                },
                {
                    path: 'emeqlocations/:emeqlocation?/alllocgridview/:alllocgridview?',
                    meta: {
                        caption: 'entities.emeqlocation.views.alllocgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlocations', parameterName: 'emeqlocation' },
                            { pathName: 'alllocgridview', parameterName: 'alllocgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlocation-all-loc-grid-view/emeqlocation-all-loc-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-tree-exp-view/emwplist-tree-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-tree-exp-view/emwplist-tree-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-tree-exp-view/emwplist-tree-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-tree-exp-view/emwplist-tree-exp-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-tree-exp-view/emwplist-tree-exp-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-tree-exp-view/emwplist-tree-exp-view.vue'),
                },
                {
                    path: 'emitemcs/:emitemcs?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemcs.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemcs', parameterName: 'emitemcs' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemcsedit-view9/emitemcsedit-view9.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfomo.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfomopickup-view/emrfomopickup-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfomo.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfomopickup-view/emrfomopickup-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/emrfocas/:emrfoca?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfoca.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfocapickup-view/emrfocapickup-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/emrfocas/:emrfoca?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfoca.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfocapickup-view/emrfocapickup-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfocas/:emrfoca?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfoca.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfocapickup-view/emrfocapickup-view.vue'),
                },
                {
                    path: 'emrfocas/:emrfoca?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfoca.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfocapickup-view/emrfocapickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_dps/:emwo_dp?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_dp.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-dpgrid-view/emwo-dpgrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emwo_dps/:emwo_dp?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_dp.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-dpgrid-view/emwo-dpgrid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_dps/:emwo_dp?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_dp.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-dpgrid-view/emwo-dpgrid-view.vue'),
                },
                {
                    path: 'emwo_dps/:emwo_dp?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_dp.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-dpgrid-view/emwo-dpgrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_inners/:emwo_inner?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_inner.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_inners', parameterName: 'emwo_inner' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-innergrid-view/emwo-innergrid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_inners/:emwo_inner?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_inner.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_inners', parameterName: 'emwo_inner' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-innergrid-view/emwo-innergrid-view.vue'),
                },
                {
                    path: 'emwo_inners/:emwo_inner?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_inner.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_inners', parameterName: 'emwo_inner' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-innergrid-view/emwo-innergrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/allgridview/:allgridview?',
                    meta: {
                        caption: 'entities.emequip.views.allgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'allgridview', parameterName: 'allgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-all-grid-view/emequip-all-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/allgridview/:allgridview?',
                    meta: {
                        caption: 'entities.emequip.views.allgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'allgridview', parameterName: 'allgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-all-grid-view/emequip-all-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/baseinfoview/:baseinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.baseinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'baseinfoview', parameterName: 'baseinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-base-info-view/emitem-base-info-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/baseinfoview/:baseinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.baseinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'baseinfoview', parameterName: 'baseinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-base-info-view/emitem-base-info-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/baseinfoview/:baseinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.baseinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'baseinfoview', parameterName: 'baseinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-base-info-view/emitem-base-info-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/baseinfoview/:baseinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.baseinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'baseinfoview', parameterName: 'baseinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-base-info-view/emitem-base-info-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/baseinfoview/:baseinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.baseinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'baseinfoview', parameterName: 'baseinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-base-info-view/emitem-base-info-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-grid-view/emitempickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-grid-view/emitempickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-grid-view/emitempickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-grid-view/emitempickup-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-grid-view/emitempickup-grid-view.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emitemtype.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-type-edit-view-edit-mode/emitem-type-edit-view-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_dps/:emwo_dp?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_dp.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-dpwoview-edit-view/emwo-dpwoview-edit-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emwo_dps/:emwo_dp?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_dp.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-dpwoview-edit-view/emwo-dpwoview-edit-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_dps/:emwo_dp?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_dp.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-dpwoview-edit-view/emwo-dpwoview-edit-view.vue'),
                },
                {
                    path: 'emwo_dps/:emwo_dp?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_dp.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-dpwoview-edit-view/emwo-dpwoview-edit-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqsetups/:emeqsetup?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqsetup.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqsetup-grid-view/emeqsetup-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqsetups/:emeqsetup?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqsetup.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqsetup-grid-view/emeqsetup-grid-view.vue'),
                },
                {
                    path: 'emeqsetups/:emeqsetup?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqsetup.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqsetup-grid-view/emeqsetup-grid-view.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/infotreeexpview/:infotreeexpview?',
                    meta: {
                        caption: 'entities.emitemtype.views.infotreeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'infotreeexpview', parameterName: 'infotreeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-type-info-tree-exp-view/emitem-type-info-tree-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/waitingridview/:waitingridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.waitingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'waitingridview', parameterName: 'waitingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rin-wait-in-grid-view/emitem-rin-wait-in-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrins/:emitemrin?/waitingridview/:waitingridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.waitingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'waitingridview', parameterName: 'waitingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rin-wait-in-grid-view/emitem-rin-wait-in-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/waitingridview/:waitingridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.waitingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'waitingridview', parameterName: 'waitingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rin-wait-in-grid-view/emitem-rin-wait-in-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrins/:emitemrin?/waitingridview/:waitingridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.waitingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'waitingridview', parameterName: 'waitingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rin-wait-in-grid-view/emitem-rin-wait-in-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrins/:emitemrin?/waitingridview/:waitingridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.waitingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'waitingridview', parameterName: 'waitingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rin-wait-in-grid-view/emitem-rin-wait-in-grid-view.vue'),
                },
                {
                    path: 'emitemrins/:emitemrin?/waitingridview/:waitingridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.waitingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'waitingridview', parameterName: 'waitingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rin-wait-in-grid-view/emitem-rin-wait-in-grid-view.vue'),
                },
                {
                    path: 'emdrwgs/:emdrwg?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emdrwg.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emdrwgs', parameterName: 'emdrwg' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emdrwgoption-view/emdrwgoption-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emrfode.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfodeedit-view9-edit-mode/emrfodeedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emservice.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservicepickup-grid-view/emservicepickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'emplans/:emplan?/eqinfo/:eqinfo?',
                    meta: {
                        caption: 'entities.emplan.views.eqinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'eqinfo', parameterName: 'eqinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-eqinfo/emplan-eqinfo.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/editview/:editview?',
                    meta: {
                        caption: 'entities.emitem.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemedit-view/emitemedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/editview/:editview?',
                    meta: {
                        caption: 'entities.emitem.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemedit-view/emitemedit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/editview/:editview?',
                    meta: {
                        caption: 'entities.emitem.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemedit-view/emitemedit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/editview/:editview?',
                    meta: {
                        caption: 'entities.emitem.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemedit-view/emitemedit-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/editview/:editview?',
                    meta: {
                        caption: 'entities.emitem.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemedit-view/emitemedit-view.vue'),
                },
                {
                    path: 'empos/:empo?/onordergridview/:onordergridview?',
                    meta: {
                        caption: 'entities.empo.views.onordergridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'onordergridview', parameterName: 'onordergridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empoon-order-grid-view/empoon-order-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-view/emitemrinpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrins/:emitemrin?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-view/emitemrinpickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-view/emitemrinpickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrins/:emitemrin?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-view/emitemrinpickup-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrins/:emitemrin?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-view/emitemrinpickup-view.vue'),
                },
                {
                    path: 'emitemrins/:emitemrin?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-view/emitemrinpickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqkeeps/:emeqkeep?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqkeep.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqkeepedit-view9-edit-mode/emeqkeepedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqkeeps/:emeqkeep?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqkeep.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqkeepedit-view9-edit-mode/emeqkeepedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emeqkeeps/:emeqkeep?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqkeep.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqkeepedit-view9-edit-mode/emeqkeepedit-view9-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqmaintances/:emeqmaintance?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmaintance-cal-edit-view9/emeqmaintance-cal-edit-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqmaintances/:emeqmaintance?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmaintance-cal-edit-view9/emeqmaintance-cal-edit-view9.vue'),
                },
                {
                    path: 'emeqmaintances/:emeqmaintance?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmaintance-cal-edit-view9/emeqmaintance-cal-edit-view9.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfodemaps/:emrfodemap?/dataview/:dataview?',
                    meta: {
                        caption: 'entities.emrfodemap.views.dataview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfodemaps', parameterName: 'emrfodemap' },
                            { pathName: 'dataview', parameterName: 'dataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfodemap-data-view/emrfodemap-data-view.vue'),
                },
                {
                    path: 'emrfodemaps/:emrfodemap?/dataview/:dataview?',
                    meta: {
                        caption: 'entities.emrfodemap.views.dataview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodemaps', parameterName: 'emrfodemap' },
                            { pathName: 'dataview', parameterName: 'dataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfodemap-data-view/emrfodemap-data-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/confirmcosteditview9/:confirmcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.confirmcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confirmcosteditview9', parameterName: 'confirmcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confirm-cost-edit-view9/emwplist-confirm-cost-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/confirmcosteditview9/:confirmcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.confirmcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confirmcosteditview9', parameterName: 'confirmcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confirm-cost-edit-view9/emwplist-confirm-cost-edit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/confirmcosteditview9/:confirmcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.confirmcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confirmcosteditview9', parameterName: 'confirmcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confirm-cost-edit-view9/emwplist-confirm-cost-edit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/confirmcosteditview9/:confirmcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.confirmcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confirmcosteditview9', parameterName: 'confirmcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confirm-cost-edit-view9/emwplist-confirm-cost-edit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/confirmcosteditview9/:confirmcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.confirmcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confirmcosteditview9', parameterName: 'confirmcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confirm-cost-edit-view9/emwplist-confirm-cost-edit-view9.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/confirmcosteditview9/:confirmcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.confirmcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confirmcosteditview9', parameterName: 'confirmcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confirm-cost-edit-view9/emwplist-confirm-cost-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/supplyinfoview/:supplyinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.supplyinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'supplyinfoview', parameterName: 'supplyinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-supply-info-view/emitem-supply-info-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/supplyinfoview/:supplyinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.supplyinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'supplyinfoview', parameterName: 'supplyinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-supply-info-view/emitem-supply-info-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/supplyinfoview/:supplyinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.supplyinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'supplyinfoview', parameterName: 'supplyinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-supply-info-view/emitem-supply-info-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/supplyinfoview/:supplyinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.supplyinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'supplyinfoview', parameterName: 'supplyinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-supply-info-view/emitem-supply-info-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/supplyinfoview/:supplyinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.supplyinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'supplyinfoview', parameterName: 'supplyinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-supply-info-view/emitem-supply-info-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'emplans/:emplan?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-view/emplanpickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqchecks/:emeqcheck?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqcheck.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqcheckedit-view9-edit-mode/emeqcheckedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqchecks/:emeqcheck?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqcheck.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqcheckedit-view9-edit-mode/emeqcheckedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emeqchecks/:emeqcheck?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqcheck.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqcheckedit-view9-edit-mode/emeqcheckedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emrfode.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfodetab-exp-view/emrfodetab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emstocks/:emstock?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstockpickup-view/emstockpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9/emitempuseedit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_oscs/:emwo_osc?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_osc.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-oscedit-view-edit-mode/emwo-oscedit-view-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_oscs/:emwo_osc?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_osc.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-oscedit-view-edit-mode/emwo-oscedit-view-edit-mode.vue'),
                },
                {
                    path: 'emwo_oscs/:emwo_osc?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_osc.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-oscedit-view-edit-mode/emwo-oscedit-view-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-confirmed-grid-view/emitem-prtn-confirmed-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemprtns/:emitemprtn?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-confirmed-grid-view/emitem-prtn-confirmed-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-confirmed-grid-view/emitem-prtn-confirmed-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemprtns/:emitemprtn?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-confirmed-grid-view/emitem-prtn-confirmed-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemprtns/:emitemprtn?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-confirmed-grid-view/emitem-prtn-confirmed-grid-view.vue'),
                },
                {
                    path: 'emitemprtns/:emitemprtn?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-confirmed-grid-view/emitem-prtn-confirmed-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empodetail.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view9-edit-mode/empodetailedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-to-confirm-grid-view/emitem-rout-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrouts/:emitemrout?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-to-confirm-grid-view/emitem-rout-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-to-confirm-grid-view/emitem-rout-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrouts/:emitemrout?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-to-confirm-grid-view/emitem-rout-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrouts/:emitemrout?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-to-confirm-grid-view/emitem-rout-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emitemrouts/:emitemrout?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-to-confirm-grid-view/emitem-rout-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emwplistcosts/:emwplistcost?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view/emwplistcostedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstore.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstorepickup-view/emstorepickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-confirmed-grid-view/emitem-rout-confirmed-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrouts/:emitemrout?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-confirmed-grid-view/emitem-rout-confirmed-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-confirmed-grid-view/emitem-rout-confirmed-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrouts/:emitemrout?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-confirmed-grid-view/emitem-rout-confirmed-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrouts/:emitemrout?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-confirmed-grid-view/emitem-rout-confirmed-grid-view.vue'),
                },
                {
                    path: 'emitemrouts/:emitemrout?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-confirmed-grid-view/emitem-rout-confirmed-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emstocks/:emstock?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstock.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-pickup-grid-view/emstock-pickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emwplistcosts/:emwplistcost?/confirmgridview9/:confirmgridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.confirmgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'confirmgridview9', parameterName: 'confirmgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-cost-confirm-grid-view9/emwplist-cost-confirm-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-grid-view/emitem-puse-grid-view.vue'),
                },
                {
                    path: 'emwooris/:emwoori?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwoori.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwooris', parameterName: 'emwoori' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwooripickup-view/emwooripickup-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/gridexpview/:gridexpview?',
                    meta: {
                        caption: 'entities.emeqtype.views.gridexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'gridexpview', parameterName: 'gridexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqtype-grid-exp-view/emeqtype-grid-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemprtnedit-view9/emitemprtnedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemprtns/:emitemprtn?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemprtnedit-view9/emitemprtnedit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemprtnedit-view9/emitemprtnedit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemprtns/:emitemprtn?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemprtnedit-view9/emitemprtnedit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemprtns/:emitemprtn?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemprtnedit-view9/emitemprtnedit-view9.vue'),
                },
                {
                    path: 'emitemprtns/:emitemprtn?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemprtnedit-view9/emitemprtnedit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'emplans/:emplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplanpickup-grid-view/emplanpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cancel-grid-view/emwplist-cancel-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cancel-grid-view/emwplist-cancel-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cancel-grid-view/emwplist-cancel-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cancel-grid-view/emwplist-cancel-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cancel-grid-view/emwplist-cancel-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/cancelgridview/:cancelgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.cancelgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'cancelgridview', parameterName: 'cancelgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cancel-grid-view/emwplist-cancel-grid-view.vue'),
                },
                {
                    path: 'emdrwgs/:emdrwg?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emdrwg.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emdrwgs', parameterName: 'emdrwg' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emdrwgedit-view-edit-mode/emdrwgedit-view-edit-mode.vue'),
                },
                {
                    path: 'pfunits/:pfunit?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.pfunit.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfunits', parameterName: 'pfunit' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-pf/pfunitpickup-view/pfunitpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-view/emitempickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-view/emitempickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-view/emitempickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-view/emitempickup-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitem.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempickup-view/emitempickup-view.vue'),
                },
                {
                    path: 'emassets/:emasset?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emasset.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassets', parameterName: 'emasset' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emassetedit-view9/emassetedit-view9.vue'),
                },
                {
                    path: 'emeqlocations/:emeqlocation?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emeqlocation.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlocations', parameterName: 'emeqlocation' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqlocationpickup-grid-view/emeqlocationpickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqwls/:emeqwl?/wleditview/:wleditview?',
                    meta: {
                        caption: 'entities.emeqwl.views.wleditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqwls', parameterName: 'emeqwl' },
                            { pathName: 'wleditview', parameterName: 'wleditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqwlwledit-view/emeqwlwledit-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqwls/:emeqwl?/wleditview/:wleditview?',
                    meta: {
                        caption: 'entities.emeqwl.views.wleditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqwls', parameterName: 'emeqwl' },
                            { pathName: 'wleditview', parameterName: 'wleditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqwlwledit-view/emeqwlwledit-view.vue'),
                },
                {
                    path: 'emeqwls/:emeqwl?/wleditview/:wleditview?',
                    meta: {
                        caption: 'entities.emeqwl.views.wleditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqwls', parameterName: 'emeqwl' },
                            { pathName: 'wleditview', parameterName: 'wleditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqwlwledit-view/emeqwlwledit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/wpprocesstreeexpview/:wpprocesstreeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.wpprocesstreeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'wpprocesstreeexpview', parameterName: 'wpprocesstreeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wp-process-tree-exp-view/emwplist-wp-process-tree-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/wpprocesstreeexpview/:wpprocesstreeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.wpprocesstreeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'wpprocesstreeexpview', parameterName: 'wpprocesstreeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wp-process-tree-exp-view/emwplist-wp-process-tree-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/wpprocesstreeexpview/:wpprocesstreeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.wpprocesstreeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'wpprocesstreeexpview', parameterName: 'wpprocesstreeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wp-process-tree-exp-view/emwplist-wp-process-tree-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/wpprocesstreeexpview/:wpprocesstreeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.wpprocesstreeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'wpprocesstreeexpview', parameterName: 'wpprocesstreeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wp-process-tree-exp-view/emwplist-wp-process-tree-exp-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/wpprocesstreeexpview/:wpprocesstreeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.wpprocesstreeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'wpprocesstreeexpview', parameterName: 'wpprocesstreeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wp-process-tree-exp-view/emwplist-wp-process-tree-exp-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/wpprocesstreeexpview/:wpprocesstreeexpview?',
                    meta: {
                        caption: 'entities.emwplist.views.wpprocesstreeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'wpprocesstreeexpview', parameterName: 'wpprocesstreeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wp-process-tree-exp-view/emwplist-wp-process-tree-exp-view.vue'),
                },
                {
                    path: 'emeqlocations/:emeqlocation?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emeqlocation.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlocations', parameterName: 'emeqlocation' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqlocationpickup-view/emeqlocationpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/drafteditview9/:drafteditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.drafteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'drafteditview9', parameterName: 'drafteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-draft-edit-view9/emitem-puse-draft-edit-view9.vue'),
                },
                {
                    path: 'emeqlocations/:emeqlocation?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emeqlocation.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlocations', parameterName: 'emeqlocation' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlocation-tree-exp-view/emeqlocation-tree-exp-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/emrfoacs/:emrfoac?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfoac.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfoacpickup-view/emrfoacpickup-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/emrfoacs/:emrfoac?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfoac.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfoacpickup-view/emrfoacpickup-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfoacs/:emrfoac?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfoac.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfoacpickup-view/emrfoacpickup-view.vue'),
                },
                {
                    path: 'emrfoacs/:emrfoac?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfoac.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfoacpickup-view/emrfoacpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emwplistcosts/:emwplistcost?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplistcost.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistcostedit-view9-edit-mode/emwplistcostedit-view9-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqmaintances/:emeqmaintance?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqmaintanceedit-view9-edit-mode/emeqmaintanceedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqmaintances/:emeqmaintance?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqmaintanceedit-view9-edit-mode/emeqmaintanceedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emeqmaintances/:emeqmaintance?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqmaintanceedit-view9-edit-mode/emeqmaintanceedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emeqmonitors/:emeqmonitor?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqmonitor.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmonitors', parameterName: 'emeqmonitor' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmonitor-grid-view/emeqmonitor-grid-view.vue'),
                },
                {
                    path: 'empos/:empo?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empo.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empopickup-view/empopickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emserviceevls/:emserviceevl?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emserviceevl.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emserviceevls', parameterName: 'emserviceevl' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservice-evl-grid-view9/emservice-evl-grid-view9.vue'),
                },
                {
                    path: 'emserviceevls/:emserviceevl?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emserviceevl.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emserviceevls', parameterName: 'emserviceevl' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservice-evl-grid-view9/emservice-evl-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemroutedit-view9/emitemroutedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrouts/:emitemrout?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemroutedit-view9/emitemroutedit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemroutedit-view9/emitemroutedit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrouts/:emitemrout?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemroutedit-view9/emitemroutedit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrouts/:emitemrout?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemroutedit-view9/emitemroutedit-view9.vue'),
                },
                {
                    path: 'emitemrouts/:emitemrout?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemroutedit-view9/emitemroutedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/confimcostgridview/:confimcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.confimcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confimcostgridview', parameterName: 'confimcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confim-cost-grid-view/emwplist-confim-cost-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/confimcostgridview/:confimcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.confimcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confimcostgridview', parameterName: 'confimcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confim-cost-grid-view/emwplist-confim-cost-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/confimcostgridview/:confimcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.confimcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confimcostgridview', parameterName: 'confimcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confim-cost-grid-view/emwplist-confim-cost-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/confimcostgridview/:confimcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.confimcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confimcostgridview', parameterName: 'confimcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confim-cost-grid-view/emwplist-confim-cost-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/confimcostgridview/:confimcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.confimcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confimcostgridview', parameterName: 'confimcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confim-cost-grid-view/emwplist-confim-cost-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/confimcostgridview/:confimcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.confimcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'confimcostgridview', parameterName: 'confimcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-confim-cost-grid-view/emwplist-confim-cost-grid-view.vue'),
                },
                {
                    path: 'emeqkps/:emeqkp?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqkp.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqkps', parameterName: 'emeqkp' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqkpgrid-view/emeqkpgrid-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/gridexpview/:gridexpview?',
                    meta: {
                        caption: 'entities.emrfode.views.gridexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'gridexpview', parameterName: 'gridexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfodegrid-exp-view/emrfodegrid-exp-view.vue'),
                },
                {
                    path: 'emeqlctgsses/:emeqlctgss?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqlctgss.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlctgsses', parameterName: 'emeqlctgss' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqlctgssedit-view/emeqlctgssedit-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplantempl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-templ-grid-view/emplan-templ-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplantempl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-templ-grid-view/emplan-templ-grid-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplantempl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-templ-grid-view/emplan-templ-grid-view.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplantempl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-templ-grid-view/emplan-templ-grid-view.vue'),
                },
                {
                    path: 'emrfodetypes/:emrfodetype?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfodetype.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodetypes', parameterName: 'emrfodetype' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfodetypegrid-view/emrfodetypegrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemtrades/:emitemtrade?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemtradegrid-view/emitemtradegrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemtrades/:emitemtrade?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemtradegrid-view/emitemtradegrid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemtrades/:emitemtrade?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemtradegrid-view/emitemtradegrid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemtrades/:emitemtrade?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemtradegrid-view/emitemtradegrid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemtrades/:emitemtrade?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemtradegrid-view/emitemtradegrid-view.vue'),
                },
                {
                    path: 'emitemtrades/:emitemtrade?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemtradegrid-view/emitemtradegrid-view.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/pickuptreeview/:pickuptreeview?',
                    meta: {
                        caption: 'entities.emitemtype.views.pickuptreeview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'pickuptreeview', parameterName: 'pickuptreeview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-type-pickup-tree-view/emitem-type-pickup-tree-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/treepickupview/:treepickupview?',
                    meta: {
                        caption: 'entities.emeqtype.views.treepickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'treepickupview', parameterName: 'treepickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqtype-tree-pickup-view/emeqtype-tree-pickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-view/emwplistpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-view/emwplistpickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-view/emwplistpickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-view/emwplistpickup-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-view/emwplistpickup-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-view/emwplistpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'emwplistcosts/:emwplistcost?/fillcostview/:fillcostview?',
                    meta: {
                        caption: 'entities.emwplistcost.views.fillcostview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'fillcostview', parameterName: 'fillcostview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-fill-cost-view/emwplist-cost-fill-cost-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqchecks/:emeqcheck?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqcheck.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqcheck-grid-view/emeqcheck-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqchecks/:emeqcheck?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqcheck.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqcheck-grid-view/emeqcheck-grid-view.vue'),
                },
                {
                    path: 'emeqchecks/:emeqcheck?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqcheck.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqcheck-grid-view/emeqcheck-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/ingridview/:ingridview?',
                    meta: {
                        caption: 'entities.emwplist.views.ingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'ingridview', parameterName: 'ingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-in-grid-view/emwplist-in-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/ingridview/:ingridview?',
                    meta: {
                        caption: 'entities.emwplist.views.ingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'ingridview', parameterName: 'ingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-in-grid-view/emwplist-in-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/ingridview/:ingridview?',
                    meta: {
                        caption: 'entities.emwplist.views.ingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'ingridview', parameterName: 'ingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-in-grid-view/emwplist-in-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/ingridview/:ingridview?',
                    meta: {
                        caption: 'entities.emwplist.views.ingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'ingridview', parameterName: 'ingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-in-grid-view/emwplist-in-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/ingridview/:ingridview?',
                    meta: {
                        caption: 'entities.emwplist.views.ingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'ingridview', parameterName: 'ingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-in-grid-view/emwplist-in-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/ingridview/:ingridview?',
                    meta: {
                        caption: 'entities.emwplist.views.ingridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'ingridview', parameterName: 'ingridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-in-grid-view/emwplist-in-grid-view.vue'),
                },
                {
                    path: 'emassetclasses/:emassetclass?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emassetclass.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclasses', parameterName: 'emassetclass' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclasspickup-grid-view/emassetclasspickup-grid-view.vue'),
                },
                {
                    path: 'emeqmpmtrs/:emeqmpmtr?/mpmtreditview/:mpmtreditview?',
                    meta: {
                        caption: 'entities.emeqmpmtr.views.mpmtreditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmpmtrs', parameterName: 'emeqmpmtr' },
                            { pathName: 'mpmtreditview', parameterName: 'mpmtreditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmpmtrmp-mtr-edit-view/emeqmpmtrmp-mtr-edit-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emequip.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emequip-edit-view-edit-mode/emequip-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emequip.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emequip-edit-view-edit-mode/emequip-edit-view-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqmaintances/:emeqmaintance?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqmaintance-grid-view/emeqmaintance-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqmaintances/:emeqmaintance?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqmaintance-grid-view/emeqmaintance-grid-view.vue'),
                },
                {
                    path: 'emeqmaintances/:emeqmaintance?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqmaintance.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqmaintance-grid-view/emeqmaintance-grid-view.vue'),
                },
                {
                    path: 'emrfodetypes/:emrfodetype?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfodetype.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodetypes', parameterName: 'emrfodetype' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfodetypeedit-view/emrfodetypeedit-view.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empurplan.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empurplanpickup-grid-view/empurplanpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemprtnedit-view9-edit-mode/emitemprtnedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemprtns/:emitemprtn?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemprtnedit-view9-edit-mode/emitemprtnedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemprtnedit-view9-edit-mode/emitemprtnedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemprtns/:emitemprtn?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemprtnedit-view9-edit-mode/emitemprtnedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemprtns/:emitemprtn?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemprtnedit-view9-edit-mode/emitemprtnedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitemprtns/:emitemprtn?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemprtn.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemprtnedit-view9-edit-mode/emitemprtnedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-grid-view/empodetailpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinedit-view9/emitemrinedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrins/:emitemrin?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinedit-view9/emitemrinedit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinedit-view9/emitemrinedit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrins/:emitemrin?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinedit-view9/emitemrinedit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrins/:emitemrin?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinedit-view9/emitemrinedit-view9.vue'),
                },
                {
                    path: 'emitemrins/:emitemrin?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinedit-view9/emitemrinedit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqchecks/:emeqcheck?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqcheck.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqcheck-cal-edit-view9/emeqcheck-cal-edit-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqchecks/:emeqcheck?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqcheck.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqcheck-cal-edit-view9/emeqcheck-cal-edit-view9.vue'),
                },
                {
                    path: 'emeqchecks/:emeqcheck?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqcheck.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqcheck-cal-edit-view9/emeqcheck-cal-edit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqdebugs/:emeqdebug?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqdebug.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqdebugs', parameterName: 'emeqdebug' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqdebug-grid-view/emeqdebug-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqdebugs/:emeqdebug?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqdebug.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqdebugs', parameterName: 'emeqdebug' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqdebug-grid-view/emeqdebug-grid-view.vue'),
                },
                {
                    path: 'emeqdebugs/:emeqdebug?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqdebug.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqdebugs', parameterName: 'emeqdebug' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqdebug-grid-view/emeqdebug-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwos/:emwo?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwo.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwopickup-grid-view/emwopickup-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwos/:emwo?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwo.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwopickup-grid-view/emwopickup-grid-view.vue'),
                },
                {
                    path: 'emwos/:emwo?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwo.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwopickup-grid-view/emwopickup-grid-view.vue'),
                },
                {
                    path: 'emassets/:emasset?/emassetclears/:emassetclear?/editview/:editview?',
                    meta: {
                        caption: 'entities.emassetclear.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassets', parameterName: 'emasset' },
                            { pathName: 'emassetclears', parameterName: 'emassetclear' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclearedit-view/emassetclearedit-view.vue'),
                },
                {
                    path: 'emassetclears/:emassetclear?/editview/:editview?',
                    meta: {
                        caption: 'entities.emassetclear.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclears', parameterName: 'emassetclear' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclearedit-view/emassetclearedit-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/emrfoacs/:emrfoac?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfoac.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfoacedit-view/emrfoacedit-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/emrfoacs/:emrfoac?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfoac.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfoacedit-view/emrfoacedit-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfoacs/:emrfoac?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfoac.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfoacedit-view/emrfoacedit-view.vue'),
                },
                {
                    path: 'emrfoacs/:emrfoac?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfoac.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfoacedit-view/emrfoacedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwplist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistgrid-view/emwplistgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwplist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistgrid-view/emwplistgrid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwplist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistgrid-view/emwplistgrid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwplist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistgrid-view/emwplistgrid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwplist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistgrid-view/emwplistgrid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwplist.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistgrid-view/emwplistgrid-view.vue'),
                },
                {
                    path: 'emassets/:emasset?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emasset.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassets', parameterName: 'emasset' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emassetpickup-grid-view/emassetpickup-grid-view.vue'),
                },
                {
                    path: 'emassets/:emasset?/emassetclears/:emassetclear?/gridview_5564/:gridview_5564?',
                    meta: {
                        caption: 'entities.emassetclear.views.gridview_5564.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassets', parameterName: 'emasset' },
                            { pathName: 'emassetclears', parameterName: 'emassetclear' },
                            { pathName: 'gridview_5564', parameterName: 'gridview_5564' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetcleargrid-view-5564/emassetcleargrid-view-5564.vue'),
                },
                {
                    path: 'emassetclears/:emassetclear?/gridview_5564/:gridview_5564?',
                    meta: {
                        caption: 'entities.emassetclear.views.gridview_5564.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclears', parameterName: 'emassetclear' },
                            { pathName: 'gridview_5564', parameterName: 'gridview_5564' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetcleargrid-view-5564/emassetcleargrid-view-5564.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/treeexpview2/:treeexpview2?',
                    meta: {
                        caption: 'entities.emeqtype.views.treeexpview2.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'treeexpview2', parameterName: 'treeexpview2' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqtype-tree-exp-view2/emeqtype-tree-exp-view2.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/podgridview/:podgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.podgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'podgridview', parameterName: 'podgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-pod-grid-view/emwplist-pod-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/podgridview/:podgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.podgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'podgridview', parameterName: 'podgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-pod-grid-view/emwplist-pod-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/podgridview/:podgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.podgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'podgridview', parameterName: 'podgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-pod-grid-view/emwplist-pod-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/podgridview/:podgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.podgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'podgridview', parameterName: 'podgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-pod-grid-view/emwplist-pod-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/podgridview/:podgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.podgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'podgridview', parameterName: 'podgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-pod-grid-view/emwplist-pod-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/podgridview/:podgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.podgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'podgridview', parameterName: 'podgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-pod-grid-view/emwplist-pod-grid-view.vue'),
                },
                {
                    path: 'emitemcs/:emitemcs?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemcs.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemcs', parameterName: 'emitemcs' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemcsedit-view9-edit-mode/emitemcsedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitem.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-grid-view/emitem-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitem.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-grid-view/emitem-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitem.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-grid-view/emitem-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitem.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-grid-view/emitem-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitem.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-grid-view/emitem-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view-edit-mode/emeqsparedetailedit-view-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view-edit-mode/emeqsparedetailedit-view-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view-edit-mode/emeqsparedetailedit-view-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view-edit-mode/emeqsparedetailedit-view-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view-edit-mode/emeqsparedetailedit-view-edit-mode.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/emeqsparedetails/:emeqsparedetail?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view-edit-mode/emeqsparedetailedit-view-edit-mode.vue'),
                },
                {
                    path: 'emeqsparedetails/:emeqsparedetail?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view-edit-mode/emeqsparedetailedit-view-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'emplans/:emplan?/personinfo/:personinfo?',
                    meta: {
                        caption: 'entities.emplan.views.personinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'personinfo', parameterName: 'personinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-person-info/emplan-person-info.vue'),
                },
                {
                    path: 'emitempls/:emitempl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitempl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempls', parameterName: 'emitempl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemplgrid-view/emitemplgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailgrid-view/empodetailgrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqsetups/:emeqsetup?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqsetup.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqsetupedit-view9-edit-mode/emeqsetupedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqsetups/:emeqsetup?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqsetup.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqsetupedit-view9-edit-mode/emeqsetupedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emeqsetups/:emeqsetup?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emeqsetup.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqsetupedit-view9-edit-mode/emeqsetupedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emeqmps/:emeqmp?/mpeditview/:mpeditview?',
                    meta: {
                        caption: 'entities.emeqmp.views.mpeditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmps', parameterName: 'emeqmp' },
                            { pathName: 'mpeditview', parameterName: 'mpeditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmpmpedit-view/emeqmpmpedit-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwos/:emwo?/calendarexpview/:calendarexpview?',
                    meta: {
                        caption: 'entities.emwo.views.calendarexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwocalendar-exp-view/emwocalendar-exp-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwos/:emwo?/calendarexpview/:calendarexpview?',
                    meta: {
                        caption: 'entities.emwo.views.calendarexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwocalendar-exp-view/emwocalendar-exp-view.vue'),
                },
                {
                    path: 'emwos/:emwo?/calendarexpview/:calendarexpview?',
                    meta: {
                        caption: 'entities.emwo.views.calendarexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwocalendar-exp-view/emwocalendar-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emequip.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-pickup-grid-view/emequip-pickup-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emequip.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-pickup-grid-view/emequip-pickup-grid-view.vue'),
                },
                {
                    path: 'emeqlocations/:emeqlocation?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqlocation.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlocations', parameterName: 'emeqlocation' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqlocation-edit-view/emeqlocation-edit-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfomo.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfomogrid-view/emrfomogrid-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfomo.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfomogrid-view/emrfomogrid-view.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/editview_itemtype/:editview_itemtype?',
                    meta: {
                        caption: 'entities.emitemtype.views.editview_itemtype.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'editview_itemtype', parameterName: 'editview_itemtype' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-type-edit-view-itemtype/emitem-type-edit-view-itemtype.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-detail-tab-exp-view/emeqspare-detail-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-detail-tab-exp-view/emeqspare-detail-tab-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-detail-tab-exp-view/emeqspare-detail-tab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-detail-tab-exp-view/emeqspare-detail-tab-exp-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-detail-tab-exp-view/emeqspare-detail-tab-exp-view.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/emeqsparedetails/:emeqsparedetail?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-detail-tab-exp-view/emeqspare-detail-tab-exp-view.vue'),
                },
                {
                    path: 'emeqsparedetails/:emeqsparedetail?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-detail-tab-exp-view/emeqspare-detail-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-view/emitempusepickup-view.vue'),
                },
                {
                    path: 'emeqmpmtrs/:emeqmpmtr?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqmpmtr.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmpmtrs', parameterName: 'emeqmpmtr' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmpmtrgrid-view/emeqmpmtrgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-tab-exp-view/emitem-prtn-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemprtns/:emitemprtn?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-tab-exp-view/emitem-prtn-tab-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-tab-exp-view/emitem-prtn-tab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemprtns/:emitemprtn?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-tab-exp-view/emitem-prtn-tab-exp-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemprtns/:emitemprtn?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-tab-exp-view/emitem-prtn-tab-exp-view.vue'),
                },
                {
                    path: 'emitemprtns/:emitemprtn?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-tab-exp-view/emitem-prtn-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emstocks/:emstock?/editview/:editview?',
                    meta: {
                        caption: 'entities.emstock.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstock-edit-view/emstock-edit-view.vue'),
                },
                {
                    path: 'emeqmonitors/:emeqmonitor?/monitoreditview/:monitoreditview?',
                    meta: {
                        caption: 'entities.emeqmonitor.views.monitoreditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmonitors', parameterName: 'emeqmonitor' },
                            { pathName: 'monitoreditview', parameterName: 'monitoreditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmonitor-monitor-edit-view/emeqmonitor-monitor-edit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistedit-view/emwplistedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistedit-view/emwplistedit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistedit-view/emwplistedit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistedit-view/emwplistedit-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistedit-view/emwplistedit-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/editview/:editview?',
                    meta: {
                        caption: 'entities.emwplist.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplistedit-view/emwplistedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emstore.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emstore-edit-view-edit-mode/emstore-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/emrfocas/:emrfoca?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emrfoca.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfocapickup-grid-view/emrfocapickup-grid-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/emrfocas/:emrfoca?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emrfoca.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfocapickup-grid-view/emrfocapickup-grid-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfocas/:emrfoca?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emrfoca.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfocapickup-grid-view/emrfocapickup-grid-view.vue'),
                },
                {
                    path: 'emrfocas/:emrfoca?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emrfoca.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfocapickup-grid-view/emrfocapickup-grid-view.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/emeqsparemaps/:emeqsparemap?/dataview9/:dataview9?',
                    meta: {
                        caption: 'entities.emeqsparemap.views.dataview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'emeqsparemaps', parameterName: 'emeqsparemap' },
                            { pathName: 'dataview9', parameterName: 'dataview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-map-data-view9/emeqspare-map-data-view9.vue'),
                },
                {
                    path: 'emeqsparemaps/:emeqsparemap?/dataview9/:dataview9?',
                    meta: {
                        caption: 'entities.emeqsparemap.views.dataview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsparemaps', parameterName: 'emeqsparemap' },
                            { pathName: 'dataview9', parameterName: 'dataview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqspare-map-data-view9/emeqspare-map-data-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emstocks/:emstock?/bystorepartgridview/:bystorepartgridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystorepartgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystorepartgridview', parameterName: 'bystorepartgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-part-grid-view/emstock-by-store-part-grid-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqtype.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqtype-edit-view-edit-mode/emeqtype-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emrfomo.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfomopickup-grid-view/emrfomopickup-grid-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emrfomo.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfomopickup-grid-view/emrfomopickup-grid-view.vue'),
                },
                {
                    path: 'empos/:empo?/placeordergridview/:placeordergridview?',
                    meta: {
                        caption: 'entities.empo.views.placeordergridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'placeordergridview', parameterName: 'placeordergridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empoplace-order-grid-view/empoplace-order-grid-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emeqtype.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqtype-option-view/emeqtype-option-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emstore.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstorepickup-grid-view/emstorepickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emen/:emen?/emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emenconsums/:emenconsum?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emenconsum.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsumedit-view9-edit-mode/emenconsumedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/itemtreeexpview/:itemtreeexpview?',
                    meta: {
                        caption: 'entities.emitemtype.views.itemtreeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'itemtreeexpview', parameterName: 'itemtreeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-type-item-tree-exp-view/emitem-type-item-tree-exp-view.vue'),
                },
                {
                    path: 'empos/:empo?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.empo.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empoedit-view9/empoedit-view9.vue'),
                },
                {
                    path: 'pfcontracts/:pfcontract?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.pfcontract.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfcontracts', parameterName: 'pfcontract' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-pf/pfcontractpickup-grid-view/pfcontractpickup-grid-view.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitemtype.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-type-pickup-grid-view/emitem-type-pickup-grid-view.vue'),
                },
                {
                    path: 'emitempls/:emitempl?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitempl.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempls', parameterName: 'emitempl' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-plto-confirm-grid-view/emitem-plto-confirm-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqwls/:emeqwl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqwl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqwls', parameterName: 'emeqwl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqwlgrid-view/emeqwlgrid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqwls/:emeqwl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqwl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqwls', parameterName: 'emeqwl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqwlgrid-view/emeqwlgrid-view.vue'),
                },
                {
                    path: 'emeqwls/:emeqwl?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqwl.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqwls', parameterName: 'emeqwl' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqwlgrid-view/emeqwlgrid-view.vue'),
                },
                {
                    path: 'emassets/:emasset?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emasset.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassets', parameterName: 'emasset' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emassettab-exp-view/emassettab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/financeview9/:financeview9?',
                    meta: {
                        caption: 'entities.emservice.views.financeview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'financeview9', parameterName: 'financeview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservice-finance-view9/emservice-finance-view9.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emrfode.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfodepickup-view/emrfodepickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/infoview9/:infoview9?',
                    meta: {
                        caption: 'entities.emservice.views.infoview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'infoview9', parameterName: 'infoview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservice-info-view9/emservice-info-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_oscs/:emwo_osc?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_osc.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-oscgrid-view/emwo-oscgrid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_oscs/:emwo_osc?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_osc.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-oscgrid-view/emwo-oscgrid-view.vue'),
                },
                {
                    path: 'emwo_oscs/:emwo_osc?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_osc.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-oscgrid-view/emwo-oscgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutedit-view9-edit-mode/emitemroutedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrouts/:emitemrout?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutedit-view9-edit-mode/emitemroutedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutedit-view9-edit-mode/emitemroutedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrouts/:emitemrout?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutedit-view9-edit-mode/emitemroutedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrouts/:emitemrout?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutedit-view9-edit-mode/emitemroutedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitemrouts/:emitemrout?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrout.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutedit-view9-edit-mode/emitemroutedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitemcs/:emitemcs?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemcs.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemcs', parameterName: 'emitemcs' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-cstab-exp-view/emitem-cstab-exp-view.vue'),
                },
                {
                    path: 'emeqkps/:emeqkp?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emeqkp.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqkps', parameterName: 'emeqkp' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqkppickup-view/emeqkppickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emapplies/:emapply?/eqgridview/:eqgridview?',
                    meta: {
                        caption: 'entities.emapply.views.eqgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emapplies', parameterName: 'emapply' },
                            { pathName: 'eqgridview', parameterName: 'eqgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emapply-eq-grid-view/emapply-eq-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emapplies/:emapply?/eqgridview/:eqgridview?',
                    meta: {
                        caption: 'entities.emapply.views.eqgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emapplies', parameterName: 'emapply' },
                            { pathName: 'eqgridview', parameterName: 'eqgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emapply-eq-grid-view/emapply-eq-grid-view.vue'),
                },
                {
                    path: 'emapplies/:emapply?/eqgridview/:eqgridview?',
                    meta: {
                        caption: 'entities.emapply.views.eqgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emapplies', parameterName: 'emapply' },
                            { pathName: 'eqgridview', parameterName: 'eqgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emapply-eq-grid-view/emapply-eq-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-draft-grid-view/emitem-rout-draft-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrouts/:emitemrout?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-draft-grid-view/emitem-rout-draft-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-draft-grid-view/emitem-rout-draft-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrouts/:emitemrout?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-draft-grid-view/emitem-rout-draft-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrouts/:emitemrout?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-draft-grid-view/emitem-rout-draft-grid-view.vue'),
                },
                {
                    path: 'emitemrouts/:emitemrout?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-draft-grid-view/emitem-rout-draft-grid-view.vue'),
                },
                {
                    path: 'pfunits/:pfunit?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.pfunit.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfunits', parameterName: 'pfunit' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-pf/pfunitpickup-grid-view/pfunitpickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'emplans/:emplan?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emplan.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-tab-exp-view/emplan-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-edit-view9/emwplist-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-edit-view9/emwplist-edit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-edit-view9/emwplist-edit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-edit-view9/emwplist-edit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-edit-view9/emwplist-edit-view9.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-edit-view9/emwplist-edit-view9.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/emeqsparemaps/:emeqsparemap?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emeqsparemap.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'emeqsparemaps', parameterName: 'emeqsparemap' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqsparemapgrid-view9/emeqsparemapgrid-view9.vue'),
                },
                {
                    path: 'emeqsparemaps/:emeqsparemap?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emeqsparemap.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsparemaps', parameterName: 'emeqsparemap' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqsparemapgrid-view9/emeqsparemapgrid-view9.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/treepickupview/:treepickupview?',
                    meta: {
                        caption: 'entities.emitemtype.views.treepickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'treepickupview', parameterName: 'treepickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-type-tree-pickup-view/emitem-type-tree-pickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.emservice.views.dashboardview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservice-dashboard-view/emservice-dashboard-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emeqtype.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqtype-tree-exp-view/emeqtype-tree-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emen.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-grid-view/emenpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emen/:emen?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emen.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-grid-view/emenpickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emen.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-grid-view/emenpickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emen/:emen?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emen.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-grid-view/emenpickup-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emen/:emen?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emen.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-grid-view/emenpickup-grid-view.vue'),
                },
                {
                    path: 'emen/:emen?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emen.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-grid-view/emenpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emstocks/:emstock?/bystoregridview/:bystoregridview?',
                    meta: {
                        caption: 'entities.emstock.views.bystoregridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstocks', parameterName: 'emstock' },
                            { pathName: 'bystoregridview', parameterName: 'bystoregridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstock-by-store-grid-view/emstock-by-store-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-rin-grid-view/emitem-rin-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrins/:emitemrin?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-rin-grid-view/emitem-rin-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-rin-grid-view/emitem-rin-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrins/:emitemrin?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-rin-grid-view/emitem-rin-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrins/:emitemrin?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-rin-grid-view/emitem-rin-grid-view.vue'),
                },
                {
                    path: 'emitemrins/:emitemrin?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-rin-grid-view/emitem-rin-grid-view.vue'),
                },
                {
                    path: 'emobjects/:emobject?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emobject.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emobjects', parameterName: 'emobject' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emobjectpickup-view/emobjectpickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqsetups/:emeqsetup?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqsetup.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqsetup-cal-edit-view9/emeqsetup-cal-edit-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqsetups/:emeqsetup?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqsetup.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqsetup-cal-edit-view9/emeqsetup-cal-edit-view9.vue'),
                },
                {
                    path: 'emeqsetups/:emeqsetup?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqsetup.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqsetup-cal-edit-view9/emeqsetup-cal-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempuse.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-tab-exp-view/emitem-puse-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemrout.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-tab-exp-view/emitem-rout-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrouts/:emitemrout?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemrout.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-tab-exp-view/emitem-rout-tab-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemrout.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-tab-exp-view/emitem-rout-tab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrouts/:emitemrout?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemrout.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-tab-exp-view/emitem-rout-tab-exp-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrouts/:emitemrout?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemrout.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-tab-exp-view/emitem-rout-tab-exp-view.vue'),
                },
                {
                    path: 'emitemrouts/:emitemrout?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitemrout.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-rout-tab-exp-view/emitem-rout-tab-exp-view.vue'),
                },
                {
                    path: 'emassetclasses/:emassetclass?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emassetclass.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclasses', parameterName: 'emassetclass' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclasspickup-view/emassetclasspickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempusepickup-grid-view/emitempusepickup-grid-view.vue'),
                },
                {
                    path: 'emitemcs/:emitemcs?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitemcs.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemcs', parameterName: 'emitemcs' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-csconfirmed-grid-view/emitem-csconfirmed-grid-view.vue'),
                },
                {
                    path: 'emeqlctgsses/:emeqlctgss?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emeqlctgss.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlctgsses', parameterName: 'emeqlctgss' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlctgsspickup-grid-view/emeqlctgsspickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/waitcostgridview/:waitcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitcostgridview', parameterName: 'waitcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-cost-grid-view/emwplist-wait-cost-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/waitcostgridview/:waitcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitcostgridview', parameterName: 'waitcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-cost-grid-view/emwplist-wait-cost-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/waitcostgridview/:waitcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitcostgridview', parameterName: 'waitcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-cost-grid-view/emwplist-wait-cost-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/waitcostgridview/:waitcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitcostgridview', parameterName: 'waitcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-cost-grid-view/emwplist-wait-cost-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/waitcostgridview/:waitcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitcostgridview', parameterName: 'waitcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-cost-grid-view/emwplist-wait-cost-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/waitcostgridview/:waitcostgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitcostgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitcostgridview', parameterName: 'waitcostgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-cost-grid-view/emwplist-wait-cost-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'emplans/:emplan?/editview/:editview?',
                    meta: {
                        caption: 'entities.emplan.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-edit-view/emplan-edit-view.vue'),
                },
                {
                    path: 'emitemcs/:emitemcs?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemcs.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemcs', parameterName: 'emitemcs' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-csdraft-grid-view/emitem-csdraft-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/fileview9/:fileview9?',
                    meta: {
                        caption: 'entities.emservice.views.fileview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'fileview9', parameterName: 'fileview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservice-file-view9/emservice-file-view9.vue'),
                },
                {
                    path: 'emassetclasses/:emassetclass?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emassetclass.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclasses', parameterName: 'emassetclass' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclassgrid-view/emassetclassgrid-view.vue'),
                },
                {
                    path: 'emitempls/:emitempl?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emitempl.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempls', parameterName: 'emitempl' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempledit-view9/emitempledit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/contactview9/:contactview9?',
                    meta: {
                        caption: 'entities.emservice.views.contactview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'contactview9', parameterName: 'contactview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservice-contact-view9/emservice-contact-view9.vue'),
                },
                {
                    path: 'emdrwgs/:emdrwg?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emdrwg.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emdrwgs', parameterName: 'emdrwg' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emdrwggrid-view/emdrwggrid-view.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emeqspare.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparepickup-grid-view/emeqsparepickup-grid-view.vue'),
                },
                {
                    path: 'emeqlctgsses/:emeqlctgss?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emeqlctgss.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlctgsses', parameterName: 'emeqlctgss' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlctgsstab-exp-view/emeqlctgsstab-exp-view.vue'),
                },
                {
                    path: 'empos/:empo?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.empo.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empoedit-view9-edit-mode/empoedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/poeditview9/:poeditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.poeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'poeditview9', parameterName: 'poeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-poedit-view9/emwplist-poedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/poeditview9/:poeditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.poeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'poeditview9', parameterName: 'poeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-poedit-view9/emwplist-poedit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/poeditview9/:poeditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.poeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'poeditview9', parameterName: 'poeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-poedit-view9/emwplist-poedit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/poeditview9/:poeditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.poeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'poeditview9', parameterName: 'poeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-poedit-view9/emwplist-poedit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/poeditview9/:poeditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.poeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'poeditview9', parameterName: 'poeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-poedit-view9/emwplist-poedit-view9.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/poeditview9/:poeditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.poeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'poeditview9', parameterName: 'poeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-poedit-view9/emwplist-poedit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/fillcosteditview9/:fillcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.fillcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'fillcosteditview9', parameterName: 'fillcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-fill-cost-edit-view9/emwplist-fill-cost-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/fillcosteditview9/:fillcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.fillcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'fillcosteditview9', parameterName: 'fillcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-fill-cost-edit-view9/emwplist-fill-cost-edit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/fillcosteditview9/:fillcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.fillcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'fillcosteditview9', parameterName: 'fillcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-fill-cost-edit-view9/emwplist-fill-cost-edit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/fillcosteditview9/:fillcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.fillcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'fillcosteditview9', parameterName: 'fillcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-fill-cost-edit-view9/emwplist-fill-cost-edit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/fillcosteditview9/:fillcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.fillcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'fillcosteditview9', parameterName: 'fillcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-fill-cost-edit-view9/emwplist-fill-cost-edit-view9.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/fillcosteditview9/:fillcosteditview9?',
                    meta: {
                        caption: 'entities.emwplist.views.fillcosteditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'fillcosteditview9', parameterName: 'fillcosteditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-fill-cost-edit-view9/emwplist-fill-cost-edit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emequip.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emequip-grid-view/emequip-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emequip.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emequip-grid-view/emequip-grid-view.vue'),
                },
                {
                    path: 'emeitires/:emeitires?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emeitires.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeitires', parameterName: 'emeitires' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeitirespickup-grid-view/emeitirespickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_oscs/:emwo_osc?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_osc.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-oscwoview-edit-view/emwo-oscwoview-edit-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_oscs/:emwo_osc?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_osc.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-oscwoview-edit-view/emwo-oscwoview-edit-view.vue'),
                },
                {
                    path: 'emwo_oscs/:emwo_osc?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_osc.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-oscwoview-edit-view/emwo-oscwoview-edit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emstore.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstore-option-view/emstore-option-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqahs/:emeqah?/calendarexpview/:calendarexpview?',
                    meta: {
                        caption: 'entities.emeqah.views.calendarexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqahs', parameterName: 'emeqah' },
                            { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqahcalendar-exp-view/emeqahcalendar-exp-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqahs/:emeqah?/calendarexpview/:calendarexpview?',
                    meta: {
                        caption: 'entities.emeqah.views.calendarexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqahs', parameterName: 'emeqah' },
                            { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqahcalendar-exp-view/emeqahcalendar-exp-view.vue'),
                },
                {
                    path: 'emeqahs/:emeqah?/calendarexpview/:calendarexpview?',
                    meta: {
                        caption: 'entities.emeqah.views.calendarexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqahs', parameterName: 'emeqah' },
                            { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqahcalendar-exp-view/emeqahcalendar-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emapplies/:emapply?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emapply.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emapplies', parameterName: 'emapply' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emapply-grid-view/emapply-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emapplies/:emapply?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emapply.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emapplies', parameterName: 'emapply' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emapply-grid-view/emapply-grid-view.vue'),
                },
                {
                    path: 'emapplies/:emapply?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emapply.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emapplies', parameterName: 'emapply' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emapply-grid-view/emapply-grid-view.vue'),
                },
                {
                    path: 'emeqlctgsses/:emeqlctgss?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emeqlctgss.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlctgsses', parameterName: 'emeqlctgss' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlctgsspickup-view/emeqlctgsspickup-view.vue'),
                },
                {
                    path: 'emassets/:emasset?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emasset.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassets', parameterName: 'emasset' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetedit-view9-edit-mode/emassetedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/closeddetailgridview/:closeddetailgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.closeddetailgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'closeddetailgridview', parameterName: 'closeddetailgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-closed-detail-grid-view/empodetail-closed-detail-grid-view.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqspare.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqspareedit-view-edit-mode/emeqspareedit-view-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emservice.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emservice-tab-exp-view/emservice-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-grid-view/emitemrinpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrins/:emitemrin?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-grid-view/emitemrinpickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-grid-view/emitemrinpickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrins/:emitemrin?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-grid-view/emitemrinpickup-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrins/:emitemrin?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-grid-view/emitemrinpickup-grid-view.vue'),
                },
                {
                    path: 'emitemrins/:emitemrin?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emitemrin.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitemrinpickup-grid-view/emitemrinpickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqkeeps/:emeqkeep?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqkeep.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqkeep-grid-view/emeqkeep-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqkeeps/:emeqkeep?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqkeep.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqkeep-grid-view/emeqkeep-grid-view.vue'),
                },
                {
                    path: 'emeqkeeps/:emeqkeep?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqkeep.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-act/emeqkeep-grid-view/emeqkeep-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/issuedgridview/:issuedgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.issuedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'issuedgridview', parameterName: 'issuedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-issued-grid-view/emitem-puse-issued-grid-view.vue'),
                },
                {
                    path: 'emeqkprcds/:emeqkprcd?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqkprcd.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqkprcds', parameterName: 'emeqkprcd' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqkprcdgrid-view/emeqkprcdgrid-view.vue'),
                },
                {
                    path: 'empos/:empo?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.empo.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empogrid-view/empogrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'emplans/:emplan?/emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'emplancdts/:emplancdt?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emplancdt.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplancdts', parameterName: 'emplancdt' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplancdtgrid-view/emplancdtgrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_ens/:emwo_en?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_en.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-enwoview-edit-view/emwo-enwoview-edit-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_ens/:emwo_en?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_en.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-enwoview-edit-view/emwo-enwoview-edit-view.vue'),
                },
                {
                    path: 'emwo_ens/:emwo_en?/wovieweditview/:wovieweditview?',
                    meta: {
                        caption: 'entities.emwo_en.views.wovieweditview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'wovieweditview', parameterName: 'wovieweditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwo-enwoview-edit-view/emwo-enwoview-edit-view.vue'),
                },
                {
                    path: 'emeqmps/:emeqmp?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emeqmp.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmps', parameterName: 'emeqmp' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmppickup-view/emeqmppickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.pfteam.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-pf/pfteam-pickup-grid-view/pfteam-pickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emen.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenedit-view9-edit-mode/emenedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emen/:emen?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emen.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenedit-view9-edit-mode/emenedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emen.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenedit-view9-edit-mode/emenedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emen/:emen?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emen.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenedit-view9-edit-mode/emenedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emen/:emen?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emen.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenedit-view9-edit-mode/emenedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emen/:emen?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emen.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenedit-view9-edit-mode/emenedit-view9-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emequip.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequippickup-view/emequippickup-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emequip.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequippickup-view/emequippickup-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/dashboardview9/:dashboardview9?',
                    meta: {
                        caption: 'entities.emequip.views.dashboardview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'dashboardview9', parameterName: 'dashboardview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-dashboard-view9/emequip-dashboard-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/dashboardview9/:dashboardview9?',
                    meta: {
                        caption: 'entities.emequip.views.dashboardview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'dashboardview9', parameterName: 'dashboardview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-dashboard-view9/emequip-dashboard-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-draft-grid-view/emitem-prtn-draft-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemprtns/:emitemprtn?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-draft-grid-view/emitem-prtn-draft-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-draft-grid-view/emitem-prtn-draft-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemprtns/:emitemprtn?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-draft-grid-view/emitem-prtn-draft-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemprtns/:emitemprtn?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-draft-grid-view/emitem-prtn-draft-grid-view.vue'),
                },
                {
                    path: 'emitemprtns/:emitemprtn?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-draft-grid-view/emitem-prtn-draft-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emplantempl.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-templ-edit-view-edit-mode/emplan-templ-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emplantempl.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-templ-edit-view-edit-mode/emplan-templ-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emplantempl.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-templ-edit-view-edit-mode/emplan-templ-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emplantempl.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-plan/emplan-templ-edit-view-edit-mode/emplan-templ-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emassets/:emasset?/emassetclears/:emassetclear?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emassetclear.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassets', parameterName: 'emasset' },
                            { pathName: 'emassetclears', parameterName: 'emassetclear' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetcleargrid-view/emassetcleargrid-view.vue'),
                },
                {
                    path: 'emassetclears/:emassetclear?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emassetclear.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclears', parameterName: 'emassetclear' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetcleargrid-view/emassetcleargrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/waitpogridview/:waitpogridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitpogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitpogridview', parameterName: 'waitpogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-po-grid-view/emwplist-wait-po-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/waitpogridview/:waitpogridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitpogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitpogridview', parameterName: 'waitpogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-po-grid-view/emwplist-wait-po-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/waitpogridview/:waitpogridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitpogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitpogridview', parameterName: 'waitpogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-po-grid-view/emwplist-wait-po-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/waitpogridview/:waitpogridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitpogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitpogridview', parameterName: 'waitpogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-po-grid-view/emwplist-wait-po-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/waitpogridview/:waitpogridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitpogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitpogridview', parameterName: 'waitpogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-po-grid-view/emwplist-wait-po-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/waitpogridview/:waitpogridview?',
                    meta: {
                        caption: 'entities.emwplist.views.waitpogridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'waitpogridview', parameterName: 'waitpogridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-wait-po-grid-view/emwplist-wait-po-grid-view.vue'),
                },
                {
                    path: 'emassetclasses/:emassetclass?/editview/:editview?',
                    meta: {
                        caption: 'entities.emassetclass.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclasses', parameterName: 'emassetclass' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclassedit-view/emassetclassedit-view.vue'),
                },
                {
                    path: 'emeqlctgsses/:emeqlctgss?/gridview_cqyj/:gridview_cqyj?',
                    meta: {
                        caption: 'entities.emeqlctgss.views.gridview_cqyj.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlctgsses', parameterName: 'emeqlctgss' },
                            { pathName: 'gridview_cqyj', parameterName: 'gridview_cqyj' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-yj/emeqlctgssgrid-view-cqyj/emeqlctgssgrid-view-cqyj.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.empodetail.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-grid-view9/empodetail-grid-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emequip.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-tab-exp-view/emequip-tab-exp-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emequip.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-tab-exp-view/emequip-tab-exp-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/emrfocas/:emrfoca?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfoca.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfocaedit-view/emrfocaedit-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/emrfocas/:emrfoca?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfoca.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfocaedit-view/emrfocaedit-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfocas/:emrfoca?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfoca.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfocaedit-view/emrfocaedit-view.vue'),
                },
                {
                    path: 'emrfocas/:emrfoca?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfoca.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfocaedit-view/emrfocaedit-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_dps/:emwo_dp?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_dp.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-dpedit-view-edit-mode/emwo-dpedit-view-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emwo_dps/:emwo_dp?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_dp.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-dpedit-view-edit-mode/emwo-dpedit-view-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_dps/:emwo_dp?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_dp.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-dpedit-view-edit-mode/emwo-dpedit-view-edit-mode.vue'),
                },
                {
                    path: 'emwo_dps/:emwo_dp?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_dp.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-dpedit-view-edit-mode/emwo-dpedit-view-edit-mode.vue'),
                },
                {
                    path: 'emitempls/:emitempl?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitempl.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempls', parameterName: 'emitempl' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-pltab-exp-view/emitem-pltab-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwos/:emwo?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwo.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwopickup-view/emwopickup-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwos/:emwo?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwo.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwopickup-view/emwopickup-view.vue'),
                },
                {
                    path: 'emwos/:emwo?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emwo.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwopickup-view/emwopickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemrinedit-view9-edit-mode/emitemrinedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrins/:emitemrin?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemrinedit-view9-edit-mode/emitemrinedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrins/:emitemrin?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemrinedit-view9-edit-mode/emitemrinedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrins/:emitemrin?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemrinedit-view9-edit-mode/emitemrinedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrins/:emitemrin?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemrinedit-view9-edit-mode/emitemrinedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitemrins/:emitemrin?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitemrin.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrins', parameterName: 'emitemrin' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemrinedit-view9-edit-mode/emitemrinedit-view9-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwos/:emwo?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwogrid-view/emwogrid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwos/:emwo?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwogrid-view/emwogrid-view.vue'),
                },
                {
                    path: 'emwos/:emwo?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwos', parameterName: 'emwo' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwogrid-view/emwogrid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emequip.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-option-view/emequip-option-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emequip.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-option-view/emequip-option-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitem.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-tab-exp-view/emitem-tab-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitem.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-tab-exp-view/emitem-tab-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitem.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-tab-exp-view/emitem-tab-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitem.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-tab-exp-view/emitem-tab-exp-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.emitem.views.tabexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-tab-exp-view/emitem-tab-exp-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/emrfoacs/:emrfoac?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfoac.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfoacgrid-view/emrfoacgrid-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/emrfoacs/:emrfoac?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfoac.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfoacgrid-view/emrfoacgrid-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfoacs/:emrfoac?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfoac.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfoacgrid-view/emrfoacgrid-view.vue'),
                },
                {
                    path: 'emrfoacs/:emrfoac?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfoac.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfoacgrid-view/emrfoacgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.empodetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/empodetailedit-view/empodetailedit-view.vue'),
                },
                {
                    path: 'emitemcs/:emitemcs?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemcs.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemcs', parameterName: 'emitemcs' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-csto-confirm-grid-view/emitem-csto-confirm-grid-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfomos/:emrfomo?/emrfocas/:emrfoca?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfoca.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfocagrid-view/emrfocagrid-view.vue'),
                },
                {
                    path: 'emrfomos/:emrfomo?/emrfocas/:emrfoca?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfoca.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfomos', parameterName: 'emrfomo' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfocagrid-view/emrfocagrid-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfocas/:emrfoca?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfoca.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfocagrid-view/emrfocagrid-view.vue'),
                },
                {
                    path: 'emrfocas/:emrfoca?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emrfoca.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfocas', parameterName: 'emrfoca' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-rfo/emrfocagrid-view/emrfocagrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.empodetail.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetailpickup-view/empodetailpickup-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emeqtype.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqtypepickup-view/emeqtypepickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutgrid-view/emitemroutgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemrouts/:emitemrout?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutgrid-view/emitemroutgrid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemrouts/:emitemrout?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutgrid-view/emitemroutgrid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemrouts/:emitemrout?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutgrid-view/emitemroutgrid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemrouts/:emitemrout?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutgrid-view/emitemroutgrid-view.vue'),
                },
                {
                    path: 'emitemrouts/:emitemrout?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emitemrout.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemroutgrid-view/emitemroutgrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'empos/:empo?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'empodetails/:empodetail?/waitcheckgridview/:waitcheckgridview?',
                    meta: {
                        caption: 'entities.empodetail.views.waitcheckgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empodetails', parameterName: 'empodetail' },
                            { pathName: 'waitcheckgridview', parameterName: 'waitcheckgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/empodetail-wait-check-grid-view/empodetail-wait-check-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplantempls/:emplantempl?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplantempls/:emplantempl?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplantempls/:emplantempl?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'emplantempls/:emplantempl?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplantempls', parameterName: 'emplantempl' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'emacclasses/:emacclass?/emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emacclasses', parameterName: 'emacclass' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'emplans/:emplan?/equipgridview9/:equipgridview9?',
                    meta: {
                        caption: 'entities.emplan.views.equipgridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emplans', parameterName: 'emplan' },
                            { pathName: 'equipgridview9', parameterName: 'equipgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emplan-equip-grid-view9/emplan-equip-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-grid-view/emwplistpickup-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-grid-view/emwplistpickup-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-grid-view/emwplistpickup-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-grid-view/emwplistpickup-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-grid-view/emwplistpickup-grid-view.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwplist.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplistpickup-grid-view/emwplistpickup-grid-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/emrfodemaps/:emrfodemap?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfodemap.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'emrfodemaps', parameterName: 'emrfodemap' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfodemap-edit-view/emrfodemap-edit-view.vue'),
                },
                {
                    path: 'emrfodemaps/:emrfodemap?/editview/:editview?',
                    meta: {
                        caption: 'entities.emrfodemap.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodemaps', parameterName: 'emrfodemap' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfodemap-edit-view/emrfodemap-edit-view.vue'),
                },
                {
                    path: 'emeqmps/:emeqmp?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emeqmp.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqmps', parameterName: 'emeqmp' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqmppickup-grid-view/emeqmppickup-grid-view.vue'),
                },
                {
                    path: 'emeqlcttires/:emeqlcttires?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emeqlcttires.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlcttires', parameterName: 'emeqlcttires' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlcttirespickup-grid-view/emeqlcttirespickup-grid-view.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/emeqsparemaps/:emeqsparemap?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparemap.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'emeqsparemaps', parameterName: 'emeqsparemap' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqspare-map-edit-view-edit-mode/emeqspare-map-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emeqsparemaps/:emeqsparemap?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emeqsparemap.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsparemaps', parameterName: 'emeqsparemap' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqspare-map-edit-view-edit-mode/emeqspare-map-edit-view-edit-mode.vue'),
                },
                {
                    path: 'emitemtypes/:emitemtype?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emitemtype.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitemtypepickup-view/emitemtypepickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emitem.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-option-view/emitem-option-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emitem.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-option-view/emitem-option-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emitem.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-option-view/emitem-option-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emitem.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-option-view/emitem-option-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.emitem.views.optionview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-option-view/emitem-option-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/storeinfoview/:storeinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.storeinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'storeinfoview', parameterName: 'storeinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-store-info-view/emitem-store-info-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/storeinfoview/:storeinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.storeinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'storeinfoview', parameterName: 'storeinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-store-info-view/emitem-store-info-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/storeinfoview/:storeinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.storeinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'storeinfoview', parameterName: 'storeinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-store-info-view/emitem-store-info-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/storeinfoview/:storeinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.storeinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'storeinfoview', parameterName: 'storeinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-store-info-view/emitem-store-info-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/storeinfoview/:storeinfoview?',
                    meta: {
                        caption: 'entities.emitem.views.storeinfoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'storeinfoview', parameterName: 'storeinfoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-store-info-view/emitem-store-info-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emeqtype.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqtypepickup-grid-view/emeqtypepickup-grid-view.vue'),
                },
                {
                    path: 'emeqlocations/:emeqlocation?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqlocation.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlocations', parameterName: 'emeqlocation' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqlocation-grid-view/emeqlocation-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emen/:emen?/emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'emen/:emen?/emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'emenconsums/:emenconsum?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emenconsum.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emenconsums', parameterName: 'emenconsum' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenconsum-grid-view/emenconsum-grid-view.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/emeqsparemaps/:emeqsparemap?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparemap.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'emeqsparemaps', parameterName: 'emeqsparemap' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparemapedit-view/emeqsparemapedit-view.vue'),
                },
                {
                    path: 'emeqsparemaps/:emeqsparemap?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparemap.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsparemaps', parameterName: 'emeqsparemap' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparemapedit-view/emeqsparemapedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emstore.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstore-tree-exp-view/emstore-tree-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emitempuse.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitempuseedit-view9-edit-mode/emitempuseedit-view9-edit-mode.vue'),
                },
                {
                    path: 'emeqlctmaps/:emeqlctmap?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emeqlctmap.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlctmaps', parameterName: 'emeqlctmap' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlctmap-grid-view9/emeqlctmap-grid-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emeqkeeps/:emeqkeep?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqkeep.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqkeep-cal-edit-view9/emeqkeep-cal-edit-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/emeqkeeps/:emeqkeep?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqkeep.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqkeep-cal-edit-view9/emeqkeep-cal-edit-view9.vue'),
                },
                {
                    path: 'emeqkeeps/:emeqkeep?/caleditview9/:caleditview9?',
                    meta: {
                        caption: 'entities.emeqkeep.views.caleditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                            { pathName: 'caleditview9', parameterName: 'caleditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqkeep-cal-edit-view9/emeqkeep-cal-edit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emequip.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-edit-view9/emequip-edit-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/editview9/:editview9?',
                    meta: {
                        caption: 'entities.emequip.views.editview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'editview9', parameterName: 'editview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-edit-view9/emequip-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-edit-view9-edit-mode/emwplist-edit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-edit-view9-edit-mode/emwplist-edit-view9-edit-mode.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-edit-view9-edit-mode/emwplist-edit-view9-edit-mode.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-edit-view9-edit-mode/emwplist-edit-view9-edit-mode.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-edit-view9-edit-mode/emwplist-edit-view9-edit-mode.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/editview9_editmode/:editview9_editmode?',
                    meta: {
                        caption: 'entities.emwplist.views.editview9_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'editview9_editmode', parameterName: 'editview9_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wp/emwplist-edit-view9-edit-mode/emwplist-edit-view9-edit-mode.vue'),
                },
                {
                    path: 'emeqlctmaps/:emeqlctmap?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqlctmap.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqlctmaps', parameterName: 'emeqlctmap' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqlctmap-edit-view/emeqlctmap-edit-view.vue'),
                },
                {
                    path: 'emdrwgs/:emdrwg?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emdrwg.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emdrwgs', parameterName: 'emdrwg' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emdrwgtree-exp-view/emdrwgtree-exp-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_ens/:emwo_en?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_en.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-engrid-view/emwo-engrid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_ens/:emwo_en?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_en.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-engrid-view/emwo-engrid-view.vue'),
                },
                {
                    path: 'emwo_ens/:emwo_en?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emwo_en.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-engrid-view/emwo-engrid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/draftgridview/:draftgridview?',
                    meta: {
                        caption: 'entities.emitempuse.views.draftgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'draftgridview', parameterName: 'draftgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-mat/emitem-puse-draft-grid-view/emitem-puse-draft-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'empurplans/:empurplan?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empurplans', parameterName: 'empurplan' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emequips/:emequip?/emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emitempuses/:emitempuse?/waitissueeditview9/:waitissueeditview9?',
                    meta: {
                        caption: 'entities.emitempuse.views.waitissueeditview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempuses', parameterName: 'emitempuse' },
                            { pathName: 'waitissueeditview9', parameterName: 'waitissueeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-puse-wait-issue-edit-view9/emitem-puse-wait-issue-edit-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view/emeqsparedetailedit-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view/emeqsparedetailedit-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view/emeqsparedetailedit-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view/emeqsparedetailedit-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emeqsparedetails/:emeqsparedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view/emeqsparedetailedit-view.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/emeqsparedetails/:emeqsparedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view/emeqsparedetailedit-view.vue'),
                },
                {
                    path: 'emeqsparedetails/:emeqsparedetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.emeqsparedetail.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqsparedetails', parameterName: 'emeqsparedetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparedetailedit-view/emeqsparedetailedit-view.vue'),
                },
                {
                    path: 'emwooris/:emwoori?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emwoori.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwooris', parameterName: 'emwoori' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwooripickup-grid-view/emwooripickup-grid-view.vue'),
                },
                {
                    path: 'emrfodes/:emrfode?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.emrfode.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emrfodes', parameterName: 'emrfode' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emrfodepickup-grid-view/emrfodepickup-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_inners/:emwo_inner?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_inner.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_inners', parameterName: 'emwo_inner' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-inneredit-view-edit-mode/emwo-inneredit-view-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_inners/:emwo_inner?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_inner.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_inners', parameterName: 'emwo_inner' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-inneredit-view-edit-mode/emwo-inneredit-view-edit-mode.vue'),
                },
                {
                    path: 'emwo_inners/:emwo_inner?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_inner.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_inners', parameterName: 'emwo_inner' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-inneredit-view-edit-mode/emwo-inneredit-view-edit-mode.vue'),
                },
                {
                    path: 'emeqspares/:emeqspare?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emeqspare.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqspares', parameterName: 'emeqspare' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-eq/emeqsparepickup-view/emeqsparepickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemtrades/:emitemtrade?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-trade-tree-exp-view/emitem-trade-tree-exp-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemtrades/:emitemtrade?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-trade-tree-exp-view/emitem-trade-tree-exp-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemtrades/:emitemtrade?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-trade-tree-exp-view/emitem-trade-tree-exp-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemtrades/:emitemtrade?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-trade-tree-exp-view/emitem-trade-tree-exp-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemtrades/:emitemtrade?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-trade-tree-exp-view/emitem-trade-tree-exp-view.vue'),
                },
                {
                    path: 'emitemtrades/:emitemtrade?/treeexpview/:treeexpview?',
                    meta: {
                        caption: 'entities.emitemtrade.views.treeexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemtrades', parameterName: 'emitemtrade' },
                            { pathName: 'treeexpview', parameterName: 'treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-trade-tree-exp-view/emitem-trade-tree-exp-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.emeqtype.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqtype-grid-view/emeqtype-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emen.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-view/emenpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emen/:emen?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emen.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-view/emenpickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emen/:emen?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emen.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-view/emenpickup-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emen/:emen?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emen.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-view/emenpickup-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emen/:emen?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emen.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-view/emenpickup-view.vue'),
                },
                {
                    path: 'emen/:emen?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emen.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emen', parameterName: 'emen' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-en/emenpickup-view/emenpickup-view.vue'),
                },
                {
                    path: 'emitempls/:emitempl?/confirmedgridview/:confirmedgridview?',
                    meta: {
                        caption: 'entities.emitempl.views.confirmedgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitempls', parameterName: 'emitempl' },
                            { pathName: 'confirmedgridview', parameterName: 'confirmedgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-plconfirmed-grid-view/emitem-plconfirmed-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstorepart.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstorepartpickup-view/emstorepartpickup-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.emstorepart.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emstorepartpickup-view/emstorepartpickup-view.vue'),
                },
                {
                    path: 'emeqtypes/:emeqtype?/pickuptreeview/:pickuptreeview?',
                    meta: {
                        caption: 'entities.emeqtype.views.pickuptreeview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                            { pathName: 'pickuptreeview', parameterName: 'pickuptreeview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emeqtype-pickup-tree-view/emeqtype-pickup-tree-view.vue'),
                },
                {
                    path: 'pfcontracts/:pfcontract?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.pfcontract.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfcontracts', parameterName: 'pfcontract' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-pf/pfcontractpickup-view/pfcontractpickup-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-to-confirm-grid-view/emitem-prtn-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emitemprtns/:emitemprtn?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-to-confirm-grid-view/emitem-prtn-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emitemprtns/:emitemprtn?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-to-confirm-grid-view/emitem-prtn-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emitemprtns/:emitemprtn?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-to-confirm-grid-view/emitem-prtn-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emitems/:emitem?/emitemprtns/:emitemprtn?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-to-confirm-grid-view/emitem-prtn-to-confirm-grid-view.vue'),
                },
                {
                    path: 'emitemprtns/:emitemprtn?/toconfirmgridview/:toconfirmgridview?',
                    meta: {
                        caption: 'entities.emitemprtn.views.toconfirmgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                            { pathName: 'toconfirmgridview', parameterName: 'toconfirmgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emitem-prtn-to-confirm-grid-view/emitem-prtn-to-confirm-grid-view.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/emwo_ens/:emwo_en?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_en.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-enedit-view-edit-mode/emwo-enedit-view-edit-mode.vue'),
                },
                {
                    path: 'emequips/:emequip?/emwo_ens/:emwo_en?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_en.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-enedit-view-edit-mode/emwo-enedit-view-edit-mode.vue'),
                },
                {
                    path: 'emwo_ens/:emwo_en?/editview_editmode/:editview_editmode?',
                    meta: {
                        caption: 'entities.emwo_en.views.editview_editmode.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                            { pathName: 'editview_editmode', parameterName: 'editview_editmode' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-wo/emwo-enedit-view-edit-mode/emwo-enedit-view-edit-mode.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplists/:emwplist?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emstores/:emstore?/emitems/:emitem?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstores', parameterName: 'emstore' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emstoreparts/:emstorepart?/emitems/:emitem?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emstoreparts', parameterName: 'emstorepart' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emitems/:emitem?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emwplists/:emwplist?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplists', parameterName: 'emwplist' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emservices/:emservice?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emservices', parameterName: 'emservice' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emitems/:emitem?/emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emitems', parameterName: 'emitem' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emwplistcosts/:emwplistcost?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.emwplistcost.views.gridview9.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emwplistcosts', parameterName: 'emwplistcost' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emwplist-cost-grid-view9/emwplist-cost-grid-view9.vue'),
                },
                {
                    path: 'emassets/:emasset?/emassetclears/:emassetclear?/editview_908/:editview_908?',
                    meta: {
                        caption: 'entities.emassetclear.views.editview_908.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassets', parameterName: 'emasset' },
                            { pathName: 'emassetclears', parameterName: 'emassetclear' },
                            { pathName: 'editview_908', parameterName: 'editview_908' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclearedit-view-908/emassetclearedit-view-908.vue'),
                },
                {
                    path: 'emassetclears/:emassetclear?/editview_908/:editview_908?',
                    meta: {
                        caption: 'entities.emassetclear.views.editview_908.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclears', parameterName: 'emassetclear' },
                            { pathName: 'editview_908', parameterName: 'editview_908' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclearedit-view-908/emassetclearedit-view-908.vue'),
                },
                {
                    path: 'pfteams/:pfteam?/emequips/:emequip?/runinfo/:runinfo?',
                    meta: {
                        caption: 'entities.emequip.views.runinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'pfteams', parameterName: 'pfteam' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'runinfo', parameterName: 'runinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-run-info/emequip-run-info.vue'),
                },
                {
                    path: 'emequips/:emequip?/runinfo/:runinfo?',
                    meta: {
                        caption: 'entities.emequip.views.runinfo.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emequips', parameterName: 'emequip' },
                            { pathName: 'runinfo', parameterName: 'runinfo' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-core/emequip-run-info/emequip-run-info.vue'),
                },
                {
                    path: 'emassetclasses/:emassetclass?/editview_4778/:editview_4778?',
                    meta: {
                        caption: 'entities.emassetclass.views.editview_4778.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'emassetclasses', parameterName: 'emassetclass' },
                            { pathName: 'editview_4778', parameterName: 'editview_4778' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/eam-as/emassetclassedit-view-4778/emassetclassedit-view-4778.vue'),
                },
                {
                    path: 'empos/:empo?/closedordergridview/:closedordergridview?',
                    meta: {
                        caption: 'entities.empo.views.closedordergridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindex', parameterName: 'appindex' },
                            { pathName: 'empos', parameterName: 'empo' },
                            { pathName: 'clos