import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 总帐科目服务对象基类
 *
 * @export
 * @class EMACClassServiceBase
 * @extends {EntityServie}
 */
export default class EMACClassServiceBase extends EntityService {

    /**
     * Creates an instance of  EMACClassServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMACClassServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMACClassServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emacclass';
        this.APPDEKEY = 'emacclassid';
        this.APPDENAME = 'emacclasses';
        this.APPDETEXT = 'emacclassname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/emacclasses/${context.emacclass}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emacclasses`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emacclasses/${context.emacclass}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/emacclasses/${context.emacclass}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/emacclasses/${context.emacclass}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/emacclasses/getdraft`,isloading);
        res.data.emacclass = data.emacclass;
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/emacclasses/${context.emacclass}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emacclasses/${context.emacclass}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMACClassServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emacclasses/fetchdefault`,tempData,isloading);
    }
}