import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 资产服务对象基类
 *
 * @export
 * @class EMAssetServiceBase
 * @extends {EntityServie}
 */
export default class EMAssetServiceBase extends EntityService {

    /**
     * Creates an instance of  EMAssetServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMAssetServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMAssetServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emasset';
        this.APPDEKEY = 'emassetid';
        this.APPDENAME = 'emassets';
        this.APPDETEXT = 'emassetname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/emassets/${context.emasset}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emassetclearsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emassetclears'),'undefined')){
            emassetclearsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emassetclears') as any);
            if(emassetclearsData && emassetclearsData.length && emassetclearsData.length > 0){
                emassetclearsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emassetclearid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emassetclears = emassetclearsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emassets`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emassetclears',JSON.stringify(res.data.emassetclears));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emassetclearsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emassetclears'),'undefined')){
            emassetclearsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emassetclears') as any);
            if(emassetclearsData && emassetclearsData.length && emassetclearsData.length > 0){
                emassetclearsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emassetclearid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emassetclears = emassetclearsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emassets/${context.emasset}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emassetclears',JSON.stringify(res.data.emassetclears));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/emassets/${context.emasset}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/emassets/${context.emasset}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emassetclears',JSON.stringify(res.data.emassetclears));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/emassets/getdraft`,isloading);
        res.data.emasset = data.emasset;
            this.tempStorage.setItem(context.srfsessionkey+'_emassetclears',JSON.stringify(res.data.emassetclears));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/emassets/${context.emasset}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emassetclearsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emassetclears'),'undefined')){
            emassetclearsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emassetclears') as any);
            if(emassetclearsData && emassetclearsData.length && emassetclearsData.length > 0){
                emassetclearsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emassetclearid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emassetclears = emassetclearsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emassets/${context.emasset}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emassetclears',JSON.stringify(res.data.emassetclears));
            return res;
    }

    /**
     * FetchAssetBf接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async FetchAssetBf(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emassets/fetchassetbf`,tempData,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMAssetServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emassets/fetchdefault`,tempData,isloading);
    }
}