import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 能源服务对象基类
 *
 * @export
 * @class EMENServiceBase
 * @extends {EntityServie}
 */
export default class EMENServiceBase extends EntityService {

    /**
     * Creates an instance of  EMENServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMENServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMENServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emen';
        this.APPDEKEY = 'emenid';
        this.APPDENAME = 'emen';
        this.APPDETEXT = 'emenname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emen){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}/select`,isloading);
        }
        if(context.emstore && context.emitem && context.emen){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emen/${context.emen}/select`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emen){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}/select`,isloading);
        }
        if(context.emservice && context.emitem && context.emen){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emen/${context.emen}/select`,isloading);
        }
        if(context.emitem && context.emen){
            return Http.getInstance().get(`/emitems/${context.emitem}/emen/${context.emen}/select`,isloading);
        }
            return Http.getInstance().get(`/emen/${context.emen}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstore && context.emitem && true){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emen`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emservice && context.emitem && true){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emen`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emitem && true){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emen`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emen`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstore && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emitems/${context.emitem}/emen/${context.emen}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emservice && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emservices/${context.emservice}/emitems/${context.emitem}/emen/${context.emen}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emitems/${context.emitem}/emen/${context.emen}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emen/${context.emen}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emen){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}`,isloading);
        }
        if(context.emstore && context.emitem && context.emen){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitems/${context.emitem}/emen/${context.emen}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emen){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}`,isloading);
        }
        if(context.emservice && context.emitem && context.emen){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitems/${context.emitem}/emen/${context.emen}`,isloading);
        }
        if(context.emitem && context.emen){
            return Http.getInstance().delete(`/emitems/${context.emitem}/emen/${context.emen}`,isloading);
        }
            return Http.getInstance().delete(`/emen/${context.emen}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emen){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstore && context.emitem && context.emen){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emen/${context.emen}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emen){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emservice && context.emitem && context.emen){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emen/${context.emen}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emitem && context.emen){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emen/${context.emen}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
            let res:any = await Http.getInstance().get(`/emen/${context.emen}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/getdraft`,isloading);
            res.data.emen = data.emen;
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstore && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emen/getdraft`,isloading);
            res.data.emen = data.emen;
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/getdraft`,isloading);
            res.data.emen = data.emen;
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emservice && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emen/getdraft`,isloading);
            res.data.emen = data.emen;
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emitem && true){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emen/getdraft`,isloading);
            res.data.emen = data.emen;
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emen/getdraft`,isloading);
        res.data.emen = data.emen;
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstore && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emen/${context.emen}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emservice && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emen/${context.emen}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emen/${context.emen}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
            return Http.getInstance().post(`/emen/${context.emen}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstore && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emen/${context.emen}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/${context.emen}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emservice && context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emen/${context.emen}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        if(context.emitem && context.emen){
            let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emen/${context.emen}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
        }
        let masterData:any = {};
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emen/${context.emen}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMENServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emen/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emen/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emen/fetchdefault`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emen/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emen/fetchdefault`,tempData,isloading);
    }
}