import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 维修记录服务对象基类
 *
 * @export
 * @class EMEQCheckServiceBase
 * @extends {EntityServie}
 */
export default class EMEQCheckServiceBase extends EntityService {

    /**
     * Creates an instance of  EMEQCheckServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMEQCheckServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMEQCheckServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emeqcheck';
        this.APPDEKEY = 'emeqcheckid';
        this.APPDENAME = 'emeqchecks';
        this.APPDETEXT = 'emeqcheckname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && context.emeqcheck){
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}/select`,isloading);
        }
        if(context.emequip && context.emeqcheck){
            return Http.getInstance().get(`/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}/select`,isloading);
        }
            return Http.getInstance().get(`/emeqchecks/${context.emeqcheck}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks`,data,isloading);
            return res;
        }
        if(context.emequip && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emeqchecks`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emeqchecks`,data,isloading);
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && context.emeqcheck){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}`,data,isloading);
            return res;
        }
        if(context.emequip && context.emeqcheck){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emeqchecks/${context.emeqcheck}`,data,isloading);
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && context.emeqcheck){
            return Http.getInstance().delete(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}`,isloading);
        }
        if(context.emequip && context.emeqcheck){
            return Http.getInstance().delete(`/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}`,isloading);
        }
            return Http.getInstance().delete(`/emeqchecks/${context.emeqcheck}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && context.emeqcheck){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}`,isloading);
            return res;
        }
        if(context.emequip && context.emeqcheck){
            let res:any = await Http.getInstance().get(`/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}`,isloading);
            return res;
        }
            let res:any = await Http.getInstance().get(`/emeqchecks/${context.emeqcheck}`,isloading);
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && true){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/getdraft`,isloading);
            res.data.emeqcheck = data.emeqcheck;
            return res;
        }
        if(context.emequip && true){
            let res:any = await Http.getInstance().get(`/emequips/${context.emequip}/emeqchecks/getdraft`,isloading);
            res.data.emeqcheck = data.emeqcheck;
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emeqchecks/getdraft`,isloading);
        res.data.emeqcheck = data.emeqcheck;
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && context.emeqcheck){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}/checkkey`,data,isloading);
            return res;
        }
        if(context.emequip && context.emeqcheck){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}/checkkey`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emeqchecks/${context.emeqcheck}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && context.emeqcheck){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}/save`,data,isloading);
            return res;
        }
        if(context.emequip && context.emeqcheck){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emeqchecks/${context.emeqcheck}/save`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emeqchecks/${context.emeqcheck}/save`,data,isloading);
            return res;
    }

    /**
     * FetchCalendar接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async FetchCalendar(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/fetchcalendar`,tempData,isloading);
        }
        if(context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emequips/${context.emequip}/emeqchecks/fetchcalendar`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emeqchecks/fetchcalendar`,tempData,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQCheckServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emeqchecks/fetchdefault`,tempData,isloading);
        }
        if(context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emequips/${context.emequip}/emeqchecks/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emeqchecks/fetchdefault`,tempData,isloading);
    }
}