import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 备件包服务对象基类
 *
 * @export
 * @class EMEQSpareServiceBase
 * @extends {EntityServie}
 */
export default class EMEQSpareServiceBase extends EntityService {

    /**
     * Creates an instance of  EMEQSpareServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMEQSpareServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMEQSpareServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emeqspare';
        this.APPDEKEY = 'emeqspareid';
        this.APPDENAME = 'emeqspares';
        this.APPDETEXT = 'emeqsparename';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/emeqspares/${context.emeqspare}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emeqsparemapsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparemaps'),'undefined')){
            emeqsparemapsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparemaps') as any);
            if(emeqsparemapsData && emeqsparemapsData.length && emeqsparemapsData.length > 0){
                emeqsparemapsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparemapid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparemaps = emeqsparemapsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emeqspares`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsparemaps',JSON.stringify(res.data.emeqsparemaps));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emeqsparemapsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparemaps'),'undefined')){
            emeqsparemapsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparemaps') as any);
            if(emeqsparemapsData && emeqsparemapsData.length && emeqsparemapsData.length > 0){
                emeqsparemapsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparemapid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparemaps = emeqsparemapsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emeqspares/${context.emeqspare}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparemaps',JSON.stringify(res.data.emeqsparemaps));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/emeqspares/${context.emeqspare}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/emeqspares/${context.emeqspare}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparemaps',JSON.stringify(res.data.emeqsparemaps));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/emeqspares/getdraft`,isloading);
        res.data.emeqspare = data.emeqspare;
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparemaps',JSON.stringify(res.data.emeqsparemaps));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/emeqspares/${context.emeqspare}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emeqsparemapsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparemaps'),'undefined')){
            emeqsparemapsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparemaps') as any);
            if(emeqsparemapsData && emeqsparemapsData.length && emeqsparemapsData.length > 0){
                emeqsparemapsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparemapid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparemaps = emeqsparemapsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emeqspares/${context.emeqspare}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparemaps',JSON.stringify(res.data.emeqsparemaps));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEQSpareServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emeqspares/fetchdefault`,tempData,isloading);
    }
}