import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 设备档案服务对象基类
 *
 * @export
 * @class EMEquipServiceBase
 * @extends {EntityServie}
 */
export default class EMEquipServiceBase extends EntityService {

    /**
     * Creates an instance of  EMEquipServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMEquipServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMEquipServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emequip';
        this.APPDEKEY = 'emequipid';
        this.APPDENAME = 'emequips';
        this.APPDETEXT = 'emequipname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emequips/fetchdefault`,tempData,isloading);
    }

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip){
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/select`,isloading);
        }
            return Http.getInstance().get(`/emequips/${context.emequip}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && true){
            let masterData:any = {};
        let emeqahsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs'),'undefined')){
            emeqahsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs') as any);
            if(emeqahsData && emeqahsData.length && emeqahsData.length > 0){
                emeqahsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqahid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqahs = emeqahsData;
        let emeqwlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls'),'undefined')){
            emeqwlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls') as any);
            if(emeqwlsData && emeqwlsData.length && emeqwlsData.length > 0){
                emeqwlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqwlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqwls = emeqwlsData;
        let emwo_oscsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs'),'undefined')){
            emwo_oscsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs') as any);
            if(emwo_oscsData && emwo_oscsData.length && emwo_oscsData.length > 0){
                emwo_oscsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_oscid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_oscs = emwo_oscsData;
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        let emeqchecksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks'),'undefined')){
            emeqchecksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks') as any);
            if(emeqchecksData && emeqchecksData.length && emeqchecksData.length > 0){
                emeqchecksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqcheckid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqchecks = emeqchecksData;
        let emwo_innersData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners'),'undefined')){
            emwo_innersData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners') as any);
            if(emwo_innersData && emwo_innersData.length && emwo_innersData.length > 0){
                emwo_innersData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_innerid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_inners = emwo_innersData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emwo_ensData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens'),'undefined')){
            emwo_ensData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens') as any);
            if(emwo_ensData && emwo_ensData.length && emwo_ensData.length > 0){
                emwo_ensData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_enid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_ens = emwo_ensData;
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emappliesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emapplies'),'undefined')){
            emappliesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emapplies') as any);
            if(emappliesData && emappliesData.length && emappliesData.length > 0){
                emappliesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emapplyid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emapplies = emappliesData;
        let emwosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwos'),'undefined')){
            emwosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwos') as any);
            if(emwosData && emwosData.length && emwosData.length > 0){
                emwosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwos = emwosData;
        let emeqmaintancesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances'),'undefined')){
            emeqmaintancesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances') as any);
            if(emeqmaintancesData && emeqmaintancesData.length && emeqmaintancesData.length > 0){
                emeqmaintancesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqmaintanceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqmaintances = emeqmaintancesData;
        let emeqdebugsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs'),'undefined')){
            emeqdebugsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs') as any);
            if(emeqdebugsData && emeqdebugsData.length && emeqdebugsData.length > 0){
                emeqdebugsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqdebugid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqdebugs = emeqdebugsData;
        let emeqkeepsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps'),'undefined')){
            emeqkeepsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps') as any);
            if(emeqkeepsData && emeqkeepsData.length && emeqkeepsData.length > 0){
                emeqkeepsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqkeepid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqkeeps = emeqkeepsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emeqsetupsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups'),'undefined')){
            emeqsetupsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups') as any);
            if(emeqsetupsData && emeqsetupsData.length && emeqsetupsData.length > 0){
                emeqsetupsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsetupid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsetups = emeqsetupsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
        }
        let masterData:any = {};
        let emeqahsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs'),'undefined')){
            emeqahsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs') as any);
            if(emeqahsData && emeqahsData.length && emeqahsData.length > 0){
                emeqahsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqahid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqahs = emeqahsData;
        let emeqwlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls'),'undefined')){
            emeqwlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls') as any);
            if(emeqwlsData && emeqwlsData.length && emeqwlsData.length > 0){
                emeqwlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqwlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqwls = emeqwlsData;
        let emwo_oscsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs'),'undefined')){
            emwo_oscsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs') as any);
            if(emwo_oscsData && emwo_oscsData.length && emwo_oscsData.length > 0){
                emwo_oscsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_oscid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_oscs = emwo_oscsData;
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        let emeqchecksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks'),'undefined')){
            emeqchecksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks') as any);
            if(emeqchecksData && emeqchecksData.length && emeqchecksData.length > 0){
                emeqchecksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqcheckid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqchecks = emeqchecksData;
        let emwo_innersData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners'),'undefined')){
            emwo_innersData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners') as any);
            if(emwo_innersData && emwo_innersData.length && emwo_innersData.length > 0){
                emwo_innersData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_innerid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_inners = emwo_innersData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emwo_ensData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens'),'undefined')){
            emwo_ensData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens') as any);
            if(emwo_ensData && emwo_ensData.length && emwo_ensData.length > 0){
                emwo_ensData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_enid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_ens = emwo_ensData;
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emappliesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emapplies'),'undefined')){
            emappliesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emapplies') as any);
            if(emappliesData && emappliesData.length && emappliesData.length > 0){
                emappliesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emapplyid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emapplies = emappliesData;
        let emwosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwos'),'undefined')){
            emwosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwos') as any);
            if(emwosData && emwosData.length && emwosData.length > 0){
                emwosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwos = emwosData;
        let emeqmaintancesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances'),'undefined')){
            emeqmaintancesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances') as any);
            if(emeqmaintancesData && emeqmaintancesData.length && emeqmaintancesData.length > 0){
                emeqmaintancesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqmaintanceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqmaintances = emeqmaintancesData;
        let emeqdebugsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs'),'undefined')){
            emeqdebugsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs') as any);
            if(emeqdebugsData && emeqdebugsData.length && emeqdebugsData.length > 0){
                emeqdebugsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqdebugid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqdebugs = emeqdebugsData;
        let emeqkeepsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps'),'undefined')){
            emeqkeepsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps') as any);
            if(emeqkeepsData && emeqkeepsData.length && emeqkeepsData.length > 0){
                emeqkeepsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqkeepid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqkeeps = emeqkeepsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emeqsetupsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups'),'undefined')){
            emeqsetupsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups') as any);
            if(emeqsetupsData && emeqsetupsData.length && emeqsetupsData.length > 0){
                emeqsetupsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsetupid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsetups = emeqsetupsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emequips`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip){
            let masterData:any = {};
        let emeqahsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs'),'undefined')){
            emeqahsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs') as any);
            if(emeqahsData && emeqahsData.length && emeqahsData.length > 0){
                emeqahsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqahid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqahs = emeqahsData;
        let emeqwlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls'),'undefined')){
            emeqwlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls') as any);
            if(emeqwlsData && emeqwlsData.length && emeqwlsData.length > 0){
                emeqwlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqwlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqwls = emeqwlsData;
        let emwo_oscsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs'),'undefined')){
            emwo_oscsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs') as any);
            if(emwo_oscsData && emwo_oscsData.length && emwo_oscsData.length > 0){
                emwo_oscsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_oscid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_oscs = emwo_oscsData;
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        let emeqchecksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks'),'undefined')){
            emeqchecksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks') as any);
            if(emeqchecksData && emeqchecksData.length && emeqchecksData.length > 0){
                emeqchecksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqcheckid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqchecks = emeqchecksData;
        let emwo_innersData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners'),'undefined')){
            emwo_innersData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners') as any);
            if(emwo_innersData && emwo_innersData.length && emwo_innersData.length > 0){
                emwo_innersData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_innerid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_inners = emwo_innersData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emwo_ensData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens'),'undefined')){
            emwo_ensData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens') as any);
            if(emwo_ensData && emwo_ensData.length && emwo_ensData.length > 0){
                emwo_ensData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_enid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_ens = emwo_ensData;
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emappliesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emapplies'),'undefined')){
            emappliesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emapplies') as any);
            if(emappliesData && emappliesData.length && emappliesData.length > 0){
                emappliesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emapplyid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emapplies = emappliesData;
        let emwosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwos'),'undefined')){
            emwosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwos') as any);
            if(emwosData && emwosData.length && emwosData.length > 0){
                emwosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwos = emwosData;
        let emeqmaintancesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances'),'undefined')){
            emeqmaintancesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances') as any);
            if(emeqmaintancesData && emeqmaintancesData.length && emeqmaintancesData.length > 0){
                emeqmaintancesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqmaintanceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqmaintances = emeqmaintancesData;
        let emeqdebugsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs'),'undefined')){
            emeqdebugsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs') as any);
            if(emeqdebugsData && emeqdebugsData.length && emeqdebugsData.length > 0){
                emeqdebugsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqdebugid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqdebugs = emeqdebugsData;
        let emeqkeepsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps'),'undefined')){
            emeqkeepsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps') as any);
            if(emeqkeepsData && emeqkeepsData.length && emeqkeepsData.length > 0){
                emeqkeepsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqkeepid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqkeeps = emeqkeepsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emeqsetupsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups'),'undefined')){
            emeqsetupsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups') as any);
            if(emeqsetupsData && emeqsetupsData.length && emeqsetupsData.length > 0){
                emeqsetupsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsetupid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsetups = emeqsetupsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/pfteams/${context.pfteam}/emequips/${context.emequip}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
        }
        let masterData:any = {};
        let emeqahsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs'),'undefined')){
            emeqahsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs') as any);
            if(emeqahsData && emeqahsData.length && emeqahsData.length > 0){
                emeqahsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqahid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqahs = emeqahsData;
        let emeqwlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls'),'undefined')){
            emeqwlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls') as any);
            if(emeqwlsData && emeqwlsData.length && emeqwlsData.length > 0){
                emeqwlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqwlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqwls = emeqwlsData;
        let emwo_oscsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs'),'undefined')){
            emwo_oscsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs') as any);
            if(emwo_oscsData && emwo_oscsData.length && emwo_oscsData.length > 0){
                emwo_oscsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_oscid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_oscs = emwo_oscsData;
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        let emeqchecksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks'),'undefined')){
            emeqchecksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks') as any);
            if(emeqchecksData && emeqchecksData.length && emeqchecksData.length > 0){
                emeqchecksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqcheckid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqchecks = emeqchecksData;
        let emwo_innersData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners'),'undefined')){
            emwo_innersData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners') as any);
            if(emwo_innersData && emwo_innersData.length && emwo_innersData.length > 0){
                emwo_innersData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_innerid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_inners = emwo_innersData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emwo_ensData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens'),'undefined')){
            emwo_ensData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens') as any);
            if(emwo_ensData && emwo_ensData.length && emwo_ensData.length > 0){
                emwo_ensData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_enid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_ens = emwo_ensData;
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emappliesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emapplies'),'undefined')){
            emappliesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emapplies') as any);
            if(emappliesData && emappliesData.length && emappliesData.length > 0){
                emappliesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emapplyid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emapplies = emappliesData;
        let emwosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwos'),'undefined')){
            emwosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwos') as any);
            if(emwosData && emwosData.length && emwosData.length > 0){
                emwosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwos = emwosData;
        let emeqmaintancesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances'),'undefined')){
            emeqmaintancesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances') as any);
            if(emeqmaintancesData && emeqmaintancesData.length && emeqmaintancesData.length > 0){
                emeqmaintancesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqmaintanceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqmaintances = emeqmaintancesData;
        let emeqdebugsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs'),'undefined')){
            emeqdebugsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs') as any);
            if(emeqdebugsData && emeqdebugsData.length && emeqdebugsData.length > 0){
                emeqdebugsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqdebugid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqdebugs = emeqdebugsData;
        let emeqkeepsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps'),'undefined')){
            emeqkeepsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps') as any);
            if(emeqkeepsData && emeqkeepsData.length && emeqkeepsData.length > 0){
                emeqkeepsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqkeepid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqkeeps = emeqkeepsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emeqsetupsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups'),'undefined')){
            emeqsetupsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups') as any);
            if(emeqsetupsData && emeqsetupsData.length && emeqsetupsData.length > 0){
                emeqsetupsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsetupid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsetups = emeqsetupsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emequips/${context.emequip}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip){
            return Http.getInstance().delete(`/pfteams/${context.pfteam}/emequips/${context.emequip}`,isloading);
        }
            return Http.getInstance().delete(`/emequips/${context.emequip}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
        }
            let res:any = await Http.getInstance().get(`/emequips/${context.emequip}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && true){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/getdraft`,isloading);
            res.data.emequip = data.emequip;
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emequips/getdraft`,isloading);
        res.data.emequip = data.emequip;
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip){
            let masterData:any = {};
        let emeqahsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs'),'undefined')){
            emeqahsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs') as any);
            if(emeqahsData && emeqahsData.length && emeqahsData.length > 0){
                emeqahsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqahid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqahs = emeqahsData;
        let emeqwlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls'),'undefined')){
            emeqwlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls') as any);
            if(emeqwlsData && emeqwlsData.length && emeqwlsData.length > 0){
                emeqwlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqwlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqwls = emeqwlsData;
        let emwo_oscsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs'),'undefined')){
            emwo_oscsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs') as any);
            if(emwo_oscsData && emwo_oscsData.length && emwo_oscsData.length > 0){
                emwo_oscsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_oscid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_oscs = emwo_oscsData;
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        let emeqchecksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks'),'undefined')){
            emeqchecksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks') as any);
            if(emeqchecksData && emeqchecksData.length && emeqchecksData.length > 0){
                emeqchecksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqcheckid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqchecks = emeqchecksData;
        let emwo_innersData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners'),'undefined')){
            emwo_innersData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners') as any);
            if(emwo_innersData && emwo_innersData.length && emwo_innersData.length > 0){
                emwo_innersData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_innerid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_inners = emwo_innersData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emwo_ensData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens'),'undefined')){
            emwo_ensData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens') as any);
            if(emwo_ensData && emwo_ensData.length && emwo_ensData.length > 0){
                emwo_ensData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_enid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_ens = emwo_ensData;
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emappliesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emapplies'),'undefined')){
            emappliesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emapplies') as any);
            if(emappliesData && emappliesData.length && emappliesData.length > 0){
                emappliesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emapplyid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emapplies = emappliesData;
        let emwosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwos'),'undefined')){
            emwosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwos') as any);
            if(emwosData && emwosData.length && emwosData.length > 0){
                emwosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwos = emwosData;
        let emeqmaintancesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances'),'undefined')){
            emeqmaintancesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances') as any);
            if(emeqmaintancesData && emeqmaintancesData.length && emeqmaintancesData.length > 0){
                emeqmaintancesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqmaintanceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqmaintances = emeqmaintancesData;
        let emeqdebugsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs'),'undefined')){
            emeqdebugsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs') as any);
            if(emeqdebugsData && emeqdebugsData.length && emeqdebugsData.length > 0){
                emeqdebugsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqdebugid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqdebugs = emeqdebugsData;
        let emeqkeepsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps'),'undefined')){
            emeqkeepsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps') as any);
            if(emeqkeepsData && emeqkeepsData.length && emeqkeepsData.length > 0){
                emeqkeepsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqkeepid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqkeeps = emeqkeepsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emeqsetupsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups'),'undefined')){
            emeqsetupsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups') as any);
            if(emeqsetupsData && emeqsetupsData.length && emeqsetupsData.length > 0){
                emeqsetupsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsetupid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsetups = emeqsetupsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
        }
            return Http.getInstance().post(`/emequips/${context.emequip}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emequip){
            let masterData:any = {};
        let emeqahsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs'),'undefined')){
            emeqahsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs') as any);
            if(emeqahsData && emeqahsData.length && emeqahsData.length > 0){
                emeqahsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqahid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqahs = emeqahsData;
        let emeqwlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls'),'undefined')){
            emeqwlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls') as any);
            if(emeqwlsData && emeqwlsData.length && emeqwlsData.length > 0){
                emeqwlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqwlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqwls = emeqwlsData;
        let emwo_oscsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs'),'undefined')){
            emwo_oscsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs') as any);
            if(emwo_oscsData && emwo_oscsData.length && emwo_oscsData.length > 0){
                emwo_oscsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_oscid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_oscs = emwo_oscsData;
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        let emeqchecksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks'),'undefined')){
            emeqchecksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks') as any);
            if(emeqchecksData && emeqchecksData.length && emeqchecksData.length > 0){
                emeqchecksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqcheckid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqchecks = emeqchecksData;
        let emwo_innersData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners'),'undefined')){
            emwo_innersData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners') as any);
            if(emwo_innersData && emwo_innersData.length && emwo_innersData.length > 0){
                emwo_innersData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_innerid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_inners = emwo_innersData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emwo_ensData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens'),'undefined')){
            emwo_ensData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens') as any);
            if(emwo_ensData && emwo_ensData.length && emwo_ensData.length > 0){
                emwo_ensData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_enid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_ens = emwo_ensData;
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emappliesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emapplies'),'undefined')){
            emappliesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emapplies') as any);
            if(emappliesData && emappliesData.length && emappliesData.length > 0){
                emappliesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emapplyid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emapplies = emappliesData;
        let emwosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwos'),'undefined')){
            emwosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwos') as any);
            if(emwosData && emwosData.length && emwosData.length > 0){
                emwosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwos = emwosData;
        let emeqmaintancesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances'),'undefined')){
            emeqmaintancesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances') as any);
            if(emeqmaintancesData && emeqmaintancesData.length && emeqmaintancesData.length > 0){
                emeqmaintancesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqmaintanceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqmaintances = emeqmaintancesData;
        let emeqdebugsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs'),'undefined')){
            emeqdebugsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs') as any);
            if(emeqdebugsData && emeqdebugsData.length && emeqdebugsData.length > 0){
                emeqdebugsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqdebugid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqdebugs = emeqdebugsData;
        let emeqkeepsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps'),'undefined')){
            emeqkeepsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps') as any);
            if(emeqkeepsData && emeqkeepsData.length && emeqkeepsData.length > 0){
                emeqkeepsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqkeepid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqkeeps = emeqkeepsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emeqsetupsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups'),'undefined')){
            emeqsetupsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups') as any);
            if(emeqsetupsData && emeqsetupsData.length && emeqsetupsData.length > 0){
                emeqsetupsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsetupid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsetups = emeqsetupsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
        }
        let masterData:any = {};
        let emeqahsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs'),'undefined')){
            emeqahsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqahs') as any);
            if(emeqahsData && emeqahsData.length && emeqahsData.length > 0){
                emeqahsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqahid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqahs = emeqahsData;
        let emeqwlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls'),'undefined')){
            emeqwlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqwls') as any);
            if(emeqwlsData && emeqwlsData.length && emeqwlsData.length > 0){
                emeqwlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqwlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqwls = emeqwlsData;
        let emwo_oscsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs'),'undefined')){
            emwo_oscsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_oscs') as any);
            if(emwo_oscsData && emwo_oscsData.length && emwo_oscsData.length > 0){
                emwo_oscsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_oscid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_oscs = emwo_oscsData;
        let emenconsumsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums'),'undefined')){
            emenconsumsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emenconsums') as any);
            if(emenconsumsData && emenconsumsData.length && emenconsumsData.length > 0){
                emenconsumsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenconsumid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emenconsums = emenconsumsData;
        let emeqchecksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks'),'undefined')){
            emeqchecksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqchecks') as any);
            if(emeqchecksData && emeqchecksData.length && emeqchecksData.length > 0){
                emeqchecksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqcheckid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqchecks = emeqchecksData;
        let emwo_innersData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners'),'undefined')){
            emwo_innersData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_inners') as any);
            if(emwo_innersData && emwo_innersData.length && emwo_innersData.length > 0){
                emwo_innersData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_innerid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_inners = emwo_innersData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emwo_ensData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens'),'undefined')){
            emwo_ensData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_ens') as any);
            if(emwo_ensData && emwo_ensData.length && emwo_ensData.length > 0){
                emwo_ensData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_enid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_ens = emwo_ensData;
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emappliesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emapplies'),'undefined')){
            emappliesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emapplies') as any);
            if(emappliesData && emappliesData.length && emappliesData.length > 0){
                emappliesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emapplyid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emapplies = emappliesData;
        let emwosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwos'),'undefined')){
            emwosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwos') as any);
            if(emwosData && emwosData.length && emwosData.length > 0){
                emwosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwos = emwosData;
        let emeqmaintancesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances'),'undefined')){
            emeqmaintancesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqmaintances') as any);
            if(emeqmaintancesData && emeqmaintancesData.length && emeqmaintancesData.length > 0){
                emeqmaintancesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqmaintanceid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqmaintances = emeqmaintancesData;
        let emeqdebugsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs'),'undefined')){
            emeqdebugsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqdebugs') as any);
            if(emeqdebugsData && emeqdebugsData.length && emeqdebugsData.length > 0){
                emeqdebugsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqdebugid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqdebugs = emeqdebugsData;
        let emeqkeepsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps'),'undefined')){
            emeqkeepsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqkeeps') as any);
            if(emeqkeepsData && emeqkeepsData.length && emeqkeepsData.length > 0){
                emeqkeepsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqkeepid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqkeeps = emeqkeepsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emeqsetupsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups'),'undefined')){
            emeqsetupsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsetups') as any);
            if(emeqsetupsData && emeqsetupsData.length && emeqsetupsData.length > 0){
                emeqsetupsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsetupid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsetups = emeqsetupsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emequips/${context.emequip}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emeqahs',JSON.stringify(res.data.emeqahs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqwls',JSON.stringify(res.data.emeqwls));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_oscs',JSON.stringify(res.data.emwo_oscs));
            this.tempStorage.setItem(context.srfsessionkey+'_emenconsums',JSON.stringify(res.data.emenconsums));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqchecks',JSON.stringify(res.data.emeqchecks));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_inners',JSON.stringify(res.data.emwo_inners));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_ens',JSON.stringify(res.data.emwo_ens));
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emapplies',JSON.stringify(res.data.emapplies));
            this.tempStorage.setItem(context.srfsessionkey+'_emwos',JSON.stringify(res.data.emwos));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqmaintances',JSON.stringify(res.data.emeqmaintances));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqdebugs',JSON.stringify(res.data.emeqdebugs));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqkeeps',JSON.stringify(res.data.emeqkeeps));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsetups',JSON.stringify(res.data.emeqsetups));
            return res;
    }

    /**
     * FetchEQTypeTree接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async FetchEQTypeTree(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/fetcheqtypetree`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emequips/fetcheqtypetree`,tempData,isloading);
    }

    /**
     * FetchTypeEQNum接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMEquipServiceBase
     */
    public async FetchTypeEQNum(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/fetchtypeeqnum`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emequips/fetchtypeeqnum`,tempData,isloading);
    }
}