import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 还料单服务对象基类
 *
 * @export
 * @class EMItemPRtnServiceBase
 * @extends {EntityServie}
 */
export default class EMItemPRtnServiceBase extends EntityService {

    /**
     * Creates an instance of  EMItemPRtnServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMItemPRtnServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMItemPRtnServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emitemprtn';
        this.APPDEKEY = 'emitemprtnid';
        this.APPDENAME = 'emitemprtns';
        this.APPDETEXT = 'emitemprtnname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemprtn){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/select`,isloading);
        }
        if(context.emstore && context.emitem && context.emitemprtn){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/select`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemprtn){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/select`,isloading);
        }
        if(context.emservice && context.emitem && context.emitemprtn){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/select`,isloading);
        }
        if(context.emitem && context.emitemprtn){
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/select`,isloading);
        }
            return Http.getInstance().get(`/emitemprtns/${context.emitemprtn}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns`,data,isloading);
            return res;
        }
        if(context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitemprtns`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emitemprtns`,data,isloading);
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emitemprtns/${context.emitemprtn}`,data,isloading);
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemprtn){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
        }
        if(context.emstore && context.emitem && context.emitemprtn){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemprtn){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
        }
        if(context.emservice && context.emitem && context.emitemprtn){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
        }
        if(context.emitem && context.emitemprtn){
            return Http.getInstance().delete(`/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
        }
            return Http.getInstance().delete(`/emitemprtns/${context.emitemprtn}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemprtn){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemprtn){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemprtn){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemprtn){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
            return res;
        }
        if(context.emitem && context.emitemprtn){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}`,isloading);
            return res;
        }
            let res:any = await Http.getInstance().get(`/emitemprtns/${context.emitemprtn}`,isloading);
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/getdraft`,isloading);
            res.data.emitemprtn = data.emitemprtn;
            return res;
        }
        if(context.emstore && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/getdraft`,isloading);
            res.data.emitemprtn = data.emitemprtn;
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/getdraft`,isloading);
            res.data.emitemprtn = data.emitemprtn;
            return res;
        }
        if(context.emservice && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/getdraft`,isloading);
            res.data.emitemprtn = data.emitemprtn;
            return res;
        }
        if(context.emitem && true){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emitemprtns/getdraft`,isloading);
            res.data.emitemprtn = data.emitemprtn;
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emitemprtns/getdraft`,isloading);
        res.data.emitemprtn = data.emitemprtn;
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/checkkey`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/checkkey`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/checkkey`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emitemprtns/${context.emitemprtn}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/save`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/save`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/save`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/save`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitemprtn){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitemprtns/${context.emitemprtn}/save`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emitemprtns/${context.emitemprtn}/save`,data,isloading);
            return res;
    }

    /**
     * FetchConfirmed接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async FetchConfirmed(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/fetchconfirmed`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/fetchconfirmed`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/fetchconfirmed`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/fetchconfirmed`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemprtns/fetchconfirmed`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitemprtns/fetchconfirmed`,tempData,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/fetchdefault`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemprtns/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitemprtns/fetchdefault`,tempData,isloading);
    }

    /**
     * FetchDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async FetchDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/fetchdraft`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/fetchdraft`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/fetchdraft`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/fetchdraft`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemprtns/fetchdraft`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitemprtns/fetchdraft`,tempData,isloading);
    }

    /**
     * FetchToConfirm接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPRtnServiceBase
     */
    public async FetchToConfirm(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/fetchtoconfirm`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemprtns/fetchtoconfirm`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemprtns/fetchtoconfirm`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemprtns/fetchtoconfirm`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemprtns/fetchtoconfirm`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitemprtns/fetchtoconfirm`,tempData,isloading);
    }
}