import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 领料单服务对象基类
 *
 * @export
 * @class EMItemPUseServiceBase
 * @extends {EntityServie}
 */
export default class EMItemPUseServiceBase extends EntityService {

    /**
     * Creates an instance of  EMItemPUseServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMItemPUseServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMItemPUseServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emitempuse';
        this.APPDEKEY = 'emitempuseid';
        this.APPDENAME = 'emitempuses';
        this.APPDETEXT = 'emitempusename';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emstore && context.emitem && context.emitempuse){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emservice && context.emitem && context.emitempuse){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.pfteam && context.emitempuse){
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emstore && context.emitempuse){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emstorepart && context.emitempuse){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emservice && context.emitempuse){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.empurplan && context.emitempuse){
            return Http.getInstance().get(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emitem && context.emitempuse){
            return Http.getInstance().get(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}/select`,isloading);
        }
        if(context.emequip && context.emitempuse){
            return Http.getInstance().get(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}/select`,isloading);
        }
            return Http.getInstance().get(`/emitempuses/${context.emitempuse}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emstore && context.emstorepart && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emequip && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses`,data,isloading);
            return res;
        }
        if(context.pfteam && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emstore && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emstorepart && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emservice && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitempuses`,data,isloading);
            return res;
        }
        if(context.empurplan && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/empurplans/${context.empurplan}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitempuses`,data,isloading);
            return res;
        }
        if(context.emequip && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emitempuses`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emitempuses`,data,isloading);
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.empurplan && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        if(context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emitempuses/${context.emitempuse}`,data,isloading);
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emstore && context.emitem && context.emitempuse){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emservice && context.emitem && context.emitempuse){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            return Http.getInstance().delete(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.pfteam && context.emitempuse){
            return Http.getInstance().delete(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emstore && context.emitempuse){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emstorepart && context.emitempuse){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emservice && context.emitempuse){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.empurplan && context.emitempuse){
            return Http.getInstance().delete(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emitem && context.emitempuse){
            return Http.getInstance().delete(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
        }
        if(context.emequip && context.emitempuse){
            return Http.getInstance().delete(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}`,isloading);
        }
            return Http.getInstance().delete(`/emitempuses/${context.emitempuse}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.pfteam && context.emitempuse){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emstore && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emstorepart && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emservice && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.empurplan && context.emitempuse){
            let res:any = await Http.getInstance().get(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emitem && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
        if(context.emequip && context.emitempuse){
            let res:any = await Http.getInstance().get(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}`,isloading);
            return res;
        }
            let res:any = await Http.getInstance().get(`/emitempuses/${context.emitempuse}`,isloading);
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emstore && context.emstorepart && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emstore && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emservice && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.pfteam && context.emequip && true){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.pfteam && true){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emstore && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emstorepart && true){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emservice && true){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.empurplan && true){
            let res:any = await Http.getInstance().get(`/empurplans/${context.empurplan}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emitem && true){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        if(context.emequip && true){
            let res:any = await Http.getInstance().get(`/emequips/${context.emequip}/emitempuses/getdraft`,isloading);
            res.data.emitempuse = data.emitempuse;
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emitempuses/getdraft`,isloading);
        res.data.emitempuse = data.emitempuse;
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.empurplan && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
        if(context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emitempuses/${context.emitempuse}/checkkey`,data,isloading);
    }

    /**
     * GenId接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async GenId(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.empurplan && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
        if(context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}/genid`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emitempuses/${context.emitempuse}/genid`,data,isloading);
    }

    /**
     * Issue接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async Issue(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.empurplan && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
        if(context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}/issue`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emitempuses/${context.emitempuse}/issue`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.empurplan && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        if(context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emitempuses/${context.emitempuse}/save`,data,isloading);
            return res;
    }

    /**
     * Submit接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async Submit(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emstore && context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.pfteam && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.empurplan && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/empurplans/${context.empurplan}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
        if(context.emequip && context.emitempuse){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emequips/${context.emequip}/emitempuses/${context.emitempuse}/submit`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emitempuses/${context.emitempuse}/submit`,data,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.pfteam && context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.pfteam && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.empurplan && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/empurplans/${context.empurplan}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitempuses/fetchdefault`,tempData,isloading);
        }
        if(context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emequips/${context.emequip}/emitempuses/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitempuses/fetchdefault`,tempData,isloading);
    }

    /**
     * FetchDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async FetchDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emstore && context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.pfteam && context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.pfteam && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emstore && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.empurplan && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/empurplans/${context.empurplan}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitempuses/fetchdraft`,tempData,isloading);
        }
        if(context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emequips/${context.emequip}/emitempuses/fetchdraft`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitempuses/fetchdraft`,tempData,isloading);
    }

    /**
     * FetchIssued接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async FetchIssued(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emstore && context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.pfteam && context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.pfteam && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emstore && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.empurplan && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/empurplans/${context.empurplan}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitempuses/fetchissued`,tempData,isloading);
        }
        if(context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emequips/${context.emequip}/emitempuses/fetchissued`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitempuses/fetchissued`,tempData,isloading);
    }

    /**
     * FetchWaitIssue接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemPUseServiceBase
     */
    public async FetchWaitIssue(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emstore && context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.pfteam && context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emequips/${context.emequip}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.pfteam && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emstore && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.empurplan && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/empurplans/${context.empurplan}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        if(context.emequip && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emequips/${context.emequip}/emitempuses/fetchwaitissue`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitempuses/fetchwaitissue`,tempData,isloading);
    }
}