import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 入库单服务对象基类
 *
 * @export
 * @class EMItemRInServiceBase
 * @extends {EntityServie}
 */
export default class EMItemRInServiceBase extends EntityService {

    /**
     * Creates an instance of  EMItemRInServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMItemRInServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMItemRInServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emitemrin';
        this.APPDEKEY = 'emitemrinid';
        this.APPDENAME = 'emitemrins';
        this.APPDETEXT = 'emitemrinname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrin){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/select`,isloading);
        }
        if(context.emstore && context.emitem && context.emitemrin){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/select`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemrin){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/select`,isloading);
        }
        if(context.emservice && context.emitem && context.emitemrin){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/select`,isloading);
        }
        if(context.emitem && context.emitemrin){
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemrins/${context.emitemrin}/select`,isloading);
        }
            return Http.getInstance().get(`/emitemrins/${context.emitemrin}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins`,data,isloading);
            return res;
        }
        if(context.emitem && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitemrins`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emitemrins`,data,isloading);
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emitemrins/${context.emitemrin}`,data,isloading);
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrin){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
        }
        if(context.emstore && context.emitem && context.emitemrin){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emitemrin){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
        }
        if(context.emservice && context.emitem && context.emitemrin){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
        }
        if(context.emitem && context.emitemrin){
            return Http.getInstance().delete(`/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
        }
            return Http.getInstance().delete(`/emitemrins/${context.emitemrin}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrin){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemrin){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemrin){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemrin){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
            return res;
        }
        if(context.emitem && context.emitemrin){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emitemrins/${context.emitemrin}`,isloading);
            return res;
        }
            let res:any = await Http.getInstance().get(`/emitemrins/${context.emitemrin}`,isloading);
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/getdraft`,isloading);
            res.data.emitemrin = data.emitemrin;
            return res;
        }
        if(context.emstore && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/getdraft`,isloading);
            res.data.emitemrin = data.emitemrin;
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/getdraft`,isloading);
            res.data.emitemrin = data.emitemrin;
            return res;
        }
        if(context.emservice && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/getdraft`,isloading);
            res.data.emitemrin = data.emitemrin;
            return res;
        }
        if(context.emitem && true){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emitemrins/getdraft`,isloading);
            res.data.emitemrin = data.emitemrin;
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emitemrins/getdraft`,isloading);
        res.data.emitemrin = data.emitemrin;
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/checkkey`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/checkkey`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/checkkey`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitemrins/${context.emitemrin}/checkkey`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emitemrins/${context.emitemrin}/checkkey`,data,isloading);
    }

    /**
     * Confirm接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async Confirm(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/confirm`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/confirm`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/confirm`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/confirm`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitemrins/${context.emitemrin}/confirm`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emitemrins/${context.emitemrin}/confirm`,data,isloading);
    }

    /**
     * GenId接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async GenId(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/genid`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/genid`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/genid`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/genid`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitemrins/${context.emitemrin}/genid`,data,isloading);
            return res;
        }
            return Http.getInstance().post(`/emitemrins/${context.emitemrin}/genid`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/save`,data,isloading);
            return res;
        }
        if(context.emstore && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/save`,data,isloading);
            return res;
        }
        if(context.emstorepart && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/save`,data,isloading);
            return res;
        }
        if(context.emservice && context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/${context.emitemrin}/save`,data,isloading);
            return res;
        }
        if(context.emitem && context.emitemrin){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emitemrins/${context.emitemrin}/save`,data,isloading);
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emitemrins/${context.emitemrin}/save`,data,isloading);
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/fetchdefault`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemrins/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitemrins/fetchdefault`,tempData,isloading);
    }

    /**
     * FetchPutIn接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async FetchPutIn(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/fetchputin`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/fetchputin`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/fetchputin`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/fetchputin`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemrins/fetchputin`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitemrins/fetchputin`,tempData,isloading);
    }

    /**
     * FetchWaitIn接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemRInServiceBase
     */
    public async FetchWaitIn(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/fetchwaitin`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emitemrins/fetchwaitin`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emitemrins/fetchwaitin`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emitemrins/fetchwaitin`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emitemrins/fetchwaitin`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitemrins/fetchwaitin`,tempData,isloading);
    }
}