import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 物品服务对象基类
 *
 * @export
 * @class EMItemServiceBase
 * @extends {EntityServie}
 */
export default class EMItemServiceBase extends EntityService {

    /**
     * Creates an instance of  EMItemServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMItemServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMItemServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emitem';
        this.APPDEKEY = 'emitemid';
        this.APPDENAME = 'emitems';
        this.APPDETEXT = 'emitemname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/select`,isloading);
        }
        if(context.emstore && context.emitem){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/select`,isloading);
        }
        if(context.emstorepart && context.emitem){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/select`,isloading);
        }
        if(context.emservice && context.emitem){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/select`,isloading);
        }
            return Http.getInstance().get(`/emitems/${context.emitem}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && true){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstore && true){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstorepart && true){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emservice && true){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emitems`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstore && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emitems/${context.emitem}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstorepart && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emservice && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emservices/${context.emservice}/emitems/${context.emitem}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emitems/${context.emitem}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}`,isloading);
        }
        if(context.emstore && context.emitem){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitems/${context.emitem}`,isloading);
        }
        if(context.emstorepart && context.emitem){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}`,isloading);
        }
        if(context.emservice && context.emitem){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitems/${context.emitem}`,isloading);
        }
            return Http.getInstance().delete(`/emitems/${context.emitem}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstore && context.emitem){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstorepart && context.emitem){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emservice && context.emitem){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/getdraft`,isloading);
            res.data.emitem = data.emitem;
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstore && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/getdraft`,isloading);
            res.data.emitem = data.emitem;
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstorepart && true){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/getdraft`,isloading);
            res.data.emitem = data.emitem;
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emservice && true){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/getdraft`,isloading);
            res.data.emitem = data.emitem;
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emitems/getdraft`,isloading);
        res.data.emitem = data.emitem;
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstore && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstorepart && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emservice && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
            return Http.getInstance().post(`/emitems/${context.emitem}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstore && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emstorepart && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        if(context.emservice && context.emitem){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
        }
        let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        let emitemroutsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts'),'undefined')){
            emitemroutsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrouts') as any);
            if(emitemroutsData && emitemroutsData.length && emitemroutsData.length > 0){
                emitemroutsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemroutid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrouts = emitemroutsData;
        let emitemprtnsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns'),'undefined')){
            emitemprtnsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemprtns') as any);
            if(emitemprtnsData && emitemprtnsData.length && emitemprtnsData.length > 0){
                emitemprtnsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemprtnid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemprtns = emitemprtnsData;
        let emeqsparedetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails'),'undefined')){
            emeqsparedetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emeqsparedetails') as any);
            if(emeqsparedetailsData && emeqsparedetailsData.length && emeqsparedetailsData.length > 0){
                emeqsparedetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emeqsparedetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emeqsparedetails = emeqsparedetailsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emenData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emen'),'undefined')){
            emenData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emen') as any);
            if(emenData && emenData.length && emenData.length > 0){
                emenData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emenid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emen = emenData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemtradesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades'),'undefined')){
            emitemtradesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemtrades') as any);
            if(emitemtradesData && emitemtradesData.length && emitemtradesData.length > 0){
                emitemtradesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemtradeid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemtrades = emitemtradesData;
        let emwplistsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplists'),'undefined')){
            emwplistsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplists') as any);
            if(emwplistsData && emwplistsData.length && emwplistsData.length > 0){
                emwplistsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplists = emwplistsData;
        let emitemrinsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins'),'undefined')){
            emitemrinsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitemrins') as any);
            if(emitemrinsData && emitemrinsData.length && emitemrinsData.length > 0){
                emitemrinsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemrinid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitemrins = emitemrinsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emitems/${context.emitem}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrouts',JSON.stringify(res.data.emitemrouts));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemprtns',JSON.stringify(res.data.emitemprtns));
            this.tempStorage.setItem(context.srfsessionkey+'_emeqsparedetails',JSON.stringify(res.data.emeqsparedetails));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emen',JSON.stringify(res.data.emen));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemtrades',JSON.stringify(res.data.emitemtrades));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplists',JSON.stringify(res.data.emwplists));
            this.tempStorage.setItem(context.srfsessionkey+'_emitemrins',JSON.stringify(res.data.emitemrins));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitems/fetchdefault`,tempData,isloading);
    }

    /**
     * FetchItemTypeTree接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMItemServiceBase
     */
    public async FetchItemTypeTree(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/fetchitemtypetree`,tempData,isloading);
        }
        if(context.emstore && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/fetchitemtypetree`,tempData,isloading);
        }
        if(context.emstorepart && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/fetchitemtypetree`,tempData,isloading);
        }
        if(context.emservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/fetchitemtypetree`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emitems/fetchitemtypetree`,tempData,isloading);
    }
}