import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 能力服务对象基类
 *
 * @export
 * @class EMOutputServiceBase
 * @extends {EntityServie}
 */
export default class EMOutputServiceBase extends EntityService {

    /**
     * Creates an instance of  EMOutputServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMOutputServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMOutputServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emoutput';
        this.APPDEKEY = 'emoutputid';
        this.APPDENAME = 'emoutputs';
        this.APPDETEXT = 'emoutputname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/emoutputs/${context.emoutput}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emoutputrctsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emoutputrcts'),'undefined')){
            emoutputrctsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emoutputrcts') as any);
            if(emoutputrctsData && emoutputrctsData.length && emoutputrctsData.length > 0){
                emoutputrctsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emoutputrctid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emoutputrcts = emoutputrctsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emoutputs`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emoutputrcts',JSON.stringify(res.data.emoutputrcts));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emoutputrctsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emoutputrcts'),'undefined')){
            emoutputrctsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emoutputrcts') as any);
            if(emoutputrctsData && emoutputrctsData.length && emoutputrctsData.length > 0){
                emoutputrctsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emoutputrctid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emoutputrcts = emoutputrctsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emoutputs/${context.emoutput}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emoutputrcts',JSON.stringify(res.data.emoutputrcts));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/emoutputs/${context.emoutput}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/emoutputs/${context.emoutput}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emoutputrcts',JSON.stringify(res.data.emoutputrcts));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/emoutputs/getdraft`,isloading);
        res.data.emoutput = data.emoutput;
            this.tempStorage.setItem(context.srfsessionkey+'_emoutputrcts',JSON.stringify(res.data.emoutputrcts));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/emoutputs/${context.emoutput}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emoutputrctsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emoutputrcts'),'undefined')){
            emoutputrctsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emoutputrcts') as any);
            if(emoutputrctsData && emoutputrctsData.length && emoutputrctsData.length > 0){
                emoutputrctsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emoutputrctid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emoutputrcts = emoutputrctsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emoutputs/${context.emoutput}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emoutputrcts',JSON.stringify(res.data.emoutputrcts));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMOutputServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emoutputs/fetchdefault`,tempData,isloading);
    }
}