import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 计划模板服务对象基类
 *
 * @export
 * @class EMPlanTemplServiceBase
 * @extends {EntityServie}
 */
export default class EMPlanTemplServiceBase extends EntityService {

    /**
     * Creates an instance of  EMPlanTemplServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMPlanTemplServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMPlanTemplServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emplantempl';
        this.APPDEKEY = 'emplantemplid';
        this.APPDENAME = 'emplantempls';
        this.APPDETEXT = 'emplantemplname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emplantempl){
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emplantempls/${context.emplantempl}/select`,isloading);
        }
        if(context.emservice && context.emplantempl){
            return Http.getInstance().get(`/emservices/${context.emservice}/emplantempls/${context.emplantempl}/select`,isloading);
        }
        if(context.emacclass && context.emplantempl){
            return Http.getInstance().get(`/emacclasses/${context.emacclass}/emplantempls/${context.emplantempl}/select`,isloading);
        }
            return Http.getInstance().get(`/emplantempls/${context.emplantempl}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && true){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emplantempls`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emservice && true){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emplantempls`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emacclass && true){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emacclasses/${context.emacclass}/emplantempls`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emplantempls`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/pfteams/${context.pfteam}/emplantempls/${context.emplantempl}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emservice && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emservices/${context.emservice}/emplantempls/${context.emplantempl}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emacclass && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emacclasses/${context.emacclass}/emplantempls/${context.emplantempl}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emplantempls/${context.emplantempl}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emplantempl){
            return Http.getInstance().delete(`/pfteams/${context.pfteam}/emplantempls/${context.emplantempl}`,isloading);
        }
        if(context.emservice && context.emplantempl){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emplantempls/${context.emplantempl}`,isloading);
        }
        if(context.emacclass && context.emplantempl){
            return Http.getInstance().delete(`/emacclasses/${context.emacclass}/emplantempls/${context.emplantempl}`,isloading);
        }
            return Http.getInstance().delete(`/emplantempls/${context.emplantempl}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emplantempl){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emplantempls/${context.emplantempl}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emservice && context.emplantempl){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emplantempls/${context.emplantempl}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emacclass && context.emplantempl){
            let res:any = await Http.getInstance().get(`/emacclasses/${context.emacclass}/emplantempls/${context.emplantempl}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
            let res:any = await Http.getInstance().get(`/emplantempls/${context.emplantempl}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && true){
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}/emplantempls/getdraft`,isloading);
            res.data.emplantempl = data.emplantempl;
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emservice && true){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emplantempls/getdraft`,isloading);
            res.data.emplantempl = data.emplantempl;
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emacclass && true){
            let res:any = await Http.getInstance().get(`/emacclasses/${context.emacclass}/emplantempls/getdraft`,isloading);
            res.data.emplantempl = data.emplantempl;
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emplantempls/getdraft`,isloading);
        res.data.emplantempl = data.emplantempl;
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emplantempls/${context.emplantempl}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emservice && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emplantempls/${context.emplantempl}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emacclass && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emacclasses/${context.emacclass}/emplantempls/${context.emplantempl}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
            return Http.getInstance().post(`/emplantempls/${context.emplantempl}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/pfteams/${context.pfteam}/emplantempls/${context.emplantempl}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emservice && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emplantempls/${context.emplantempl}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        if(context.emacclass && context.emplantempl){
            let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emacclasses/${context.emacclass}/emplantempls/${context.emplantempl}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
        }
        let masterData:any = {};
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emplantempls/${context.emplantempl}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPlanTemplServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.pfteam && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/pfteams/${context.pfteam}/emplantempls/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emplantempls/fetchdefault`,tempData,isloading);
        }
        if(context.emacclass && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emacclasses/${context.emacclass}/emplantempls/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emplantempls/fetchdefault`,tempData,isloading);
    }
}