import { Http,Util } from '@/utils';
import EntityService from '../entity-service';
import GenIdLogic from '@/service/empo/gen-id-logic';



/**
 * 订单服务对象基类
 *
 * @export
 * @class EMPOServiceBase
 * @extends {EntityServie}
 */
export default class EMPOServiceBase extends EntityService {

    /**
     * Creates an instance of  EMPOServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMPOServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMPOServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='empo';
        this.APPDEKEY = 'empoid';
        this.APPDENAME = 'empos';
        this.APPDETEXT = 'emponame';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/empos/${context.empo}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/empos`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/empos/${context.empo}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/empos/${context.empo}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/empos/${context.empo}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/empos/getdraft`,isloading);
        res.data.empo = data.empo;
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
        return res;
    }

    /**
     * Arrival接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async Arrival(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/empos/${context.empo}/arrival`,data,isloading);
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/empos/${context.empo}/checkkey`,data,isloading);
    }

    /**
     * GenId接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async GenId(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/empos/${context.empo}/genid`,data,isloading);
    }

    /**
     * PlaceOrder接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async PlaceOrder(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/empos/${context.empo}/placeorder`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/empos/${context.empo}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
    }

    /**
     * FetchClosedOrder接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async FetchClosedOrder(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/empos/fetchclosedorder`,tempData,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/empos/fetchdefault`,tempData,isloading);
    }

    /**
     * FetchOnOrder接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async FetchOnOrder(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/empos/fetchonorder`,tempData,isloading);
    }

    /**
     * FetchPlaceOrder接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPOServiceBase
     */
    public async FetchPlaceOrder(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/empos/fetchplaceorder`,tempData,isloading);
    }
}