import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 计划修理服务对象基类
 *
 * @export
 * @class EMPurPlanServiceBase
 * @extends {EntityServie}
 */
export default class EMPurPlanServiceBase extends EntityService {

    /**
     * Creates an instance of  EMPurPlanServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMPurPlanServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMPurPlanServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='empurplan';
        this.APPDEKEY = 'empurplanid';
        this.APPDENAME = 'empurplans';
        this.APPDETEXT = 'empurplanname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/empurplans/${context.empurplan}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/empurplans`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/empurplans/${context.empurplan}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/empurplans/${context.empurplan}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/empurplans/${context.empurplan}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/empurplans/getdraft`,isloading);
        res.data.empurplan = data.empurplan;
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/empurplans/${context.empurplan}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/empurplans/${context.empurplan}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMPurPlanServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/empurplans/fetchdefault`,tempData,isloading);
    }
}