import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 现象服务对象基类
 *
 * @export
 * @class EMRFODEServiceBase
 * @extends {EntityServie}
 */
export default class EMRFODEServiceBase extends EntityService {

    /**
     * Creates an instance of  EMRFODEServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMRFODEServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMRFODEServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emrfode';
        this.APPDEKEY = 'emrfodeid';
        this.APPDENAME = 'emrfodes';
        this.APPDETEXT = 'emrfodename';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/emrfodes/${context.emrfode}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfodemapsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfodemaps'),'undefined')){
            emrfodemapsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfodemaps') as any);
            if(emrfodemapsData && emrfodemapsData.length && emrfodemapsData.length > 0){
                emrfodemapsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfodemapid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfodemaps = emrfodemapsData;
        let emrfomosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfomos'),'undefined')){
            emrfomosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfomos') as any);
            if(emrfomosData && emrfomosData.length && emrfomosData.length > 0){
                emrfomosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfomoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfomos = emrfomosData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emrfodes`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emrfodemaps',JSON.stringify(res.data.emrfodemaps));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emrfomos',JSON.stringify(res.data.emrfomos));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfodemapsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfodemaps'),'undefined')){
            emrfodemapsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfodemaps') as any);
            if(emrfodemapsData && emrfodemapsData.length && emrfodemapsData.length > 0){
                emrfodemapsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfodemapid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfodemaps = emrfodemapsData;
        let emrfomosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfomos'),'undefined')){
            emrfomosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfomos') as any);
            if(emrfomosData && emrfomosData.length && emrfomosData.length > 0){
                emrfomosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfomoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfomos = emrfomosData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emrfodes/${context.emrfode}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfodemaps',JSON.stringify(res.data.emrfodemaps));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfomos',JSON.stringify(res.data.emrfomos));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/emrfodes/${context.emrfode}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/emrfodes/${context.emrfode}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfodemaps',JSON.stringify(res.data.emrfodemaps));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfomos',JSON.stringify(res.data.emrfomos));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/emrfodes/getdraft`,isloading);
        res.data.emrfode = data.emrfode;
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfodemaps',JSON.stringify(res.data.emrfodemaps));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfomos',JSON.stringify(res.data.emrfomos));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/emrfodes/${context.emrfode}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfodemapsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfodemaps'),'undefined')){
            emrfodemapsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfodemaps') as any);
            if(emrfodemapsData && emrfodemapsData.length && emrfodemapsData.length > 0){
                emrfodemapsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfodemapid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfodemaps = emrfodemapsData;
        let emrfomosData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfomos'),'undefined')){
            emrfomosData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfomos') as any);
            if(emrfomosData && emrfomosData.length && emrfomosData.length > 0){
                emrfomosData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfomoid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfomos = emrfomosData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emrfodes/${context.emrfode}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfodemaps',JSON.stringify(res.data.emrfodemaps));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfomos',JSON.stringify(res.data.emrfomos));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFODEServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emrfodes/fetchdefault`,tempData,isloading);
    }
}