import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 模式服务对象基类
 *
 * @export
 * @class EMRFOMOServiceBase
 * @extends {EntityServie}
 */
export default class EMRFOMOServiceBase extends EntityService {

    /**
     * Creates an instance of  EMRFOMOServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMRFOMOServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMRFOMOServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emrfomo';
        this.APPDEKEY = 'emrfomoid';
        this.APPDENAME = 'emrfomos';
        this.APPDETEXT = 'emrfomoname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && context.emrfomo){
            return Http.getInstance().get(`/emrfodes/${context.emrfode}/emrfomos/${context.emrfomo}/select`,isloading);
        }
            return Http.getInstance().get(`/emrfomos/${context.emrfomo}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && true){
            let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emrfodes/${context.emrfode}/emrfomos`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
        }
        let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emrfomos`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && context.emrfomo){
            let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emrfodes/${context.emrfode}/emrfomos/${context.emrfomo}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
        }
        let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emrfomos/${context.emrfomo}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && context.emrfomo){
            return Http.getInstance().delete(`/emrfodes/${context.emrfode}/emrfomos/${context.emrfomo}`,isloading);
        }
            return Http.getInstance().delete(`/emrfomos/${context.emrfomo}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && context.emrfomo){
            let res:any = await Http.getInstance().get(`/emrfodes/${context.emrfode}/emrfomos/${context.emrfomo}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
        }
            let res:any = await Http.getInstance().get(`/emrfomos/${context.emrfomo}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && true){
            let res:any = await Http.getInstance().get(`/emrfodes/${context.emrfode}/emrfomos/getdraft`,isloading);
            res.data.emrfomo = data.emrfomo;
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emrfomos/getdraft`,isloading);
        res.data.emrfomo = data.emrfomo;
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && context.emrfomo){
            let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emrfodes/${context.emrfode}/emrfomos/${context.emrfomo}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
        }
            return Http.getInstance().post(`/emrfomos/${context.emrfomo}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && context.emrfomo){
            let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emrfodes/${context.emrfode}/emrfomos/${context.emrfomo}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
        }
        let masterData:any = {};
        let emrfocasData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas'),'undefined')){
            emrfocasData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfocas') as any);
            if(emrfocasData && emrfocasData.length && emrfocasData.length > 0){
                emrfocasData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfocaid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfocas = emrfocasData;
        let emrfoacsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs'),'undefined')){
            emrfoacsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emrfoacs') as any);
            if(emrfoacsData && emrfoacsData.length && emrfoacsData.length > 0){
                emrfoacsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emrfoacid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emrfoacs = emrfoacsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emrfomos/${context.emrfomo}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emrfocas',JSON.stringify(res.data.emrfocas));
            this.tempStorage.setItem(context.srfsessionkey+'_emrfoacs',JSON.stringify(res.data.emrfoacs));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMRFOMOServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emrfode && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emrfodes/${context.emrfode}/emrfomos/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emrfomos/fetchdefault`,tempData,isloading);
    }
}