import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 服务商服务对象基类
 *
 * @export
 * @class EMServiceServiceBase
 * @extends {EntityServie}
 */
export default class EMServiceServiceBase extends EntityService {

    /**
     * Creates an instance of  EMServiceServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMServiceServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMServiceServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emservice';
        this.APPDEKEY = 'emserviceid';
        this.APPDENAME = 'emservices';
        this.APPDETEXT = 'emservicename';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/emservices/${context.emservice}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emserviceevlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emserviceevls'),'undefined')){
            emserviceevlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emserviceevls') as any);
            if(emserviceevlsData && emserviceevlsData.length && emserviceevlsData.length > 0){
                emserviceevlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emserviceevlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emserviceevls = emserviceevlsData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emservices`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emserviceevls',JSON.stringify(res.data.emserviceevls));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emserviceevlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emserviceevls'),'undefined')){
            emserviceevlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emserviceevls') as any);
            if(emserviceevlsData && emserviceevlsData.length && emserviceevlsData.length > 0){
                emserviceevlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emserviceevlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emserviceevls = emserviceevlsData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emservices/${context.emservice}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emserviceevls',JSON.stringify(res.data.emserviceevls));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/emservices/${context.emservice}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emserviceevls',JSON.stringify(res.data.emserviceevls));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/emservices/getdraft`,isloading);
        res.data.emservice = data.emservice;
            this.tempStorage.setItem(context.srfsessionkey+'_emserviceevls',JSON.stringify(res.data.emserviceevls));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/emservices/${context.emservice}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emserviceevlsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emserviceevls'),'undefined')){
            emserviceevlsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emserviceevls') as any);
            if(emserviceevlsData && emserviceevlsData.length && emserviceevlsData.length > 0){
                emserviceevlsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emserviceevlid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emserviceevls = emserviceevlsData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emservices/${context.emservice}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emserviceevls',JSON.stringify(res.data.emserviceevls));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMServiceServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emservices/fetchdefault`,tempData,isloading);
    }
}