import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 仓库库位服务对象基类
 *
 * @export
 * @class EMStorePartServiceBase
 * @extends {EntityServie}
 */
export default class EMStorePartServiceBase extends EntityService {

    /**
     * Creates an instance of  EMStorePartServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMStorePartServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMStorePartServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emstorepart';
        this.APPDEKEY = 'emstorepartid';
        this.APPDENAME = 'emstoreparts';
        this.APPDETEXT = 'emstorepartname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/select`,isloading);
        }
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && true){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
        }
        let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emstoreparts`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
        }
        let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emstoreparts/${context.emstorepart}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}`,isloading);
        }
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
        }
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/getdraft`,isloading);
            res.data.emstorepart = data.emstorepart;
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emstoreparts/getdraft`,isloading);
        res.data.emstorepart = data.emstorepart;
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
        }
            return Http.getInstance().post(`/emstoreparts/${context.emstorepart}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart){
            let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
        }
        let masterData:any = {};
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emstoreparts/${context.emstorepart}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStorePartServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emstoreparts/fetchdefault`,tempData,isloading);
    }
}