import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 仓库服务对象基类
 *
 * @export
 * @class EMStoreServiceBase
 * @extends {EntityServie}
 */
export default class EMStoreServiceBase extends EntityService {

    /**
     * Creates an instance of  EMStoreServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMStoreServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMStoreServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emstore';
        this.APPDEKEY = 'emstoreid';
        this.APPDENAME = 'emstores';
        this.APPDETEXT = 'emstorename';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/emstores/${context.emstore}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        let emstorepartsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstoreparts'),'undefined')){
            emstorepartsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstoreparts') as any);
            if(emstorepartsData && emstorepartsData.length && emstorepartsData.length > 0){
                emstorepartsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstorepartid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstoreparts = emstorepartsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emstores`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emstoreparts',JSON.stringify(res.data.emstoreparts));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        let emstorepartsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstoreparts'),'undefined')){
            emstorepartsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstoreparts') as any);
            if(emstorepartsData && emstorepartsData.length && emstorepartsData.length > 0){
                emstorepartsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstorepartid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstoreparts = emstorepartsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emstores/${context.emstore}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            this.tempStorage.setItem(context.srfsessionkey+'_emstoreparts',JSON.stringify(res.data.emstoreparts));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/emstores/${context.emstore}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            this.tempStorage.setItem(context.srfsessionkey+'_emstoreparts',JSON.stringify(res.data.emstoreparts));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/emstores/getdraft`,isloading);
        res.data.emstore = data.emstore;
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            this.tempStorage.setItem(context.srfsessionkey+'_emstoreparts',JSON.stringify(res.data.emstoreparts));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/emstores/${context.emstore}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emstocksData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstocks'),'undefined')){
            emstocksData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstocks') as any);
            if(emstocksData && emstocksData.length && emstocksData.length > 0){
                emstocksData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstockid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstocks = emstocksData;
        let emitemsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitems'),'undefined')){
            emitemsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitems') as any);
            if(emitemsData && emitemsData.length && emitemsData.length > 0){
                emitemsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitemid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitems = emitemsData;
        let emstorepartsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emstoreparts'),'undefined')){
            emstorepartsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emstoreparts') as any);
            if(emstorepartsData && emstorepartsData.length && emstorepartsData.length > 0){
                emstorepartsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emstorepartid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emstoreparts = emstorepartsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emstores/${context.emstore}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emstocks',JSON.stringify(res.data.emstocks));
            this.tempStorage.setItem(context.srfsessionkey+'_emitems',JSON.stringify(res.data.emitems));
            this.tempStorage.setItem(context.srfsessionkey+'_emstoreparts',JSON.stringify(res.data.emstoreparts));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMStoreServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emstores/fetchdefault`,tempData,isloading);
    }
}