import { Http,Util } from '@/utils';
import EntityService from '../entity-service';
import GenIdLogic from '@/service/emwplist/gen-id-logic';
import GetREMPLogic from '@/service/emwplist/get-remp-logic';



/**
 * 采购申请服务对象基类
 *
 * @export
 * @class EMWPListServiceBase
 * @extends {EntityServie}
 */
export default class EMWPListServiceBase extends EntityService {

    /**
     * Creates an instance of  EMWPListServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EMWPListServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof EMWPListServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='emwplist';
        this.APPDEKEY = 'emwplistid';
        this.APPDENAME = 'emwplists';
        this.APPDETEXT = 'emwplistname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/select`,isloading);
        }
        if(context.emstore && context.emitem && context.emwplist){
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}/select`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/select`,isloading);
        }
        if(context.emservice && context.emitem && context.emwplist){
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}/select`,isloading);
        }
        if(context.emitem && context.emwplist){
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/${context.emwplist}/select`,isloading);
        }
            return Http.getInstance().get(`/emwplists/${context.emwplist}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && true){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && true){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && true){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emwplists`,data,isloading);
            this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/emwplists`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/emitems/${context.emitem}/emwplists/${context.emwplist}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/emwplists/${context.emwplist}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
        }
        if(context.emstore && context.emitem && context.emwplist){
            return Http.getInstance().delete(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            return Http.getInstance().delete(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
        }
        if(context.emservice && context.emitem && context.emwplist){
            return Http.getInstance().delete(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
        }
        if(context.emitem && context.emwplist){
            return Http.getInstance().delete(`/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
        }
            return Http.getInstance().delete(`/emwplists/${context.emwplist}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && context.emwplist){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && context.emwplist){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && context.emwplist){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emwplists/${context.emwplist}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
            let res:any = await Http.getInstance().get(`/emwplists/${context.emwplist}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/getdraft`,isloading);
            res.data.emwplist = data.emwplist;
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/getdraft`,isloading);
            res.data.emwplist = data.emwplist;
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/getdraft`,isloading);
            res.data.emwplist = data.emwplist;
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && true){
            let res:any = await Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/getdraft`,isloading);
            res.data.emwplist = data.emwplist;
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && true){
            let res:any = await Http.getInstance().get(`/emitems/${context.emitem}/emwplists/getdraft`,isloading);
            res.data.emwplist = data.emwplist;
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        let res:any = await  Http.getInstance().get(`/emwplists/getdraft`,isloading);
        res.data.emwplist = data.emwplist;
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emwplists/${context.emwplist}/checkkey`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
            return Http.getInstance().post(`/emwplists/${context.emwplist}/checkkey`,data,isloading);
    }

    /**
     * FillCosted接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FillCosted(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/fillcosted`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}/fillcosted`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/fillcosted`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}/fillcosted`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emwplists/${context.emwplist}/fillcosted`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
            return Http.getInstance().post(`/emwplists/${context.emwplist}/fillcosted`,data,isloading);
    }

    /**
     * GenId接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async GenId(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/genid`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}/genid`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/genid`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}/genid`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emwplists/${context.emwplist}/genid`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
            return Http.getInstance().post(`/emwplists/${context.emwplist}/genid`,data,isloading);
    }

    /**
     * GenPO接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async GenPO(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/genpo`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}/genpo`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/genpo`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}/genpo`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emwplists/${context.emwplist}/genpo`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
            return Http.getInstance().post(`/emwplists/${context.emwplist}/genpo`,data,isloading);
    }

    /**
     * GetREMP接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async GetREMP(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let appLogic:GetREMPLogic = new GetREMPLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(data))});
        const result = await appLogic.onExecute(context,data,isloading?true:false);
        return {status:200,data:result};
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emwplists/${context.emwplist}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/emwplists/${context.emwplist}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
    }

    /**
     * Submit接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async Submit(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/submit`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstore && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/${context.emwplist}/submit`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emstorepart && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/${context.emwplist}/submit`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emservice && context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/${context.emwplist}/submit`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
        if(context.emitem && context.emwplist){
            let masterData:any = {};
        let emwplistcostsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts'),'undefined')){
            emwplistcostsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwplistcosts') as any);
            if(emwplistcostsData && emwplistcostsData.length && emwplistcostsData.length > 0){
                emwplistcostsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwplistcostid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwplistcosts = emwplistcostsData;
        let empodetailsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_empodetails'),'undefined')){
            empodetailsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_empodetails') as any);
            if(empodetailsData && empodetailsData.length && empodetailsData.length > 0){
                empodetailsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.empodetailid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.empodetails = empodetailsData;
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/emitems/${context.emitem}/emwplists/${context.emwplist}/submit`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwplistcosts',JSON.stringify(res.data.emwplistcosts));
            this.tempStorage.setItem(context.srfsessionkey+'_empodetails',JSON.stringify(res.data.empodetails));
            return res;
        }
            return Http.getInstance().post(`/emwplists/${context.emwplist}/submit`,data,isloading);
    }

    /**
     * FetchCancel接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchCancel(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchcancel`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchcancel`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchcancel`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchcancel`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchcancel`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchcancel`,tempData,isloading);
    }

    /**
     * FetchConfimCost接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchConfimCost(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchconfimcost`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchconfimcost`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchconfimcost`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchconfimcost`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchconfimcost`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchconfimcost`,tempData,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchdefault`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchdefault`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchdefault`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchdefault`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchdefault`,tempData,isloading);
    }

    /**
     * FetchDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchdraft`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchdraft`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchdraft`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchdraft`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchdraft`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchdraft`,tempData,isloading);
    }

    /**
     * FetchIn接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchIn(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchin`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchin`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchin`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchin`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchin`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchin`,tempData,isloading);
    }

    /**
     * FetchMain6接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchMain6(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchmain6`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchmain6`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchmain6`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchmain6`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchmain6`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchmain6`,tempData,isloading);
    }

    /**
     * FetchMain6_8692接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchMain6_8692(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchmain6_8692`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchmain6_8692`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchmain6_8692`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchmain6_8692`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchmain6_8692`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchmain6_8692`,tempData,isloading);
    }

    /**
     * FetchWaitCost接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchWaitCost(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchwaitcost`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchwaitcost`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchwaitcost`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchwaitcost`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchwaitcost`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchwaitcost`,tempData,isloading);
    }

    /**
     * FetchWaitPo接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchWaitPo(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchwaitpo`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchwaitpo`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchwaitpo`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchwaitpo`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchwaitpo`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchwaitpo`,tempData,isloading);
    }

    /**
     * FetchWpStateNum接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof EMWPListServiceBase
     */
    public async FetchWpStateNum(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.emstore && context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchwpstatenum`,tempData,isloading);
        }
        if(context.emstore && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstores/${context.emstore}/emitems/${context.emitem}/emwplists/fetchwpstatenum`,tempData,isloading);
        }
        if(context.emstorepart && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emstoreparts/${context.emstorepart}/emitems/${context.emitem}/emwplists/fetchwpstatenum`,tempData,isloading);
        }
        if(context.emservice && context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emservices/${context.emservice}/emitems/${context.emitem}/emwplists/fetchwpstatenum`,tempData,isloading);
        }
        if(context.emitem && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/emitems/${context.emitem}/emwplists/fetchwpstatenum`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/emwplists/fetchwpstatenum`,tempData,isloading);
    }
}