import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 班组服务对象基类
 *
 * @export
 * @class PFTeamServiceBase
 * @extends {EntityServie}
 */
export default class PFTeamServiceBase extends EntityService {

    /**
     * Creates an instance of  PFTeamServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  PFTeamServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof PFTeamServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='pfteam';
        this.APPDEKEY = 'pfteamid';
        this.APPDENAME = 'pfteams';
        this.APPDETEXT = 'pfteamname';
        this.APPNAME = 'eamweb';
        this.SYSTEMNAME = 'eam';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/pfteams/${context.pfteam}/select`,isloading);
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        let emequipsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emequips'),'undefined')){
            emequipsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emequips') as any);
            if(emequipsData && emequipsData.length && emequipsData.length > 0){
                emequipsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emequipid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emequips = emequipsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/pfteams`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emequips',JSON.stringify(res.data.emequips));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        let emequipsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emequips'),'undefined')){
            emequipsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emequips') as any);
            if(emequipsData && emequipsData.length && emequipsData.length > 0){
                emequipsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emequipid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emequips = emequipsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/pfteams/${context.pfteam}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            this.tempStorage.setItem(context.srfsessionkey+'_emequips',JSON.stringify(res.data.emequips));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/pfteams/${context.pfteam}`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/pfteams/${context.pfteam}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            this.tempStorage.setItem(context.srfsessionkey+'_emequips',JSON.stringify(res.data.emequips));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/pfteams/getdraft`,isloading);
        res.data.pfteam = data.pfteam;
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            this.tempStorage.setItem(context.srfsessionkey+'_emequips',JSON.stringify(res.data.emequips));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/pfteams/${context.pfteam}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let emwo_dpsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps'),'undefined')){
            emwo_dpsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emwo_dps') as any);
            if(emwo_dpsData && emwo_dpsData.length && emwo_dpsData.length > 0){
                emwo_dpsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emwo_dpid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emwo_dps = emwo_dpsData;
        let emplantemplsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls'),'undefined')){
            emplantemplsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplantempls') as any);
            if(emplantemplsData && emplantemplsData.length && emplantemplsData.length > 0){
                emplantemplsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplantemplid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplantempls = emplantemplsData;
        let emequipsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emequips'),'undefined')){
            emequipsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emequips') as any);
            if(emequipsData && emequipsData.length && emequipsData.length > 0){
                emequipsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emequipid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emequips = emequipsData;
        let emitempusesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses'),'undefined')){
            emitempusesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emitempuses') as any);
            if(emitempusesData && emitempusesData.length && emitempusesData.length > 0){
                emitempusesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emitempuseid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emitempuses = emitempusesData;
        let emplansData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_emplans'),'undefined')){
            emplansData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_emplans') as any);
            if(emplansData && emplansData.length && emplansData.length > 0){
                emplansData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.emplanid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.emplans = emplansData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/pfteams/${context.pfteam}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_emwo_dps',JSON.stringify(res.data.emwo_dps));
            this.tempStorage.setItem(context.srfsessionkey+'_emplantempls',JSON.stringify(res.data.emplantempls));
            this.tempStorage.setItem(context.srfsessionkey+'_emequips',JSON.stringify(res.data.emequips));
            this.tempStorage.setItem(context.srfsessionkey+'_emitempuses',JSON.stringify(res.data.emitempuses));
            this.tempStorage.setItem(context.srfsessionkey+'_emplans',JSON.stringify(res.data.emplans));
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PFTeamServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/pfteams/fetchdefault`,tempData,isloading);
    }
}