/**
 * IndexView 部件模型
 *
 * @export
 * @class IndexViewModel
 */
export default class IndexViewModel {

    /**
     * 菜单项集合
     *
     * @public
     * @type {any[]}
     * @memberof IndexViewModel
     */
    public items: any[] = [
        {
	id: '62d1e15d1101a21fa761909a0bf211a0',
	name: 'menuitem61',
	text: '工作台',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作台',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: true,
	iconcls: 'fa fa-desktop',
	icon: '',
	textcls: '',
	appfunctag: 'Auto37',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem61',
},
        {
	id: 'aca04834b859a26e1366c8bb1821f655',
	name: 'menuitem3',
	text: '设备',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '设备',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-align-right',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem3',
	items: [
		{
	id: '91e3f447bcf751acb68ad992b2f5b3bc',
	name: 'menuitem1',
	text: '设备类型',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '设备类型',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto21',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem1',
},
		{
	id: 'a830789a1368339c6f11df663767ce81',
	name: 'menuitem8',
	text: '设备档案',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '设备档案',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto1',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem8',
},
		{
	id: '197c51c6dff3b94e5db619065a64f1d3',
	name: 'menuitem5',
	text: '位置',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '位置',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto12',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem5',
},
		{
	id: '0ee99b62d7d4a3ca7e0dd8ce53d90461',
	name: 'menuitem6',
	text: '文档',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '文档',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto20',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem6',
},
		{
	id: '91a5261cca34041e70cac023b5014d92',
	name: 'menuitem7',
	text: '备件包',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '备件包',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto10',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem7',
},
	],
},
        {
	id: '8A323FB9-69CA-4012-8C3E-EA8CF7907B86',
	name: 'menuitem72',
	text: '运行',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '运行',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-bug',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem72',
	items: [
		{
	id: '5E9D2321-5CFF-47C0-809C-92672DECF9C9',
	name: 'menuitem73',
	text: '运行日志',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '运行日志',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_8',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem73',
},
		{
	id: 'BD293902-B92C-4777-99A6-16F828A5AE79',
	name: 'menuitem74',
	text: '运行监控',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '运行监控',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_3',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem74',
},
		{
	id: '2FB26B29-7919-452D-8AD0-7A4CDADA0B57',
	name: 'menuitem77',
	text: '仪表',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '仪表',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_5',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem77',
},
		{
	id: '244DC1B6-B69C-4329-8524-0A1874273830',
	name: 'menuitem78',
	text: '仪表读数',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '仪表读数',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_2',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem78',
},
		{
	id: '399AF6B9-299A-4E6B-BFB9-E06E58880DB3',
	name: 'menuitem75',
	text: '关键点',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '关键点',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_6',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem75',
},
		{
	id: '79EACAD7-12E4-44E4-833C-F4F46A841199',
	name: 'menuitem76',
	text: '关键点记录',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '关键点记录',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_9',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem76',
},
	],
},
        {
	id: 'ea4c24a1edc4468262b8b1563aece85b',
	name: 'menuitem16',
	text: '计划',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '计划',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-pencil-square-o',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem16',
	items: [
		{
	id: '8cd21f2248f50d05feeae05af87695f6',
	name: 'menuitem17',
	text: '计划',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '计划',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto15',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem17',
},
		{
	id: '125e8e816acfc07ce31269c235234562',
	name: 'menuitem18',
	text: '计划模板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '计划模板',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto6',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem18',
},
	],
},
        {
	id: 'e0d669a7e3fed03d27bfb5e2faa88383',
	name: 'menuitem33',
	text: '能耗',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '能耗',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-area-chart',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem33',
	items: [
		{
	id: '7de90ca0fde034a263f0a7cba33345a3',
	name: 'menuitem50',
	text: '能源',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '能源',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto35',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem50',
},
		{
	id: 'a4403b92e10915d7b6017a8f66931030',
	name: 'menuitem55',
	text: '能耗',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '能耗',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto32',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem55',
},
	],
},
        {
	id: '784133e400807ee0e42040989626f404',
	name: 'menuitem9',
	text: '工单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工单',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-align-justify',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem9',
	items: [
		{
	id: '5ECD51DE-2799-4338-8636-B0874DDE8D99',
	name: 'menuitem69',
	text: '工单日历',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工单日历',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto58',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem69',
},
		{
	id: 'b12f2564211ecd3495581d1ec8429f1d',
	name: 'menuitem11',
	text: '内部工单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内部工单',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto9',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem11',
},
		{
	id: 'a876893cac8500fc63ff54fb105af0ad',
	name: 'menuitem12',
	text: '外委工单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '外委工单',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto17',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem12',
},
		{
	id: '4760e11b6643f3ecf9c93a0e9f1431a6',
	name: 'menuitem13',
	text: '能耗工单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '能耗工单',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto5',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem13',
},
		{
	id: '8dbfd1440ee08edf4ec78bc0710f696a',
	name: 'menuitem14',
	text: '点检工单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '点检工单',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto3',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem14',
},
		{
	id: 'fc24879f15de57c4ef0d109ef73920c1',
	name: 'menuitem15',
	text: '外委申请',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '外委申请',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto16',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem15',
},
	],
},
        {
	id: 'e451c96d55e18e7e446f349794a81cd9',
	name: 'menuitem32',
	text: '活动',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '活动',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-university',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem32',
	items: [
		{
	id: '80703153-D6BA-4BF0-B17B-F9FCC874D2D2',
	name: 'menuitem70',
	text: '活动日历',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '活动日历',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_7',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem70',
},
		{
	id: '5653e4a0f09955bb699647a7e6e6a8d3',
	name: 'menuitem56',
	text: '更换安装',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '更换安装',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto27',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem56',
},
		{
	id: 'da00f5c4672f07ef2a48df1648e98663',
	name: 'menuitem57',
	text: '事故记录',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '事故记录',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto33',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem57',
},
		{
	id: '372acbd4a93a650ff2eeefa6cb161a9f',
	name: 'menuitem58',
	text: '维修记录',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '维修记录',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto38',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem58',
},
		{
	id: '2481c1cb7d1178ea0ca4d45f268edd80',
	name: 'menuitem59',
	text: '抢修记录',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '抢修记录',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto31',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem59',
},
		{
	id: '2ca6f227b185e1a9f7b740501297b656',
	name: 'menuitem60',
	text: '保养记录',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '保养记录',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto28',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem60',
},
	],
},
        {
	id: '340d799544c2f9e4ca10677ceba6741e',
	name: 'menuitem31',
	text: '故障',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '故障',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-exclamation-triangle',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem31',
	items: [
		{
	id: 'ef9e2ca27c33a60ee15fcba69f7b935b',
	name: 'menuitem48',
	text: '现象',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '现象',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto50',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem48',
},
		{
	id: '5c468548b5b9393e31c89bb9d2900a4c',
	name: 'menuitem47',
	text: '现象分类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '现象分类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto26',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem47',
},
		{
	id: '1592c1668559c019ae73ecc376ee5fe2',
	name: 'menuitem49',
	text: '模式',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '模式',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto41',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem49',
},
		{
	id: '023a183ee4074929c594098c5850abd2',
	name: 'menuitem51',
	text: '原因',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '原因',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto48',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem51',
},
		{
	id: '16ae8e16fc0afbcd1e7258cef286b7e0',
	name: 'menuitem52',
	text: '方案',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '方案',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto30',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem52',
},
	],
},
        {
	id: '8a31c189b74d7feb9b99cf66303ab0e9',
	name: 'menuitem30',
	text: '资产',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '资产',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-navicon',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem30',
	items: [
		{
	id: '5e6296bb0527245492b28469bf91c2a8',
	name: 'menuitem43',
	text: '资产科目',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '资产科目',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto51',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem43',
},
		{
	id: '3c2daa4517a5138ff3f2da156cf76bb7',
	name: 'menuitem44',
	text: '固定资产台账',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '固定资产台账',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto29',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem44',
},
		{
	id: 'e561b23927ef64b9ab0f41ddf9864e3a',
	name: 'menuitem45',
	text: '报废资产',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '报废资产',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto46',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem45',
},
		{
	id: '1fab51747f22c63ac7a31c3010c64c30',
	name: 'menuitem46',
	text: '资产盘点记录',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '资产盘点记录',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto39',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem46',
},
	],
},
        {
	id: '9cfc55c5762f6d86c74dcfc0e8bdcaba',
	name: 'menuitem4',
	text: '材料',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '材料',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-file-o',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem4',
	items: [
		{
	id: '8b4ec6aaca0699e2028d6b5a2e8dd469',
	name: 'menuitem2',
	text: '物品类型',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '物品类型',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto22',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem2',
},
		{
	id: 'f3860426358cd71f3aa18b71403869ab',
	name: 'menuitem19',
	text: '物品',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '物品',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto14',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem19',
},
		{
	id: 'aba7daa88761523de4b763ab9cd182a7',
	name: 'menuitem21',
	text: '库存管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '库存管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto2',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem21',
},
		{
	id: 'ae2cd087d5adf4ecdc29f297420c2745',
	name: 'menuitem24',
	text: '损溢单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '损溢单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto18',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem24',
},
		{
	id: '4e40097b17a3d3052d2b64a122f627a8',
	name: 'menuitem25',
	text: '调整单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '调整单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto4',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem25',
},
		{
	id: 'b2f8dc6db4f3356f4b0a486ad969bf20',
	name: 'menuitem27',
	text: '出库单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '出库单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto13',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem27',
},
		{
	id: 'f3088ef79f30add28ae3f1b51b7ec9a4',
	name: 'menuitem23',
	text: '领料单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '领料单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto7',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem23',
},
		{
	id: '225ceb368b7dafc548747408c96df6d0',
	name: 'menuitem28',
	text: '还料单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '还料单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto8',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem28',
},
	],
},
        {
	id: '1dd9c12fcc2d904366c60141a5bbe40f',
	name: 'menuitem29',
	text: '采购',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '采购',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-leanpub',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem29',
	items: [
		{
	id: '7D689FE4-BF8F-458A-8EDD-19B83192B7F3',
	name: 'menuitem64',
	text: '采购流程',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '采购流程',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto54',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem64',
},
		{
	id: 'f6c0136750c346c0b6cdeaca611eaa0f',
	name: 'menuitem38',
	text: '服务商',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '服务商',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto36',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem38',
},
		{
	id: '356540445b7c505f0cd55f5fff1bb433',
	name: 'menuitem39',
	text: '服务商评估',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '服务商评估',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto34',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem39',
},
	],
},
        {
	id: '6138adf7a46df6c2b3319c1f8a000a44',
	name: 'menuitem62',
	text: '预警',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '预警',
	expanded: true,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-bell-o',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem62',
	items: [
		{
	id: '8488577e62ea3cc8c383ed82e1ffd559',
	name: 'menuitem63',
	text: '钢丝绳位置超期预警',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '钢丝绳位置超期预警',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto24',
	resourcetag: '',
	authtag:'EAMWeb-IndexView-menuitem63',
},
	],
},
    ];

	/**
	 * 应用功能集合
	 *
	 * @public
	 * @type {any[]}
	 * @memberof IndexViewModel
	 */
	public funcs: any[] = [
        {
            appfunctag: 'Auto51',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emassetclassgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emassetclasses/:emassetclass?/gridview/:gridview?',
            parameters: [
                { pathName: 'emassetclasses', parameterName: 'emassetclass' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto37',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'appportalview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/appportalview/:appportalview?',
            parameters: [
                { pathName: 'appportalview', parameterName: 'appportalview' },
            ],
        },
        {
            appfunctag: '_5',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqmpgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqmps/:emeqmp?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqmps', parameterName: 'emeqmp' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto17',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emwo_oscgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emwo_oscs/:emwo_osc?/gridview/:gridview?',
            parameters: [
                { pathName: 'emwo_oscs', parameterName: 'emwo_osc' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_7',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqahcalendarexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqahs/:emeqah?/calendarexpview/:calendarexpview?',
            parameters: [
                { pathName: 'emeqahs', parameterName: 'emeqah' },
                { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
            ],
        },
        {
            appfunctag: 'Auto4',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emitemcstabexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emitemcs/:emitemcs?/tabexpview/:tabexpview?',
            parameters: [
                { pathName: 'emitemcs', parameterName: 'emitemcs' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
        },
        {
            appfunctag: 'Auto7',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emitempusetabexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emitempuses/:emitempuse?/tabexpview/:tabexpview?',
            parameters: [
                { pathName: 'emitempuses', parameterName: 'emitempuse' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
        },
        {
            appfunctag: 'Auto28',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqkeepgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqkeeps/:emeqkeep?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqkeeps', parameterName: 'emeqkeep' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto9',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emwo_innergridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emwo_inners/:emwo_inner?/gridview/:gridview?',
            parameters: [
                { pathName: 'emwo_inners', parameterName: 'emwo_inner' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto10',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqsparegridexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqspares/:emeqspare?/gridexpview/:gridexpview?',
            parameters: [
                { pathName: 'emeqspares', parameterName: 'emeqspare' },
                { pathName: 'gridexpview', parameterName: 'gridexpview' },
            ],
        },
        {
            appfunctag: 'Auto14',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emitemtypeitemtreeexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emitemtypes/:emitemtype?/itemtreeexpview/:itemtreeexpview?',
            parameters: [
                { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                { pathName: 'itemtreeexpview', parameterName: 'itemtreeexpview' },
            ],
        },
        {
            appfunctag: 'Auto20',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emdrwgtreeexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emdrwgs/:emdrwg?/treeexpview/:treeexpview?',
            parameters: [
                { pathName: 'emdrwgs', parameterName: 'emdrwg' },
                { pathName: 'treeexpview', parameterName: 'treeexpview' },
            ],
        },
        {
            appfunctag: 'Auto27',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqsetupgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqsetups/:emeqsetup?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqsetups', parameterName: 'emeqsetup' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto50',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emrfodegridexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emrfodes/:emrfode?/gridexpview/:gridexpview?',
            parameters: [
                { pathName: 'emrfodes', parameterName: 'emrfode' },
                { pathName: 'gridexpview', parameterName: 'gridexpview' },
            ],
        },
        {
            appfunctag: 'Auto12',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqlocationtreeexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqlocations/:emeqlocation?/treeexpview/:treeexpview?',
            parameters: [
                { pathName: 'emeqlocations', parameterName: 'emeqlocation' },
                { pathName: 'treeexpview', parameterName: 'treeexpview' },
            ],
        },
        {
            appfunctag: '_8',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqwlgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqwls/:emeqwl?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqwls', parameterName: 'emeqwl' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emwo_dpgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emwo_dps/:emwo_dp?/gridview/:gridview?',
            parameters: [
                { pathName: 'emwo_dps', parameterName: 'emwo_dp' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto34',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emserviceevlgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emserviceevls/:emserviceevl?/gridview/:gridview?',
            parameters: [
                { pathName: 'emserviceevls', parameterName: 'emserviceevl' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto36',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emservicegridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emservices/:emservice?/gridview/:gridview?',
            parameters: [
                { pathName: 'emservices', parameterName: 'emservice' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto16',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emapplygridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emapplies/:emapply?/gridview/:gridview?',
            parameters: [
                { pathName: 'emapplies', parameterName: 'emapply' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto15',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emplangridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emplans/:emplan?/gridview/:gridview?',
            parameters: [
                { pathName: 'emplans', parameterName: 'emplan' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto6',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emplantemplgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emplantempls/:emplantempl?/gridview/:gridview?',
            parameters: [
                { pathName: 'emplantempls', parameterName: 'emplantempl' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto41',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emrfomogridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emrfomos/:emrfomo?/gridview/:gridview?',
            parameters: [
                { pathName: 'emrfomos', parameterName: 'emrfomo' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_6',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqkpgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqkps/:emeqkp?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqkps', parameterName: 'emeqkp' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto18',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emitempltabexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emitempls/:emitempl?/tabexpview/:tabexpview?',
            parameters: [
                { pathName: 'emitempls', parameterName: 'emitempl' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
        },
        {
            appfunctag: 'Auto31',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqmaintancegridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqmaintances/:emeqmaintance?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqmaintances', parameterName: 'emeqmaintance' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto22',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emitemtypeinfotreeexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emitemtypes/:emitemtype?/infotreeexpview/:infotreeexpview?',
            parameters: [
                { pathName: 'emitemtypes', parameterName: 'emitemtype' },
                { pathName: 'infotreeexpview', parameterName: 'infotreeexpview' },
            ],
        },
        {
            appfunctag: 'Auto38',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqcheckgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqchecks/:emeqcheck?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqchecks', parameterName: 'emeqcheck' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto35',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emengridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emen/:emen?/gridview/:gridview?',
            parameters: [
                { pathName: 'emen', parameterName: 'emen' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto8',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emitemprtntabexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emitemprtns/:emitemprtn?/tabexpview/:tabexpview?',
            parameters: [
                { pathName: 'emitemprtns', parameterName: 'emitemprtn' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
        },
        {
            appfunctag: 'Auto54',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emwplistwpprocesstreeexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emwplists/:emwplist?/wpprocesstreeexpview/:wpprocesstreeexpview?',
            parameters: [
                { pathName: 'emwplists', parameterName: 'emwplist' },
                { pathName: 'wpprocesstreeexpview', parameterName: 'wpprocesstreeexpview' },
            ],
        },
        {
            appfunctag: 'Auto2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emstoretreeexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emstores/:emstore?/treeexpview/:treeexpview?',
            parameters: [
                { pathName: 'emstores', parameterName: 'emstore' },
                { pathName: 'treeexpview', parameterName: 'treeexpview' },
            ],
        },
        {
            appfunctag: '_2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqmpmtrgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqmpmtrs/:emeqmpmtr?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqmpmtrs', parameterName: 'emeqmpmtr' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto46',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emassetgridview_bf',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emassets/:emasset?/gridview_bf/:gridview_bf?',
            parameters: [
                { pathName: 'emassets', parameterName: 'emasset' },
                { pathName: 'gridview_bf', parameterName: 'gridview_bf' },
            ],
        },
        {
            appfunctag: '_3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqmonitorgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqmonitors/:emeqmonitor?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqmonitors', parameterName: 'emeqmonitor' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto24',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqlctgsstabexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqlctgsses/:emeqlctgss?/tabexpview/:tabexpview?',
            parameters: [
                { pathName: 'emeqlctgsses', parameterName: 'emeqlctgss' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
        },
        {
            appfunctag: 'Auto39',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emassetcleargridview_5564',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emassetclears/:emassetclear?/gridview_5564/:gridview_5564?',
            parameters: [
                { pathName: 'emassetclears', parameterName: 'emassetclear' },
                { pathName: 'gridview_5564', parameterName: 'gridview_5564' },
            ],
        },
        {
            appfunctag: 'Auto29',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emassetgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emassets/:emasset?/gridview/:gridview?',
            parameters: [
                { pathName: 'emassets', parameterName: 'emasset' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto58',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emwocalendarexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emwos/:emwo?/calendarexpview/:calendarexpview?',
            parameters: [
                { pathName: 'emwos', parameterName: 'emwo' },
                { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
            ],
        },
        {
            appfunctag: '_9',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqkprcdgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqkprcds/:emeqkprcd?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqkprcds', parameterName: 'emeqkprcd' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto30',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emrfoacgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emrfoacs/:emrfoac?/gridview/:gridview?',
            parameters: [
                { pathName: 'emrfoacs', parameterName: 'emrfoac' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto32',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emenconsumgridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emenconsums/:emenconsum?/gridview/:gridview?',
            parameters: [
                { pathName: 'emenconsums', parameterName: 'emenconsum' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto1',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqtypetreeexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqtypes/:emeqtype?/treeexpview/:treeexpview?',
            parameters: [
                { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                { pathName: 'treeexpview', parameterName: 'treeexpview' },
            ],
        },
        {
            appfunctag: 'Auto21',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqtypetreeexpview2',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqtypes/:emeqtype?/treeexpview2/:treeexpview2?',
            parameters: [
                { pathName: 'emeqtypes', parameterName: 'emeqtype' },
                { pathName: 'treeexpview2', parameterName: 'treeexpview2' },
            ],
        },
        {
            appfunctag: 'Auto48',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emrfocagridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emrfocas/:emrfoca?/gridview/:gridview?',
            parameters: [
                { pathName: 'emrfocas', parameterName: 'emrfoca' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto33',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emeqdebuggridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emeqdebugs/:emeqdebug?/gridview/:gridview?',
            parameters: [
                { pathName: 'emeqdebugs', parameterName: 'emeqdebug' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto5',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emwo_engridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emwo_ens/:emwo_en?/gridview/:gridview?',
            parameters: [
                { pathName: 'emwo_ens', parameterName: 'emwo_en' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto13',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emitemrouttabexpview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emitemrouts/:emitemrout?/tabexpview/:tabexpview?',
            parameters: [
                { pathName: 'emitemrouts', parameterName: 'emitemrout' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
        },
        {
            appfunctag: 'Auto26',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'emrfodetypegridview',
            deResParameters: [],
            routepath: '/appindex/:appindex?/emrfodetypes/:emrfodetype?/gridview/:gridview?',
            parameters: [
                { pathName: 'emrfodetypes', parameterName: 'emrfodetype' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof IndexViewModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof IndexViewModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}