/**
 * Main2 部件模型
 *
 * @export
 * @class Main2Model
 */
export default class Main2Model {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'objid',
          prop: 'objid',
          dataType: 'PICKUP',
        },
        {
          name: 'planname',
          prop: 'planname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'equipname',
          prop: 'equipname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'lastval',
          prop: 'lastval',
          dataType: 'TEXT',
        },
        {
          name: 'nowval',
          prop: 'nowval',
          dataType: 'TEXT',
        },
        {
          name: 'equipid',
          prop: 'equipid',
          dataType: 'PICKUP',
        },
        {
          name: 'triggerdp',
          prop: 'triggerdp',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfmajortext',
          prop: 'emplancdtname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'emplancdtid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'emplancdtid',
          dataType: 'GUID',
        },
        {
          name: 'planid',
          prop: 'planid',
          dataType: 'PICKUP',
        },
        {
          name: 'dpvaltype',
          prop: 'dpvaltype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'dptype',
          prop: 'dptype',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'description',
          prop: 'description',
          dataType: 'TEXT',
        },
        {
          name: 'dpname',
          prop: 'dpname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'dpid',
          prop: 'dpid',
          dataType: 'PICKUP',
        },
        {
          name: 'objname',
          prop: 'objname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'triggerval',
          prop: 'triggerval',
          dataType: 'TEXT',
        },
        {
          name: 'emplancdt',
          prop: 'emplancdtid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}