import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import EMStockService from '@/service/emstock/emstock-service';
import StockCntBarModel from './stock-cnt-bar-chart-model';


/**
 * StockCntBar 部件服务对象
 *
 * @export
 * @class StockCntBarService
 */
export default class StockCntBarService extends ControlService {

    /**
     * 库存服务对象
     *
     * @type {EMStockService}
     * @memberof StockCntBarService
     */
    public appEntityService: EMStockService = new EMStockService({ $store: this.getStore() });

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof StockCntBarService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of StockCntBarService.
     * 
     * @param {*} [opts={}]
     * @memberof StockCntBarService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new StockCntBarModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof StockCntBarService
     */
    @Errorlog
    public search(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }
}