package cn.ibizlab.eam.core.eam_core.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.eam.util.domain.EntityBase;
import cn.ibizlab.eam.util.annotation.DEField;
import cn.ibizlab.eam.util.enums.DEPredefinedFieldType;
import cn.ibizlab.eam.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.eam.util.domain.EntityMP;

/**
 * 实体[特种设备标准化管理]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "SRFT_EMDRWG1_BASE",resultMap = "EMDRWG1ResultMap")
public class EMDRWG1 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 特种设备标准化管理名称
     */
    @TableField(value = "emdrwg1name")
    @JSONField(name = "emdrwg1name")
    @JsonProperty("emdrwg1name")
    private String emdrwg1name;
    /**
     * 内容
     */
    @TableField(value = "content")
    @JSONField(name = "content")
    @JsonProperty("content")
    private String content;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 逻辑有效标志
     */
    @DEField(defaultValue = "1" , preType = DEPredefinedFieldType.LOGICVALID, logicval = "1" , logicdelval="0")
    @TableLogic(value= "1",delval="0")
    @TableField(value = "enable")
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;
    /**
     * 文档代码
     */
    @TableField(value = "drwgcode")
    @JSONField(name = "drwgcode")
    @JsonProperty("drwgcode")
    private String drwgcode;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 特种设备标准化管理标识
     */
    @DEField(isKeyField=true)
    @TableId(value= "emdrwg1id",type=IdType.ASSIGN_UUID)
    @JSONField(name = "emdrwg1id")
    @JsonProperty("emdrwg1id")
    private String emdrwg1id;
    /**
     * 描述
     */
    @TableField(value = "description")
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;
    /**
     * 文档信息
     */
    @TableField(exist = false)
    @JSONField(name = "drwginfo")
    @JsonProperty("drwginfo")
    private String drwginfo;



    /**
     * 设置 [特种设备标准化管理名称]
     */
    public void setEmdrwg1name(String emdrwg1name){
        this.emdrwg1name = emdrwg1name ;
        this.modify("emdrwg1name",emdrwg1name);
    }

    /**
     * 设置 [内容]
     */
    public void setContent(String content){
        this.content = content ;
        this.modify("content",content);
    }

    /**
     * 设置 [文档代码]
     */
    public void setDrwgcode(String drwgcode){
        this.drwgcode = drwgcode ;
        this.modify("drwgcode",drwgcode);
    }

    /**
     * 设置 [描述]
     */
    public void setDescription(String description){
        this.description = description ;
        this.modify("description",description);
    }


}


