package cn.ibizlab.eam.core.eam_core.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.eam.util.domain.EntityBase;
import cn.ibizlab.eam.util.annotation.DEField;
import cn.ibizlab.eam.util.enums.DEPredefinedFieldType;
import cn.ibizlab.eam.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.eam.util.domain.EntityMP;

/**
 * 实体[文档引用]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "SRFT_EMDRWGMAP_BASE",resultMap = "EMDRWGMapResultMap")
public class EMDRWGMap extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 文档引用
     */
    @DEField(defaultValue = "VAR_DRWGID||-||VAR_REFOBJID")
    @TableField(value = "emdrwgmapname")
    @JSONField(name = "emdrwgmapname")
    @JsonProperty("emdrwgmapname")
    private String emdrwgmapname;
    /**
     * 描述
     */
    @TableField(value = "description")
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 文档引用标识
     */
    @DEField(isKeyField=true)
    @TableId(value= "emdrwgmapid",type=IdType.ASSIGN_UUID)
    @JSONField(name = "emdrwgmapid")
    @JsonProperty("emdrwgmapid")
    private String emdrwgmapid;
    /**
     * 逻辑有效标志
     */
    @DEField(defaultValue = "1" , preType = DEPredefinedFieldType.LOGICVALID, logicval = "1" , logicdelval="0")
    @TableLogic(value= "1",delval="0")
    @TableField(value = "enable")
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;
    /**
     * 组织
     */
    @DEField(preType = DEPredefinedFieldType.ORGID)
    @TableField(value = "orgid")
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 引用对象
     */
    @TableField(exist = false)
    @JSONField(name = "refobjname")
    @JsonProperty("refobjname")
    private String refobjname;
    /**
     * 文档
     */
    @TableField(exist = false)
    @JSONField(name = "drwgname")
    @JsonProperty("drwgname")
    private String drwgname;
    /**
     * 引用对象
     */
    @TableField(value = "refobjid")
    @JSONField(name = "refobjid")
    @JsonProperty("refobjid")
    private String refobjid;
    /**
     * 文档
     */
    @TableField(value = "drwgid")
    @JSONField(name = "drwgid")
    @JsonProperty("drwgid")
    private String drwgid;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.eam.core.eam_core.domain.EMDRWG drwg;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.eam.core.eam_core.domain.EMObject refobj;



    /**
     * 设置 [文档引用]
     */
    public void setEmdrwgmapname(String emdrwgmapname){
        this.emdrwgmapname = emdrwgmapname ;
        this.modify("emdrwgmapname",emdrwgmapname);
    }

    /**
     * 设置 [描述]
     */
    public void setDescription(String description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [引用对象]
     */
    public void setRefobjid(String refobjid){
        this.refobjid = refobjid ;
        this.modify("refobjid",refobjid);
    }

    /**
     * 设置 [文档]
     */
    public void setDrwgid(String drwgid){
        this.drwgid = drwgid ;
        this.modify("drwgid",drwgid);
    }


}


