package cn.ibizlab.eam.core.eam_core.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.eam.util.domain.EntityBase;
import cn.ibizlab.eam.util.annotation.DEField;
import cn.ibizlab.eam.util.enums.DEPredefinedFieldType;
import cn.ibizlab.eam.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.eam.util.domain.EntityMP;

/**
 * 实体[物品替换件]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "SRFT_EMITEMSUBMAP_BASE",resultMap = "EMItemSubMapResultMap")
public class EMItemSubMap extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 物品替换件标识
     */
    @DEField(isKeyField=true)
    @TableId(value= "emitemsubmapid",type=IdType.ASSIGN_UUID)
    @JSONField(name = "emitemsubmapid")
    @JsonProperty("emitemsubmapid")
    private String emitemsubmapid;
    /**
     * 物品替换件名称
     */
    @DEField(defaultValue = "NAME")
    @TableField(value = "emitemsubmapname")
    @JSONField(name = "emitemsubmapname")
    @JsonProperty("emitemsubmapname")
    private String emitemsubmapname;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 替换系数
     */
    @DEField(defaultValue = "1")
    @TableField(value = "subcoeff")
    @JSONField(name = "subcoeff")
    @JsonProperty("subcoeff")
    private Double subcoeff;
    /**
     * 互换标志
     */
    @TableField(value = "excflag")
    @JSONField(name = "excflag")
    @JsonProperty("excflag")
    private Integer excflag;
    /**
     * 组织
     */
    @DEField(defaultValue = "TIP" , preType = DEPredefinedFieldType.ORGID)
    @TableField(value = "orgid")
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 逻辑有效标志
     */
    @DEField(defaultValue = "1" , preType = DEPredefinedFieldType.LOGICVALID, logicval = "1" , logicdelval="0")
    @TableLogic(value= "1",delval="0")
    @TableField(value = "enable")
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;
    /**
     * 描述
     */
    @TableField(value = "description")
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 替换物品
     */
    @TableField(exist = false)
    @JSONField(name = "subitemname")
    @JsonProperty("subitemname")
    private String subitemname;
    /**
     * 物品
     */
    @TableField(exist = false)
    @JSONField(name = "itemname")
    @JsonProperty("itemname")
    private String itemname;
    /**
     * 物品
     */
    @TableField(value = "itemid")
    @JSONField(name = "itemid")
    @JsonProperty("itemid")
    private String itemid;
    /**
     * 替换物品
     */
    @TableField(value = "subitemid")
    @JSONField(name = "subitemid")
    @JsonProperty("subitemid")
    private String subitemid;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.eam.core.eam_core.domain.EMItem item;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.eam.core.eam_core.domain.EMItem subitem;



    /**
     * 设置 [物品替换件名称]
     */
    public void setEmitemsubmapname(String emitemsubmapname){
        this.emitemsubmapname = emitemsubmapname ;
        this.modify("emitemsubmapname",emitemsubmapname);
    }

    /**
     * 设置 [替换系数]
     */
    public void setSubcoeff(Double subcoeff){
        this.subcoeff = subcoeff ;
        this.modify("subcoeff",subcoeff);
    }

    /**
     * 设置 [互换标志]
     */
    public void setExcflag(Integer excflag){
        this.excflag = excflag ;
        this.modify("excflag",excflag);
    }

    /**
     * 设置 [描述]
     */
    public void setDescription(String description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [物品]
     */
    public void setItemid(String itemid){
        this.itemid = itemid ;
        this.modify("itemid",itemid);
    }

    /**
     * 设置 [替换物品]
     */
    public void setSubitemid(String subitemid){
        this.subitemid = subitemid ;
        this.modify("subitemid",subitemid);
    }


}


