package cn.ibizlab.eam.core.eam_core.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.eam.util.domain.EntityBase;
import cn.ibizlab.eam.util.annotation.DEField;
import cn.ibizlab.eam.util.enums.DEPredefinedFieldType;
import cn.ibizlab.eam.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.eam.util.domain.EntityMP;

/**
 * 实体[维修中心月度计划]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "SRFT_EMMONTHLY_BASE",resultMap = "EMMonthlyResultMap")
public class EMMonthly extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 编号
     */
    @DEField(isKeyField=true)
    @TableId(value= "emmonthlyid",type=IdType.ASSIGN_UUID)
    @JSONField(name = "emmonthlyid")
    @JsonProperty("emmonthlyid")
    private String emmonthlyid;
    /**
     * 逻辑有效标志
     */
    @DEField(defaultValue = "1" , preType = DEPredefinedFieldType.LOGICVALID, logicval = "1" , logicdelval="0")
    @TableLogic(value= "1",delval="0")
    @TableField(value = "enable")
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;
    /**
     * 安全工作
     */
    @TableField(value = "safework")
    @JSONField(name = "safework")
    @JsonProperty("safework")
    private String safework;
    /**
     * 上个月设备例会布置任务完成情况
     */
    @TableField(value = "lastmonth2")
    @JSONField(name = "lastmonth2")
    @JsonProperty("lastmonth2")
    private String lastmonth2;
    /**
     * 报告名称
     */
    @TableField(value = "emmonthlyname")
    @JSONField(name = "emmonthlyname")
    @JsonProperty("emmonthlyname")
    private String emmonthlyname;
    /**
     * 上月份其他主要应急维修及临时任务完成情况
     */
    @TableField(value = "lastmonth")
    @JSONField(name = "lastmonth")
    @JsonProperty("lastmonth")
    private String lastmonth;
    /**
     * 本月份计划维修工作
     */
    @TableField(value = "thismonth")
    @JSONField(name = "thismonth")
    @JsonProperty("thismonth")
    private String thismonth;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;



    /**
     * 设置 [安全工作]
     */
    public void setSafework(String safework){
        this.safework = safework ;
        this.modify("safework",safework);
    }

    /**
     * 设置 [上个月设备例会布置任务完成情况]
     */
    public void setLastmonth2(String lastmonth2){
        this.lastmonth2 = lastmonth2 ;
        this.modify("lastmonth2",lastmonth2);
    }

    /**
     * 设置 [报告名称]
     */
    public void setEmmonthlyname(String emmonthlyname){
        this.emmonthlyname = emmonthlyname ;
        this.modify("emmonthlyname",emmonthlyname);
    }

    /**
     * 设置 [上月份其他主要应急维修及临时任务完成情况]
     */
    public void setLastmonth(String lastmonth){
        this.lastmonth = lastmonth ;
        this.modify("lastmonth",lastmonth);
    }

    /**
     * 设置 [本月份计划维修工作]
     */
    public void setThismonth(String thismonth){
        this.thismonth = thismonth ;
        this.modify("thismonth",thismonth);
    }


}


