package cn.ibizlab.eam.core.eam_core.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.eam.core.eam_core.domain.EMDRWG;
import cn.ibizlab.eam.core.eam_core.filter.EMDRWGSearchContext;


import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[EMDRWG] 服务对象接口
 */
public interface IEMDRWGService extends IService<EMDRWG>{

    boolean create(EMDRWG et) ;
    void createBatch(List<EMDRWG> list) ;
    boolean update(EMDRWG et) ;
    void updateBatch(List<EMDRWG> list) ;
    boolean remove(String key) ;
    void removeBatch(Collection<String> idList) ;
    EMDRWG get(String key) ;
    EMDRWG getDraft(EMDRWG et) ;
    boolean checkKey(EMDRWG et) ;
    EMDRWG genId(EMDRWG et) ;
    boolean save(EMDRWG et) ;
    void saveBatch(List<EMDRWG> list) ;
    Page<EMDRWG> searchDefault(EMDRWGSearchContext context) ;
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<EMDRWG> getEmdrwgByIds(List<String> ids) ;
    List<EMDRWG> getEmdrwgByEntities(List<EMDRWG> entities) ;
}


