package cn.ibizlab.eam.core.eam_core.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.eam.core.eam_core.domain.EMEIBattery;
import cn.ibizlab.eam.core.eam_core.filter.EMEIBatterySearchContext;


import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[EMEIBattery] 服务对象接口
 */
public interface IEMEIBatteryService extends IService<EMEIBattery>{

    boolean create(EMEIBattery et) ;
    void createBatch(List<EMEIBattery> list) ;
    boolean update(EMEIBattery et) ;
    void updateBatch(List<EMEIBattery> list) ;
    boolean remove(String key) ;
    void removeBatch(Collection<String> idList) ;
    EMEIBattery get(String key) ;
    EMEIBattery getDraft(EMEIBattery et) ;
    boolean checkKey(EMEIBattery et) ;
    boolean save(EMEIBattery et) ;
    void saveBatch(List<EMEIBattery> list) ;
    Page<EMEIBattery> searchDefault(EMEIBatterySearchContext context) ;
    List<EMEIBattery> selectByEqlocationid(String emeqlocationid) ;
    void removeByEqlocationid(String emeqlocationid) ;
    List<EMEIBattery> selectByEquipid(String emequipid) ;
    void removeByEquipid(String emequipid) ;
    List<EMEIBattery> selectByItempuseid(String emitempuseid) ;
    void removeByItempuseid(String emitempuseid) ;
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<EMEIBattery> getEmeibatteryByIds(List<String> ids) ;
    List<EMEIBattery> getEmeibatteryByEntities(List<EMEIBattery> entities) ;
}


