package cn.ibizlab.eam.core.eam_core.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.eam.core.eam_core.domain.EMEICellReturn;
import cn.ibizlab.eam.core.eam_core.filter.EMEICellReturnSearchContext;


import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[EMEICellReturn] 服务对象接口
 */
public interface IEMEICellReturnService extends IService<EMEICellReturn>{

    boolean create(EMEICellReturn et) ;
    void createBatch(List<EMEICellReturn> list) ;
    boolean update(EMEICellReturn et) ;
    void updateBatch(List<EMEICellReturn> list) ;
    boolean remove(String key) ;
    void removeBatch(Collection<String> idList) ;
    EMEICellReturn get(String key) ;
    EMEICellReturn getDraft(EMEICellReturn et) ;
    boolean checkKey(EMEICellReturn et) ;
    boolean save(EMEICellReturn et) ;
    void saveBatch(List<EMEICellReturn> list) ;
    Page<EMEICellReturn> searchDefault(EMEICellReturnSearchContext context) ;
    List<EMEICellReturn> selectByEiobjid(String emeicellid) ;
    void removeByEiobjid(String emeicellid) ;
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<EMEICellReturn> getEmeicellreturnByIds(List<String> ids) ;
    List<EMEICellReturn> getEmeicellreturnByEntities(List<EMEICellReturn> entities) ;
}


