package cn.ibizlab.eam.core.eam_core.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.eam.core.eam_core.domain.EMEQKP;
import cn.ibizlab.eam.core.eam_core.filter.EMEQKPSearchContext;


import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[EMEQKP] 服务对象接口
 */
public interface IEMEQKPService extends IService<EMEQKP>{

    boolean create(EMEQKP et) ;
    void createBatch(List<EMEQKP> list) ;
    boolean update(EMEQKP et) ;
    void updateBatch(List<EMEQKP> list) ;
    boolean remove(String key) ;
    void removeBatch(Collection<String> idList) ;
    EMEQKP get(String key) ;
    EMEQKP getDraft(EMEQKP et) ;
    boolean checkKey(EMEQKP et) ;
    boolean save(EMEQKP et) ;
    void saveBatch(List<EMEQKP> list) ;
    Page<EMEQKP> searchDefault(EMEQKPSearchContext context) ;
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<EMEQKP> getEmeqkpByIds(List<String> ids) ;
    List<EMEQKP> getEmeqkpByEntities(List<EMEQKP> entities) ;
}


