package cn.ibizlab.eam.core.eam_core.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.eam.core.eam_core.domain.EMOutputRct;
import cn.ibizlab.eam.core.eam_core.filter.EMOutputRctSearchContext;


import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[EMOutputRct] 服务对象接口
 */
public interface IEMOutputRctService extends IService<EMOutputRct>{

    boolean create(EMOutputRct et) ;
    void createBatch(List<EMOutputRct> list) ;
    boolean update(EMOutputRct et) ;
    void updateBatch(List<EMOutputRct> list) ;
    boolean remove(String key) ;
    void removeBatch(Collection<String> idList) ;
    EMOutputRct get(String key) ;
    EMOutputRct getDraft(EMOutputRct et) ;
    boolean checkKey(EMOutputRct et) ;
    boolean save(EMOutputRct et) ;
    void saveBatch(List<EMOutputRct> list) ;
    Page<EMOutputRct> searchDefault(EMOutputRctSearchContext context) ;
    List<EMOutputRct> selectByEquipid(String emequipid) ;
    void removeByEquipid(String emequipid) ;
    List<EMOutputRct> selectByObjid(String emobjectid) ;
    void removeByObjid(String emobjectid) ;
    List<EMOutputRct> selectByOutputid(String emoutputid) ;
    void removeByOutputid(String emoutputid) ;
    List<EMOutputRct> selectByWoid(String emwoid) ;
    void removeByWoid(String emwoid) ;
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<EMOutputRct> getEmoutputrctByIds(List<String> ids) ;
    List<EMOutputRct> getEmoutputrctByEntities(List<EMOutputRct> entities) ;
}


